/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

import Qt 4.7
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    id: delegate;
    width: parent.width;
    height: 66;

    property string avatarSource;
    property string displayName;
    property bool enabled;
    property string nickName;
    property string presenceType;
    property int presenceTypeId;
    property string presenceStatus;
    property string accountIconName;

    signal avatarChanged();     // notify about an avatar change
    signal presenceChanged();   // notify about a change in the presence

    Avatar {
        id: avatar;
        avatarPath: avatarSource;
        presenceId: presenceTypeId;
        anchors.left: parent.left;

        onAvatarChanged: {
            avatarSource = newAvatarSource;
            delegate.avatarChanged();
        }
    }

    UserInfo {
        id: userInfo;
        nick: nickName;
        email: displayName;
        accountIcon: accountIconName;

        height: 25;

        anchors {
            left: avatar.right;
            right: delegate.right;
            top: delegate.top;
            margins: 5;
        }
    }

    PresenceChooser {
        id: presenceChooser;
        flipEnabled: delegate.enabled;
        presenceIconType: presenceType;
        presenceText: presenceStatus;

        anchors {
            top: userInfo.bottom;
            left: avatar.right;
            right: delegate.right;
            bottom: avatar.bottom;
            margins: 5;
        }

        onPresenceChanged: {
            // what I get from signal: presenceId, presenceIconName, presenceText
            presenceTypeId = presenceId;
            presenceType = presenceIconName;
            presenceStatus = presenceText;

            delegate.presenceChanged();
        }
    }

    PlasmaWidgets.Separator {
        id: delegateSeparator;
        orientation: QtHorizontal;

        anchors {
            left: parent.left;
            top: avatar.bottom;
            right: parent.right;
            topMargin: 4;
            leftMargin: parent.width/4;
            rightMargin: parent.width/4;
        }
    }
}
