/***************************************************************************
 *   Copyright (C) 2011 by Francesco Nwokeka <francesco.nwokeka@gmail.com> *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA            *
 ***************************************************************************/

import Qt 4.7
import org.kde.plasma.core 0.1 as PlasmaCore
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    id: userInfo;

    property string nick;
    property string email;
    property string accountIcon;

    property bool hasPersonalMessage: false;

    // get color from current plasma theme
    property QtObject theme: PlasmaCore.Theme {}

    anchors {
        left: parent.left;
        right: parent.right;
        rightMargin: 10;
    }

    PlasmaWidgets.IconWidget {
        id: protocolIcon;
        width: 22;
        height: 22;

        anchors {
            left: parent.left;
            top: parent.top;
        }

        Component.onCompleted: {
            setIcon(accountIcon);
        }
    }

    Text {
        id: nickText
        width: parent.width - protocolIcon.width;

        anchors {
            left: protocolIcon.right;
            leftMargin: 4;
        }

        text: nick;
        font.bold: true;
        color: theme.textColor;
        elide: Text.ElideRight;
    }

    Text {
        id: emailText;
        width: nickText.width;

        anchors {
            left: protocolIcon.right;
            leftMargin: 4;
        }

        text:  email;
        color: theme.textColor;
        elide: Text.ElideRight;
        anchors.top: nickText.bottom;
        anchors.topMargin: 0;
    }
}
