#include <stdio.h>
#include "hangul.h"

#define CONSONANT 0
#define VOWEL 1

enum HAN_STATE {
	HS_START,
	HS_CHOSUNG,
	HS_JOONGSUNG, HS_DJOONGSUNG,
	HS_JONGSUNG, HS_DJONGSUNG,
	HS_END1, HS_END2
};

/* ---------------------------------------------------------------------
   HS_END1 HS_END2 ٸ  HS_END2 ѱ۳ڰ յǰ ִ 
          ߿   Է
     ̶  ϳ  ڷ Ѱ ϱ 
     Էµ ڿ   2 ѰѴ. 
   ݸ鿡 HS_END1 ڰ յǰ ִ   Էµ 
      ٽ       
       ϳ ڷ ѱ ȴ. ׸ ̻ 
   յ     쿡   ϳ ڷ ѱ
    ȴ.  HS_END2 2 ½ÿ ѱ HS_END1 ϳ
    ½ÿ ѱ  ٸ ۵Ѵ.  
--------------------------------------------------------------------- */

static int	tempUnionCode;
static int 	oldKey;
static int	keyCode;

/*  ̷  ˻Ѵ. ã شϴ ڵ带 ְ
   ƴϸ 0 ش. */
static int joongsungPair(void) {
	static byte dJoongTable[7][3] = {
		{ 0xad, 0xa3, 0xae },		/* , ,  */
		{ 0xad, 0xa4, 0xaf },		/* , ,  */
		{ 0xad, 0xbd, 0xb2 },		/* , ,  */
		{ 0xb4, 0xa7, 0xb5 },		/* , ,  */
		{ 0xb4, 0xaa, 0xb6 },		/* , ,  */
		{ 0xb4, 0xbd, 0xb7 }, 	/* , ,  */
		{ 0xbb, 0xbd, 0xbc }		/* , ,  */
  };
	int i;

	/*  Էµ Ű  Էµ Ű  ̺  */
	/*   ˻Ѵ.                                            */
	for (i = 0; i < 7; i++) {
		if (dJoongTable[i][0] == oldKey && dJoongTable[i][1] == keyCode)
			return ((keyCode = dJoongTable[i][2]));
	}
	return 0;
}

/* ħ ̷  ˻Ѵ.  ã شϴ Ű ְ 
   ƴϸ 0 ش. */
static int jongsungPair(void) {
	static byte dJongTable[11][3] = {
		{ 0x82, 0x8b, 0xc4 },		/* , */
		{ 0x84, 0x8e, 0xc6 },		/* , */
		{ 0x84, 0x94, 0xc7 },		/* , */
		{ 0x87, 0x82, 0xca },		/* , */
		{ 0x87, 0x88, 0xcb },		/* , */
		{ 0x87, 0x89, 0xcc },		/* , */
		{ 0x87, 0x8b, 0xcd },		/* , */
		{ 0x87, 0x92, 0xce },		/* , */
		{ 0x87, 0x93, 0xcf },		/* , */
		{ 0x87, 0x94, 0xd0 },		/* , */
		{ 0x89, 0x8b, 0xd4 }		/* , */
	};
	int i;

	/*  Էµ Ű  Էµ Ű ħ ̺ ãƼ
	   ִ ˻Ѵ. */
	for (i = 0; i < 11; i++) {
		if (dJongTable[i][0] == oldKey && dJongTable[i][1] == keyCode)
			return (keyCode = dJongTable[i][2]);
	}
	return 0;
}

/********************************************************************
	                ι 丶Ÿ
********************************************************************/

int hanAutomata2(int key) { 

/*--------------------------------------------------------------------
   : key = Էµ Ű ڵ
ȯ :     1,  ̸ 0,
         ϼ  ڵ Է   
           ִ. 
   : 
--------------------------------------------------------------------*/

	int chKind, canBeJongsung = FALSE;
	/* ʼڵ忡 ϴ  ڵ */
	static byte Cho2Jong[] = {	
		0xc2,	/*  ⿪                 */ 
		0xc3,	/*  ֱ⿪               */
		0xc5,	/*                   */
		0xc8,	/*                   */
		0x00,	/*  ֵ (ش )   */
		0xc9,	/*  	               */
		0xd1,	/*                   */
		0xd3,	/*  	               */
		0x00,	/*   (ش )	 */
		0xd5,	/*  ÿ                 */
		0xd6,	/*  ֽÿ               */
		0xd7,	/*  				         */
		0xd8,	/*  				         */
		0x00,	/*   (ش )   */
		0xd9,	/*  ġ                 */
		0xda,	/*  Ű          	     */	
		0xdb,	/*  Ƽ                 */
		0xdc,	/*  ϡ    					 */
		0xdd	/*                   */
  };

/* --------------------------------------------------------------------- 
   Էµ ڰ  ΰ ϰ  ѱԷ»¿ յ
   ڵ带  丶Ÿ ۾غ κ 
--------------------------------------------------------------------- */

	/* ۼ谡  쿡  01100000b  & ϸ 00100000b ȴ. */
	if ((key & 0x60) == 0x20) {
		chKind = VOWEL;   /*  */
	}	else {
		chKind = CONSONANT; /*  ̿ܿ  */
		/* ֵ, ֺ,  ħ   . */
		if (!(key == 0x86 || key == 0x8A || key == 0x8F))
			canBeJongsung = TRUE;
	}
	/*  ѱ Էµǰ ִٸ   ÿ յ
	   ڵ Էµ ۼ踦 ´. */
	if (tempHanState) {
		tempUnionCode = inStack[inSP - 1].unionCode;
		oldKey = inStack[inSP - 1].key;
	}	else {
		/* ó̶..*/
		/* 0x8441  ʼ, ߼,  ä OR */
		tempUnionCode = 0x8441;  
		oldKey = 0;
	}
	keyCode = key; /* ۾ keyCode  */

/* --------------------------------------------------------------------- 
    ѱ յ  (unionCode Ǵ tempUnionCode)  Էµ
   ڰ  ΰ  ջ¸ ٽ  ŸŸ ֿκ 
--------------------------------------------------------------------- */

	switch (tempHanState) {
		case HS_START : /* ѱԷ ó̰ */
			if (chKind == CONSONANT) /*  Դٸ ʼ· */ 
				tempHanState = HS_CHOSUNG;
			else 	                   /* ̶ ߼· */
				tempHanState = HS_JOONGSUNG;
			break;
		case HS_CHOSUNG : /* ʼ ̹ Է Ǿ */
			if (chKind == VOWEL) /*  Դٸ */
				tempHanState = HS_JOONGSUNG; /* ߼· !! */
			else
				/* 2Ŀ ʼ ι  Է  . */
				/*  ʼ  ¿ ʼ ٽ ´ٸ */
				/*   翬   . */
				tempHanState = HS_END1; 
			break;
		case HS_JOONGSUNG :   /* ߼ ̹  ְ */
			if (canBeJongsung)  /*    ִ ̶ */
				tempHanState = HS_JONGSUNG; /* · Ѵ. */
			/* ߼ Դٸ  ̷  ִ  ˻ؼ
			       ߼· . ̵  ƴ
			     . */
			else if (joongsungPair()) 
				tempHanState = HS_DJOONGSUNG;
			else
				tempHanState = HS_END1;
			break;
		case HS_DJOONGSUNG : /*  ̷ */
			if (canBeJongsung) /*    ִ ̶ */
				tempHanState = HS_JONGSUNG; /* · ... */ 
			else
				/* ̳      ¿ ޾Ƶ */
				/*  .                                                  */
				tempHanState = HS_END1; 
			break;
		case HS_JONGSUNG : /*  ̷ ְ */
			/*  ͼ  ̷  ִ ̶   */
			/* · .                               */
			if (chKind == CONSONANT && jongsungPair())
				tempHanState = HS_DJONGSUNG;
			/*   ´ٸ 2 . */
			else if (chKind == VOWEL)
				tempHanState = HS_END2;
			/*  ̷   ̶  . */
			else 
				tempHanState = HS_END1;  
			break;
		case HS_DJONGSUNG :  /*  ̷ ְ */
			if (chKind == VOWEL) /*  Դٸ 翬 2 */
				tempHanState = HS_END2;
			else
				tempHanState = HS_END1; /* ׿ܿ Ⱥ 1 */
			break;
  } 
/* --------------------------------------------------------------------- 
   ѱ۳ڸ ؼ ڵ带  ̴. κ ڿ 
    Ѵ. 
	
	 ʼڵ忡 0x80    ʼڵ尡  
	 ⼭ 10Ʈ  о   ִ ° ȴ.
	  յ ڵ忡 1000 0011 1111 1111  & ϸ ʼ
	 κ    ִ.   ORϸ ϴ յ
	 ڵ带   ִ.                                         

	  ߼ 0xA0   ߼ڵ带   ִ ,
	 ⼭  5Ʈ о 翬 հ ߼ڵ尡 
	 ´.  ڵ忡 0xFC1F &Ѵٴ  1111 1100 0001 1111
	  ߼κ  ٴ ̰   OR ϸ ϴ
	 ڵ带 ´. 

	   ٸ. 2Ŀ ʼ,   Ƿ 
	   ʼ ϰ  ֵ, ź, 
	    .  ó ʼ Ƿ ʼ 
	 ϴ ڵ尡 Ǿ ִ ̺ ε ãƾ Ѵ.
	 keyCode 0X82 ٴ   ʼڵ忡 äڸ 
	   ε ޱڴٴ ̰ ̰ ̺  
	   ڵ带 ´. 
	  ̹  dJongTable ˸´ ڵ ȯǾǷ
	 ̷  ʿ. ׷   0xC0   ڵ带
	   յ ڵ忡 1111 1111 1110 0000  & ؼ 
	 ڵκ  ؼ ̵ ORѴ. 
--------------------------------------------------------------------- */
	switch (tempHanState) { /* ѱ ڰ Է Ǿ  쿡 */
		case HS_CHOSUNG :     /* ʼڵ ó */
			tempUnionCode = (tempUnionCode & 0x83FF) | ((keyCode - 0x80) << 10);
			break;
		case HS_JOONGSUNG :   /* ߼ڵ ߼  óȴ. */
		case HS_DJOONGSUNG :  /* ߼ ڵ ó */
			tempUnionCode = (tempUnionCode & 0xFC1F) | ((keyCode - 0xA0) << 5);
			break;
		case HS_JONGSUNG :    /* ڵ ʼ2̺ ȯǾ Ѵ. */
			keyCode = Cho2Jong[keyCode - 0x82];
		case HS_DJONGSUNG :   /*    ڵ ó */
			tempUnionCode = (tempUnionCode & 0xFFE0) | (keyCode - 0xC0);
			break;
		case HS_END1 :       
			outStack[outSP++] = key; /* 糹 ϳ  ѱ. */
			return TRUE;
		case HS_END2 :
			/*  ڸ  ½ÿ ְ  ۼ踦   
			   ÿ ִ´.     ߿ ´. */
			outStack[outSP++] = key; 
			outStack[outSP++] = oldKey;
			inSP--;     /* Է½ÿ ϳ  Ƿ   */
			return TRUE; /* 1 ϷǾ ǹ */
	}
	inStack[inSP].currentHanState = tempHanState;
	inStack[inSP].unionCode = tempUnionCode;
	inStack[inSP++].key = key;
	return FALSE;  /*  ѱ  */
}
