#include <stdio.h>
#include "hangul.h"

enum HAN_STATE {
   HS_START,
   HS_CHOSUNG, HS_DCHOSUNG,
   HS_JOONGSUNG, HS_DJOONGSUNG,
   HS_JONGSUNG, HS_DJONGSUNG,
   HS_END
};
/* ---------------------------------------------------------------------
   3 ʼ, ߼,  ȴ.  ڸ ʼ, ߼, 
    ϸ 丶Ÿ  . 
   --------------------------------------------------------------------- */

enum HAN_CHKIND {
   CHOSUNG  = 0x00,    /* Էµ ڰ ʼ  */
   JOONGSUNG = 0x20,  /* Էµ ڰ ߼  */
   JONGSUNG = 0x40    /* Էµ ڰ   */
};

static int	tempUnionCode;
static int	oldKey;
static int	keyCode;

/* ʼ ΰ հѰ ˻ؼ ϸ ʼ ڵ带 ְ
   ƴϸ 0 ش. */
static int chosungPair(void) {
	static byte dChoTable[][3] = {
		{ 0x82, 0x82, 0x83 },   /* , ,  */
		{ 0x85, 0x85, 0x86 },   /* , ,  */
		{ 0x89, 0x89, 0x8a },   /* , ,  */
		{ 0x8b, 0x8b, 0x8c },   /* , ,  */
		{ 0x8e, 0x8e, 0x8f }   /* , ,  */
	};
	int i;

	for (i = 0; i < 5; i++) {
		if (dChoTable[i][0] == oldKey && dChoTable[i][1] == keyCode)
			return (keyCode = dChoTable[i][2]);
	}
	return 0;
}

/*  ̷  ˻Ѵ.   ϸ ߼ ڵ带 
   ְ ƴϸ 0 ش. */
static int joongsungPair(void) {
	static byte dJoongTable[][3] = {
		{ 0xad, 0xa3, 0xae },   /* , ,  */
		{ 0xad, 0xa4, 0xaf },   /* , ,  */
		{ 0xad, 0xbd, 0xb2 },   /* , ,  */
		{ 0xb4, 0xa7, 0xb5 },   /* , ,  */
		{ 0xb4, 0xaa, 0xb6 },   /* , ,  */
		{ 0xb4, 0xbd, 0xb7 },   /* , ,  */
		{ 0xbb, 0xbd, 0xbc }   /* , ,  */
	};
	int i;

	for (i = 0; i < 7; i++) {
		if (dJoongTable[i][0] == oldKey && dJoongTable[i][1] == keyCode)
			return (keyCode = dJoongTable[i][2]);
	}
	return 0;
}

/*  ̷  ˻Ѵ.  յ  ִٸ ش  ڵ
    ְ ƴϸ 0 ش. */
static int jongsungPair(void) {
	static byte dJongTable[][3] = {
		{ 0xc2, 0xc2, 0xc3 },   /* ⿪, ⿪ */ 
		{ 0xc2, 0xd5, 0xc4 },   /* ⿪, ÿ */
		{ 0xc5, 0xd8, 0xc6 },   /* ,  */
		{ 0xc5, 0xdd, 0xc7 },   /* ,  */
		{ 0xc9, 0xc2, 0xca },   /* , ⿪ */
		{ 0xc9, 0xd1, 0xcb },   /* ,  */
		{ 0xc9, 0xd3, 0xcc },   /* ,  */
		{ 0xc9, 0xd5, 0xcd },   /* , ÿ */
		{ 0xc9, 0xdb, 0xce },   /* , Ƽ */
		{ 0xc9, 0xdc, 0xcf },   /* ,  */
		{ 0xc9, 0xdd, 0xd0 },   /* ,  */
		{ 0xd3, 0xd5, 0xd4 },   /* , ÿ */
		{ 0xd5, 0xd5, 0xd6 }   /* ÿ, ÿ */
	};
	int i;

	for (i = 0; i < 13; i++) {
		if (dJongTable[i][0] == oldKey && dJongTable[i][1] == keyCode)
			return (keyCode = dJongTable[i][2]);
	}
	return 0;
}

/*********************************************************************** 
                      ŸŸ 
***********************************************************************/

/* 3Ŀ ʼڵ ڵ尡  ٸǷ ʼ,  ڵ
   ȯ ̺ ʿ.  */
int hanAutomata3(int key) {
/*--------------------------------------------------------------------- 
  Էµ ڸ ʼ, ߼,  ϰ  ѱԷ»¿ 
   ڵ带 Ѵ.                        
---------------------------------------------------------------------*/

	int chKind = key & 0x60;
	/* Է¹ ڿ 01100000 &ϸ 0x00, 0x20, 0x40 
	   ʼ, ߼,     ִ.   */
	if (tempHanState) {
		tempUnionCode = inStack[inSP-1].unionCode;
		oldKey	 = inStack[inSP-1].key;
	} else {
		tempUnionCode = 0x8441;
		oldKey = 0;
	}
	keyCode = key;

/*---------------------------------------------------------------------
	 ѱԷ»¿ Էµ    丶Ÿ ºȭ
	Ų. 
---------------------------------------------------------------------*/

	switch (tempHanState) {
		case HS_START :     /* ƹ ڵ Է    */
			switch (chKind) {
				case CHOSUNG :
					tempHanState = HS_CHOSUNG;
					break;
				case JOONGSUNG :
					tempHanState = HS_JOONGSUNG;
					break;
				case JONGSUNG :
					tempHanState = HS_JONGSUNG;
					break;
			}
			break;
		case HS_CHOSUNG :  /* ʼ ԷµǾ ִ  */
			switch (chKind) {
				case CHOSUNG :
					if (chosungPair())
						tempHanState = HS_DCHOSUNG;
					else
						tempHanState = HS_END;
					break;
				case JOONGSUNG :
					tempHanState = HS_JOONGSUNG;
					break;
				case JONGSUNG :
					tempHanState = HS_JONGSUNG;
					break;
			}
			break;
		case HS_DCHOSUNG :     /* ʼ ԷµǾ ִ  */
			switch (chKind) {
				case CHOSUNG :
					tempHanState = HS_END;
					break;
				case JOONGSUNG :
					tempHanState = HS_JOONGSUNG;
					break;
				case JONGSUNG :
					tempHanState = HS_JONGSUNG;
					break;
			}
			break;
		case HS_JOONGSUNG :    /* ߼ ԷµǾ ִ  */
			switch (chKind) {
				case CHOSUNG :
					tempHanState = HS_END;
					break;
				case JOONGSUNG :
					if (joongsungPair())
						tempHanState = HS_DJOONGSUNG;
					else 
						tempHanState = HS_END;
					break;
				case JONGSUNG :
					tempHanState = HS_JONGSUNG;
					break;
			}
			break;
		case HS_DJOONGSUNG :   /* ߼ ԷµǾ ִ  */
			switch (chKind) {
				case CHOSUNG :
				case JOONGSUNG :
					tempHanState = HS_END;
					break;
				case JONGSUNG :
					tempHanState = HS_JONGSUNG;
					break;
			}
			break;
		case HS_JONGSUNG :   /*  ԷµǾ ִ  */
			switch (chKind) {
				case CHOSUNG :
				case JOONGSUNG :
					tempHanState = HS_END;
					break;
				case JONGSUNG :
					if (jongsungPair())
						tempHanState = HS_DJONGSUNG;
					else
						tempHanState = HS_END;
					break;
			}
			break;
		case HS_DJONGSUNG :  /*  ԷµǾ ִ  */
			tempHanState = HS_END;
			break;
	}

/*---------------------------------------------------------------------
  Ӱ ȭ  ѱԷ»¿   ڸ  ó
  ؼ ڸ Ѵ. 
--------------------------------------------------------------------- */

	switch (tempHanState) {
		case HS_CHOSUNG :
		case HS_DCHOSUNG :
			tempUnionCode = (tempUnionCode & 0x83FF) | ((keyCode - 0x80) << 10);
			break;
		case HS_JOONGSUNG :
		case HS_DJOONGSUNG :
			tempUnionCode = (tempUnionCode & 0xFC1F) | ((keyCode - 0xA0) << 5);
			break;
		case HS_JONGSUNG :
		case HS_DJONGSUNG :
			tempUnionCode = (tempUnionCode & 0xFFE0) | (keyCode - 0xC0);
			break;
		case HS_END:
			/* ϳ ڰ   ¶  Ű ½
			    ´. */
			outStack[outSP++] = key;  
			return TRUE;
	}
	/*  ѱԷ»¿ յ ڵ, Էµ ڸ Է½
	    Ѵ. */
	inStack[inSP].currentHanState = tempHanState;
	inStack[inSP].unionCode = tempUnionCode;
	inStack[inSP++].key = key;
	return FALSE;
}
