/* hgraphics.h  */

#ifndef _HGRAPHICS_H 
#define _HGRAPHICS_H

#include <stdio.h>
#include <vga.h>
#include <vgagl.h>

#define H_BLACK          0
#define H_BLUE           1
#define H_GREEN          2
#define H_CYAN           3
#define H_RED            4
#define H_MAGENTA        5
#define H_BROWN          6
#define H_LIGHTGRAY      7
#define H_DARKGRAY       8
#define H_LIGHTBLUE      9
#define H_LIGHTGREEN     10
#define H_LIGHTCYAN      11
#define H_LIGHTRED       12
#define H_LIGHTMAGENTA   13
#define H_YELLOW         14
#define H_WHITE          15

extern int GL_X_POSITION;    /* Global X Position */
extern int GL_Y_POSITION;    /* Global Y Position */
extern int GL_FG_COLOR;      /* Global Foreground Color */
extern int GL_BG_COLOR;      /* Global Background Color */

#define hgetmaxx() (vga_getxdim()-1)
#define hgetmaxy() (vga_getydim()-1)
#define hgetmaxcolor() (vga_getcolors())
#define hgetx() (GL_X_POSITION)
#define hgety() (GL_Y_POSITION)
#define hgetxy(x, y) (x = GL_X_POSITION, y = GL_Y_POSITION)
#define hgetcolor() (GL_FG_COLOR)
#define hgetbkcolor() (GL_BG_COLOR)
#define hsetx(x) (GL_X_POSITION = x)
#define hsety(y) (GL_Y_POSITION = y)
#define hsetxy(x, y) (GL_X_POSITION = x, GL_Y_POSITION = y)
#define hsetcolor(c) (GL_FG_COLOR = c)
#define hsetbkcolor(c) (GL_BG_COLOR = c)
#define hsetallcolor(fg, bg) (GL_FG_COLOR = fg, GL_BG_COLOR = bg);
#define hsetpixel(x, y, c) (gl_setpixel(x, y, c))
#define hgetpixel(x, y) (gl_getpixel(x, y))
#define hcircle(x, y, r) (gl_circle(x, y, r, GL_FG_COLOR)
#define hmoveto(x, y) (GL_X_POSITION = x, GL_Y_POSITION = y)
#define hmoverel(x, y) (GL_X_POSITION += x, GL_Y_POSITION += y)
#define hline(x1, y1, x2, y2) (gl_line(x1, y1, x2, y2, GL_FG_COLOR))
#define hhline(x1, y, x2) (gl_hline(x1, y, x2, GL_FG_COLOR))
#define hlineto(x, y) (gl_line(GL_X_POSITION, GL_Y_POSITION, x, y,\
	GL_FG_COLOR), GL_X_POSITION = x, GL_Y_POSITION = y)
#define hlinerel(dx, dy) (gl_line(GL_X_POSITION, GL_Y_POSITION,\
	GL_X_POSITION + dx, GL_Y_POSITION + dy, GL_FG_COLOR),\
		GL_X_POSITION += dx, GL_Y_POSITION += dy)
#define hcleargraph(c) (gl_clearscreen(c))
#define hclearscreen(c) (gl_clearscreen(c), GL_X_POSITION = 0,\
	GL_Y_POSITION = 0, GL_BG_COLOR = c)
#define hcleardevice() (gl_clearscreen(GL_BG_COLOR), GL_X_POSITION = 0,\
	GL_Y_POSITION = 0)
#define hvga_getch() (vga_getch())
#define hkbhit() (vga_getkey())

void hrectangle(int x1, int y1, int x2, int y2, int color);
void hpaintbox(int x1, int y1, int w, int h,	int color, int depth);
int hbitmapsave(int x, int y, int w, int h, char *filename);
int hbitmapload(int x, int y, int w, int h, char *filename);
int hloadicon(int x, int y, char *iconfilename);

#endif /* hgraphics.h */
