# Отладка { #debugging }

Вы можете подключить отладчик в своем редакторе, например, в Visual Studio Code или PyCharm.

## Вызов `uvicorn` { #call-uvicorn }

В вашем FastAPI приложении, импортируйте и вызовите `uvicorn` напрямую:

{* ../../docs_src/debugging/tutorial001_py310.py hl[1,15] *}

### Описание `__name__ == "__main__"` { #about-name-main }

Главная цель использования `__name__ == "__main__"` в том, чтобы код выполнялся при запуске файла с помощью:

<div class="termy">

```console
$ python myapp.py
```

</div>

но не вызывался, когда другой файл импортирует это, например:

```Python
from myapp import app
```

#### Больше деталей { #more-details }

Давайте назовём ваш файл `myapp.py`.

Если вы запустите его с помощью:

<div class="termy">

```console
$ python myapp.py
```

</div>

то встроенная переменная `__name__`, автоматически создаваемая Python в вашем файле, будет иметь значение строкового типа `"__main__"`.

Тогда эта часть кода:

```Python
    uvicorn.run(app, host="0.0.0.0", port=8000)
```

будет запущена.

---

Но этого не произойдет, если вы импортируете этот модуль (файл).

Таким образом, если у вас есть файл `importer.py` с таким импортом:

```Python
from myapp import app

# Еще немного кода
```

то автоматическая создаваемая внутри файла `myapp.py` переменная  `__name__` будет иметь значение отличающееся от `"__main__"`.

Следовательно, строка:

```Python
    uvicorn.run(app, host="0.0.0.0", port=8000)
```

не будет выполнена.

/// info | Информация

Для получения дополнительной информации, ознакомьтесь с <a href="https://docs.python.org/3/library/__main__.html" class="external-link" target="_blank">официальной документацией Python</a>.

///

## Запуск вашего кода с помощью отладчика { #run-your-code-with-your-debugger }

Так как вы запускаете сервер Uvicorn непосредственно из вашего кода, вы можете вызвать Python программу (ваше FastAPI приложение) напрямую из отладчика.

---

Например, в Visual Studio Code вы можете выполнить следующие шаги:

* Перейдите на панель "Debug".
* Выберите "Add configuration...".
* Выберите "Python"
* Запустите отладчик "`Python: Current File (Integrated Terminal)`".

Это запустит сервер с вашим **FastAPI** кодом, остановится на точках останова, и т.д.

Вот как это может выглядеть:

<img src="/img/tutorial/debugging/image01.png">

---

Если используете PyCharm, вы можете выполнить следующие шаги:

* Открыть "Run" меню.
* Выбрать опцию "Debug...".
* Затем в появившемся контекстном меню.
* Выбрать файл для отладки (в данном случае, `main.py`).

Это запустит сервер с вашим **FastAPI** кодом, остановится на точках останова, и т.д.

Вот как это может выглядеть:

<img src="/img/tutorial/debugging/image02.png">
