#!/bin/sh
#
# CDDL HEADER START
#
# The contents of this file are subject to the terms of the
# Common Development and Distribution License (the "License").
# You may not use this file except in compliance with the License.
#
# You can obtain a copy of the license at usr/src/OPENSOLARIS.LICENSE
# or http://www.opensolaris.org/os/licensing.
# See the License for the specific language governing permissions
# and limitations under the License.
#
# When distributing Covered Code, include this CDDL HEADER in each
# file and include the License file at usr/src/OPENSOLARIS.LICENSE.
# If applicable, add the following below this CDDL HEADER, with the
# fields enclosed by brackets "[]" replaced with your own identifying
# information: Portions Copyright [yyyy] [name of copyright owner]
#
# CDDL HEADER END
#
# Copyright 2008 Sun Microsystems, Inc.  All rights reserved.
# Use is subject to license terms.
#
#ident	"@(#)pg_regress.sh	1.1	08/09/10 SMI"

# Wrapper to run pg_regress using the test suite installed 
# with the PostgreSQL packages

PG_ROOT=/usr/postgres/8.3

# Default values for arguments

REG_ROOT=${PG_ROOT}/lib/regress
PSQL_DIR=${PG_ROOT}/bin
PGREG_BIN=${PG_ROOT}/lib/pgxs/src/test/regress/pg_regress

if [ $1 = '--help' ] ; then
  cat <<EOF
Usage: pg_regress.sh 
         [--suite <testsuite>]
         [--bindir <psql-dir>]
         [--driver <pg_regress binary>]
         [<pg_regress args>]

<testsuite> is the path to the installed test suite.
  (default $REG_ROOT)

<psql-dir> is the path to the *directory* of the psql binary.
  (default $PSQL_DIR)

<pg_regress> is the path to the pg_regress test driver binary.
  (default $PGREG_BIN)

These three options (if used) can be in any order.

For testing 64 bit psql, use "--psqldir ${PG_ROOT}/bin/64". 
Note that this is independent of whether you are testing with a 
32 or 64 bit server.

Additional arguments are passed on to pg_regress.  Typically, this
will be --schedule=<schedule file>.

The PostgreSQL server must already be running on the same host.
The environment variable PGPORT must be set if the server is not using
the default 5432.

A copy of the testsuite as well as output, will be placed in the directory
/var/tmp/pg_regress and subdirectories; any previous contents will be
removed before the test starts.
EOF
exit 0
fi

if echo $* | grep -- --top-builddir > /dev/null ; then
  echo "\"--top-builddir\" option is not available for this packaged test driver."
  echo "Please start your PostgreSQL server separately."
  exit 1
fi

parse=true

while [ $parse = true ] ; do
  case $1 in
    '--suite' )
      REG_ROOT=$2
      shift 2
      ;;
    '--bindir' )
      PSQL_DIR=$2
      shift 2
      ;;
    '--driver' )
      PGREG_BIN=$2
      shift 2
      ;;
    * )
      parse=false
      ;;
  esac
done

# pg_regress really only works from within the build tree, so need to 
# create a similar directory structure for hardcoded relative paths
# to work correctly.

cd /var/tmp
rm -rf pg_regress
mkdir -p pg_regress/dummy/dummy/dummy
cd pg_regress/dummy/dummy/dummy

cp -pR $REG_ROOT/* .

mkdir -p ../../../contrib/spi
cp *.so ../../../contrib/spi

chmod o+w sql expected
mkdir results testtablespace

exec $PGREG_BIN $* --load-language=plpgsql --psqldir=$PSQL_DIR
