/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: INKFBasicHelper.java,v $
 * Version:       $Name:  $ $Revision: 1.12 $
 * Last Modified: $Date: 2004/10/22 11:30:49 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.IURAspect;
import com.ten60.netkernel.urii.IURMeta;
import java.net.URI;
/**
 * High-level helper methods for implementing accessors. This Interface provides methods that will cover 80% 
 * of Accessor development cases.  For additional convenience methods to source/sink resources see <a href="INKFConvenienceHelper.html">INKFConvenienceHelper</a>
 * @author  tab
 */
public interface INKFBasicHelper
{   
	//*************************
	// this request methods
	//*************************
	
	/** Return a wrapper around the request which initiated
	 * the invocation of this accessor
	 * @exception NKFException thrown if no parent request initiated this invocation
*/
	INKFRequestReadOnly getThisRequest() throws NKFException;
	
	//*************************
	// subrequest methods
	//*************************
	
	/** Create a subrequest which can then be configured with target URI, arguments, type etc before being issued to the kernel
	 *  for scheduling.  A subrequest will automatically acquire the calling request as its parent.
	 */
    INKFRequest createSubRequest();
	
	/** Issue a subrequest.  Make a secondary request to the kernel for scheduling.
	 *  The request is synchronous.
	 * @param aRequest
	 * @return the resulting resource representation
	 * @exception NKFException if there is a failure executing the request
	 */
	IURRepresentation issueSubRequest(INKFRequest aRequest) throws NKFException;
	
	/** Issue a subrequest.  Make a secondary request to the kernel for scheduling.
	 *  The request is synchronous.
	 * @param aRequest
	 * @return the chosen aspect from the resulting resource representation
	 * @exception NKFException if there is a failure executing the request
	 */
	IURAspect issueSubRequestForAspect(INKFRequest aRequest) throws NKFException;

	/** Issue an asynchronous subrequest. Make a secondary request to the kernel
	 * for scheduling
	 *@param aRequest
	 *@return 
	 */
	INKFAsyncRequestHandle issueAsyncSubRequest(INKFRequest aRequest) throws NKFException;
	
	/** Set the current working URI for created subrequests
	 * @param aCWU the new current working URI, may be null
	 * so signify that relative URIs cannot be resolved.
	 */
	void setCWU(String aCWU);

	/** Gets the current working URI for created subrequests.
	 * By default this value is inherited from the request which
	 * initiated the accessor. This value may be null- in which
	 * case relative URI resolution will fail
	 * @return the current working URI
	 */
	String getCWU();
	
	
	//*************************
	// response methods
	//*************************
	
	/** Create a response which should then be configured before being set as the
	 *  overall response for the accessor.
	 * @param aRepresentation a representation who aspects and metadata
	 * should be used as the basis for the response
	 */
	INKFResponse createResponseFrom(IURRepresentation aRepresentation);
	
	/** Create a response which should then be configured before being set as the
	 *  overall response for the accessor.
	 * @param aAspect an aspect which should be used as the basis for the response
	 */
	INKFResponse createResponseFrom(IURAspect aAspect);
	
	/** Set the response to be returned as the result for the invocation of this accessor
	 * @param aResponse
	 */
	void setResponse(INKFResponse aResponse);
	
	/** <b>Advanced</b> Return the kernel helper API for a set of low-level
	 * APIs for advanced use.
	 */
	INKFKernelHelper getKernelHelper();
	
}