/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

public class DefaultClassResolver
implements ClassResolver,
CamelContextAware {
    private CamelContext camelContext;

    public DefaultClassResolver() {
    }

    public DefaultClassResolver(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public Class<?> resolveClass(String name) {
        Class<?> answer = this.loadClass(name, DefaultClassResolver.class.getClassLoader());
        if (answer == null && this.getApplicationContextClassLoader() != null) {
            answer = this.loadClass(name, this.getApplicationContextClassLoader());
        }
        return answer;
    }

    @Override
    public <T> Class<T> resolveClass(String name, Class<T> type) {
        Class answer = CastUtils.cast(this.loadClass(name, DefaultClassResolver.class.getClassLoader()));
        if (answer == null && this.getApplicationContextClassLoader() != null) {
            answer = CastUtils.cast(this.loadClass(name, this.getApplicationContextClassLoader()));
        }
        return answer;
    }

    @Override
    public Class<?> resolveClass(String name, ClassLoader loader) {
        return this.loadClass(name, loader);
    }

    @Override
    public <T> Class<T> resolveClass(String name, Class<T> type, ClassLoader loader) {
        return CastUtils.cast(this.loadClass(name, loader));
    }

    @Override
    public Class<?> resolveMandatoryClass(String name) throws ClassNotFoundException {
        Class<?> answer = this.resolveClass(name);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    @Override
    public <T> Class<T> resolveMandatoryClass(String name, Class<T> type) throws ClassNotFoundException {
        Class<T> answer = this.resolveClass(name, type);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    @Override
    public Class<?> resolveMandatoryClass(String name, ClassLoader loader) throws ClassNotFoundException {
        Class<?> answer = this.resolveClass(name, loader);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    @Override
    public <T> Class<T> resolveMandatoryClass(String name, Class<T> type, ClassLoader loader) throws ClassNotFoundException {
        Class<T> answer = this.resolveClass(name, type, loader);
        if (answer == null) {
            throw new ClassNotFoundException(name);
        }
        return answer;
    }

    @Override
    public InputStream loadResourceAsStream(String uri) {
        StringHelper.notEmpty(uri, "uri");
        return ObjectHelper.loadResourceAsStream(uri, this.getApplicationContextClassLoader());
    }

    @Override
    public URL loadResourceAsURL(String uri) {
        StringHelper.notEmpty(uri, "uri");
        return ObjectHelper.loadResourceAsURL(uri, this.getApplicationContextClassLoader());
    }

    @Override
    public Enumeration<URL> loadResourcesAsURL(String uri) {
        return this.loadAllResourcesAsURL(uri);
    }

    @Override
    public Enumeration<URL> loadAllResourcesAsURL(String uri) {
        StringHelper.notEmpty(uri, "uri");
        return ObjectHelper.loadResourcesAsURL(uri);
    }

    protected Class<?> loadClass(String name, ClassLoader loader) {
        StringHelper.notEmpty(name, "name");
        return ObjectHelper.loadClass(name, loader);
    }

    protected ClassLoader getApplicationContextClassLoader() {
        return this.camelContext != null ? this.camelContext.getApplicationContextClassLoader() : null;
    }
}

