/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier;

import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.NamedNode;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.FilterProcessor;
import org.apache.camel.processor.Pipeline;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.InterceptStrategy;

public class InterceptReifier
extends ProcessorReifier<InterceptDefinition> {
    public InterceptReifier(Route route, ProcessorDefinition<?> definition) {
        super(route, (InterceptDefinition)definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        Processor child = this.createChildProcessor(true);
        Predicate when = null;
        if (((InterceptDefinition)this.definition).getOnWhen() != null) {
            ((InterceptDefinition)this.definition).getOnWhen().preCreateProcessor();
            when = this.createPredicate(((InterceptDefinition)this.definition).getOnWhen().getExpression());
        }
        if (when != null) {
            child = new FilterProcessor(this.getCamelContext(), when, child);
        }
        final Processor output = child;
        this.route.getInterceptStrategies().add(new InterceptStrategy(){
            private Processor interceptedTarget;

            public Processor wrapProcessorInInterceptors(CamelContext context, NamedNode definition, Processor target, Processor nextTarget) throws Exception {
                this.interceptedTarget = target;
                Processor p = exchange -> {
                    exchange.setProperty(ExchangePropertyKey.INTERCEPTED_ROUTE_ID, (Object)ProcessorDefinitionHelper.getRouteId((NamedNode)definition.getParent()));
                    exchange.setProperty(ExchangePropertyKey.INTERCEPTED_NODE_ID, (Object)definition.getId());
                    exchange.setProperty(ExchangePropertyKey.INTERCEPTED_ROUTE_ENDPOINT_URI, (Object)InterceptReifier.this.route.getEndpoint().getEndpointUri());
                };
                if (this.interceptedTarget != null) {
                    return Pipeline.newInstance((CamelContext)context, (Processor[])new Processor[]{p, output, this.interceptedTarget});
                }
                return Pipeline.newInstance((CamelContext)context, (Processor[])new Processor[]{p, output});
            }

            public String toString() {
                return "intercept[" + String.valueOf(this.interceptedTarget != null ? this.interceptedTarget : output) + "]";
            }
        });
        ((RouteDefinition)this.route.getRoute()).getOutputs().remove(this.definition);
        return null;
    }
}

