/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.rest.management.internal;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.aries.jax.rs.rest.management.internal.BaseResource;
import org.apache.aries.jax.rs.rest.management.schema.BundleSchema;
import org.osgi.framework.BundleContext;

public class FrameworkResource
extends BaseResource {
    public FrameworkResource(BundleContext bundleContext) {
        super(bundleContext);
    }

    @GET
    @Path(value="framework{ext: (\\.json|\\.xml)*}")
    @Produces(value={"application/org.osgi.bundle+json", "application/org.osgi.bundle+xml"})
    @Operation(summary="Get the framework bundle by extension type", responses={@ApiResponse(responseCode="200", description="The framework bundle", content={@Content(schema=@Schema(implementation=BundleSchema.class))}), @ApiResponse(responseCode="404", description="Framework not found"), @ApiResponse(responseCode="406", description="The REST management service does not support any of the requested representations")})
    public Response framework(@Parameter(allowEmptyValue=true, schema=@Schema(allowableValues={".json", ".xml"})) @PathParam(value="ext") String ext) {
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.OK).entity((Object)this.bundleSchema(this.framework));
        return Optional.ofNullable(ext).map(String::trim).map(t -> ".json".equals(t) ? "application/org.osgi.bundle+json" : "application/org.osgi.bundle+xml").map(t -> builder.type(t)).orElse(builder).build();
    }
}

