/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.kafkaconnector.countersource;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.kafkaconnector.CamelSourceConnectorConfig;
import org.apache.kafka.common.config.ConfigDef;

@Generated("This class has been generated by camel-kafka-connector-generator-maven-plugin, remove this annotation to prevent it from being generated.")
public class CamelCountersourceSourceConnectorConfig
        extends
            CamelSourceConnectorConfig {

    public static final String CAMEL_SOURCE_COUNTERSOURCE_KAMELET_PERIOD_CONF = "camel.kamelet.counter-source.period";
    public static final String CAMEL_SOURCE_COUNTERSOURCE_KAMELET_PERIOD_DOC = "The time interval between two numbers";
    public static final Integer CAMEL_SOURCE_COUNTERSOURCE_KAMELET_PERIOD_DEFAULT = 1000;
    public static final String CAMEL_SOURCE_COUNTERSOURCE_KAMELET_START_CONF = "camel.kamelet.counter-source.start";
    public static final String CAMEL_SOURCE_COUNTERSOURCE_KAMELET_START_DOC = "The starting number";
    public static final Integer CAMEL_SOURCE_COUNTERSOURCE_KAMELET_START_DEFAULT = 1;
    public static final String CAMEL_SOURCE_COUNTERSOURCE_KAMELET_NUMBERS_CONF = "camel.kamelet.counter-source.numbers";
    public static final String CAMEL_SOURCE_COUNTERSOURCE_KAMELET_NUMBERS_DOC = "How many numbers to generate";
    public static final Integer CAMEL_SOURCE_COUNTERSOURCE_KAMELET_NUMBERS_DEFAULT = null;

    public CamelCountersourceSourceConnectorConfig(
            ConfigDef config,
            Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public CamelCountersourceSourceConnectorConfig(
            Map<String, String> parsedConfig) {
        this(conf(), parsedConfig);
    }

    public static ConfigDef conf() {
        ConfigDef conf = new ConfigDef(CamelSourceConnectorConfig.conf());
        conf.define(CAMEL_SOURCE_COUNTERSOURCE_KAMELET_PERIOD_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_COUNTERSOURCE_KAMELET_PERIOD_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUNTERSOURCE_KAMELET_PERIOD_DOC);
        conf.define(CAMEL_SOURCE_COUNTERSOURCE_KAMELET_START_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_COUNTERSOURCE_KAMELET_START_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUNTERSOURCE_KAMELET_START_DOC);
        conf.define(CAMEL_SOURCE_COUNTERSOURCE_KAMELET_NUMBERS_CONF, ConfigDef.Type.INT, CAMEL_SOURCE_COUNTERSOURCE_KAMELET_NUMBERS_DEFAULT, ConfigDef.Importance.MEDIUM, CAMEL_SOURCE_COUNTERSOURCE_KAMELET_NUMBERS_DOC);
        return conf;
    }
}