/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationAssert;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.SubnodeConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.FileAlwaysReloadingStrategy;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.commons.configuration.resolver.CatalogResolver;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.configuration.tree.ExpressionEngine;
import org.apache.commons.configuration.tree.xpath.XPathExpressionEngine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestXMLConfiguration {
    private static final String CATALOG_FILES = ConfigurationAssert.getTestFile("catalog.xml").getAbsolutePath();
    static final String ENCODING = "ISO-8859-1";
    static final String SYSTEM_ID = "properties.dtd";
    static final String PUBLIC_ID = "-//Commons Configuration//DTD Test Configuration 1.3//EN";
    static final String DOCTYPE_DECL = " PUBLIC \"-//Commons Configuration//DTD Test Configuration 1.3//EN\" \"properties.dtd\">";
    static final String DOCTYPE = "<!DOCTYPE ";
    static final String PROP_FACTORY = "javax.xml.transform.TransformerFactory";
    private String testProperties = ConfigurationAssert.getTestFile("test.xml").getAbsolutePath();
    private String testProperties2 = ConfigurationAssert.getTestFile("testDigesterConfigurationInclude1.xml").getAbsolutePath();
    private String testBasePath = ConfigurationAssert.TEST_DIR.getAbsolutePath();
    private File testSaveConf = ConfigurationAssert.getOutFile("testsave.xml");
    private File testSaveFile = ConfigurationAssert.getOutFile("testsample2.xml");
    private String testFile2 = ConfigurationAssert.getTestFile("sample.xml").getAbsolutePath();
    private static final int THREAD_COUNT = 5;
    private static final int LOOP_COUNT = 100;
    private XMLConfiguration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new XMLConfiguration();
        this.conf.setFile(new File(this.testProperties));
        this.conf.load();
        this.removeTestFile();
    }

    @Test
    public void testGetProperty() {
        Assert.assertEquals((Object)"value", (Object)this.conf.getProperty("element"));
    }

    @Test
    public void testGetCommentedProperty() {
        Assert.assertEquals((Object)"", (Object)this.conf.getProperty("test.comment"));
    }

    @Test
    public void testGetPropertyWithXMLEntity() {
        Assert.assertEquals((Object)"1<2", (Object)this.conf.getProperty("test.entity"));
    }

    @Test
    public void testClearProperty() throws Exception {
        String key = "clearly";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        this.conf.load();
        key = "clear.element";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        this.conf.load();
        key = "clear.element2";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        key = "clear.element2[@id]";
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        this.conf.load();
        key = "clear.comment";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        this.conf.load();
        key = "clear.cdata";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        this.conf.load();
        key = "clear.list.item";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        key = "clear.list.item[@id]";
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        this.conf.load();
        key = "list.item";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
    }

    @Test
    public void testgetProperty() {
        Object property = this.conf.getProperty("clear");
        Assert.assertNull((Object)property);
        property = this.conf.getProperty("e");
        Assert.assertNull((Object)property);
        property = this.conf.getProperty("element3[@n]");
        Assert.assertNull((Object)property);
        property = this.conf.getProperty("element");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof String));
        Assert.assertEquals((Object)"value", (Object)property);
        property = this.conf.getProperty("element3[@name]");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof String));
        Assert.assertEquals((Object)"foo", (Object)property);
        property = this.conf.getProperty("test.comment");
        Assert.assertEquals((Object)"", (Object)property);
        property = this.conf.getProperty("test.cdata");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof String));
        Assert.assertEquals((Object)"<cdata value>", (Object)property);
        property = this.conf.getProperty("list.sublist.item");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof List));
        List list = (List)property;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"five", list.get(0));
        Assert.assertEquals((Object)"six", list.get(1));
        property = this.conf.getProperty("list.item");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof List));
        list = (List)property;
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((Object)"one", list.get(0));
        Assert.assertEquals((Object)"two", list.get(1));
        Assert.assertEquals((Object)"three", list.get(2));
        Assert.assertEquals((Object)"four", list.get(3));
        property = this.conf.getProperty("list.item[@name]");
        Assert.assertNotNull((Object)property);
        Assert.assertTrue((boolean)(property instanceof List));
        list = (List)property;
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"one", list.get(0));
        Assert.assertEquals((Object)"three", list.get(1));
    }

    @Test
    public void testGetAttribute() {
        Assert.assertEquals((String)"element3[@name]", (Object)"foo", (Object)this.conf.getProperty("element3[@name]"));
    }

    @Test
    public void testClearAttribute() throws Exception {
        String key = "clear[@id]";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        this.conf.load();
        key = "clear.element2[@id]";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        key = "clear.element2";
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        this.conf.load();
        key = "clear.list.item[@id]";
        this.conf.clearProperty(key);
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNull((String)key, (Object)this.conf.getProperty(key));
        key = "clear.list.item";
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
        Assert.assertNotNull((String)key, (Object)this.conf.getProperty(key));
    }

    @Test
    public void testSetAttribute() {
        this.conf.setProperty("element3[@name]", (Object)"bar");
        Assert.assertEquals((String)"element3[@name]", (Object)"bar", (Object)this.conf.getProperty("element3[@name]"));
        this.conf.setProperty("foo[@bar]", (Object)"value");
        Assert.assertEquals((String)"foo[@bar]", (Object)"value", (Object)this.conf.getProperty("foo[@bar]"));
        this.conf.setProperty("name1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)this.conf.getProperty("name1"));
    }

    @Test
    public void testAddAttribute() {
        this.conf.addProperty("element3[@name]", (Object)"bar");
        List list = this.conf.getList("element3[@name]");
        Assert.assertNotNull((String)"null list", (Object)list);
        Assert.assertTrue((String)"'foo' element missing", (boolean)list.contains("foo"));
        Assert.assertTrue((String)"'bar' element missing", (boolean)list.contains("bar"));
        Assert.assertEquals((String)"list size", (long)2L, (long)list.size());
    }

    @Test
    public void testAddObjectAttribute() {
        this.conf.addProperty("test.boolean[@value]", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"test.boolean[@value]", (boolean)this.conf.getBoolean("test.boolean[@value]"));
    }

    @Test
    public void testSetRootAttribute() throws ConfigurationException {
        this.conf.setProperty("[@test]", (Object)"true");
        Assert.assertEquals((String)"Root attribute not set", (Object)"true", (Object)this.conf.getString("[@test]"));
        this.conf.save(this.testSaveConf);
        XMLConfiguration checkConf = new XMLConfiguration();
        checkConf.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)checkConf);
        Assert.assertTrue((String)"Attribute not found after save", (boolean)checkConf.containsKey("[@test]"));
        checkConf.setProperty("[@test]", (Object)"newValue");
        checkConf.save();
        this.conf = checkConf;
        checkConf = new XMLConfiguration();
        checkConf.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)checkConf);
        Assert.assertEquals((String)"Attribute not modified after save", (Object)"newValue", (Object)checkConf.getString("[@test]"));
    }

    @Test
    public void testGetRootReference() {
        Assert.assertNotNull((String)"Root node has no reference", (Object)this.conf.getRootNode().getReference());
    }

    @Test
    public void testAddList() {
        this.conf.addProperty("test.array", (Object)"value1");
        this.conf.addProperty("test.array", (Object)"value2");
        List list = this.conf.getList("test.array");
        Assert.assertNotNull((String)"null list", (Object)list);
        Assert.assertTrue((String)"'value1' element missing", (boolean)list.contains("value1"));
        Assert.assertTrue((String)"'value2' element missing", (boolean)list.contains("value2"));
        Assert.assertEquals((String)"list size", (long)2L, (long)list.size());
    }

    @Test
    public void testGetComplexProperty() {
        Assert.assertEquals((Object)"I'm complex!", (Object)this.conf.getProperty("element2.subelement.subsubelement"));
    }

    @Test
    public void testSettingFileNames() {
        this.conf = new XMLConfiguration();
        this.conf.setFileName(this.testProperties);
        Assert.assertEquals((Object)this.testProperties.toString(), (Object)this.conf.getFileName());
        this.conf.setBasePath(this.testBasePath);
        this.conf.setFileName("hello.xml");
        Assert.assertEquals((Object)"hello.xml", (Object)this.conf.getFileName());
        Assert.assertEquals((Object)this.testBasePath.toString(), (Object)this.conf.getBasePath());
        Assert.assertEquals((Object)new File(this.testBasePath, "hello.xml"), (Object)this.conf.getFile());
        this.conf.setBasePath(this.testBasePath);
        this.conf.setFileName("subdir/hello.xml");
        Assert.assertEquals((Object)"subdir/hello.xml", (Object)this.conf.getFileName());
        Assert.assertEquals((Object)this.testBasePath.toString(), (Object)this.conf.getBasePath());
        Assert.assertEquals((Object)new File(this.testBasePath, "subdir/hello.xml"), (Object)this.conf.getFile());
    }

    @Test
    public void testLoad() throws Exception {
        this.conf = new XMLConfiguration();
        this.conf.setFileName(this.testProperties);
        this.conf.load();
        Assert.assertEquals((Object)"I'm complex!", (Object)this.conf.getProperty("element2.subelement.subsubelement"));
    }

    @Test
    public void testLoadWithBasePath() throws Exception {
        this.conf = new XMLConfiguration();
        this.conf.setFileName("test.xml");
        this.conf.setBasePath(this.testBasePath);
        this.conf.load();
        Assert.assertEquals((Object)"I'm complex!", (Object)this.conf.getProperty("element2.subelement.subsubelement"));
    }

    @Test
    public void testLoadAndSaveFromFile() throws Exception {
        this.conf = new XMLConfiguration(this.testSaveConf);
        Assert.assertTrue((boolean)this.conf.isEmpty());
        this.conf.addProperty("test", (Object)"yes");
        this.conf.save();
        this.conf = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((Object)"yes", (Object)this.conf.getString("test"));
    }

    @Test
    public void testLoadFromURL() throws Exception {
        URL url = new File(this.testProperties).toURI().toURL();
        this.conf = new XMLConfiguration(url);
        Assert.assertEquals((Object)"value", (Object)this.conf.getProperty("element"));
        Assert.assertEquals((Object)url, (Object)this.conf.getURL());
    }

    @Test
    public void testLoadFromStream() throws Exception {
        String xml = "<?xml version=\"1.0\"?><config><test>1</test></config>";
        this.conf = new XMLConfiguration();
        this.conf.load((InputStream)new ByteArrayInputStream(xml.getBytes()));
        Assert.assertEquals((long)1L, (long)this.conf.getInt("test"));
        this.conf = new XMLConfiguration();
        this.conf.load((InputStream)new ByteArrayInputStream(xml.getBytes()), "UTF8");
        Assert.assertEquals((long)1L, (long)this.conf.getInt("test"));
    }

    @Test(expected=ConfigurationException.class)
    public void testLoadInvalidXML() throws Exception {
        String xml = "<?xml version=\"1.0\"?><config><test>1</rest></config>";
        this.conf = new XMLConfiguration();
        this.conf.load((Reader)new StringReader(xml));
    }

    @Test
    public void testSetProperty() throws Exception {
        this.conf.setProperty("element.string", (Object)"hello");
        Assert.assertEquals((String)"'element.string'", (Object)"hello", (Object)this.conf.getString("element.string"));
        Assert.assertEquals((String)"XML value of element.string", (Object)"hello", (Object)this.conf.getProperty("element.string"));
    }

    @Test
    public void testAddProperty() {
        XMLConfiguration config = new XMLConfiguration();
        config.addProperty("test.string", (Object)"hello");
        Assert.assertEquals((String)"'test.string'", (Object)"hello", (Object)config.getString("test.string"));
    }

    @Test
    public void testAddObjectProperty() {
        this.conf.addProperty("test.boolean", (Object)Boolean.TRUE);
        Assert.assertTrue((String)"'test.boolean'", (boolean)this.conf.getBoolean("test.boolean"));
    }

    @Test
    public void testSave() throws Exception {
        int i;
        this.conf.addProperty("string", (Object)"value1");
        for (i = 1; i < 5; ++i) {
            this.conf.addProperty("test.array", (Object)("value" + i));
        }
        for (i = 1; i < 5; ++i) {
            this.conf.addProperty("test.attribute[@array]", (Object)("value" + i));
        }
        this.conf.addProperty("split.list5", (Object)"a\\,b\\,c");
        this.conf.setProperty("element3", (Object)"value\\,value1\\,value2");
        this.conf.setProperty("element3[@name]", (Object)"foo\\,bar");
        this.conf.save(this.testSaveConf.getAbsolutePath());
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setFileName(this.testSaveConf.getAbsolutePath());
        this.checkSavedConfig((FileConfiguration)checkConfig);
    }

    @Test
    public void testSaveToURL() throws Exception {
        this.conf.save(this.testSaveConf.toURI().toURL());
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)checkConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveToStream() throws Exception {
        Assert.assertNull((Object)this.conf.getEncoding());
        this.conf.setEncoding("UTF8");
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.testSaveConf);
            this.conf.save((OutputStream)out);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)checkConfig);
        try {
            out = new FileOutputStream(this.testSaveConf);
            this.conf.save((OutputStream)out, "UTF8");
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        checkConfig.clear();
        this.checkSavedConfig((FileConfiguration)checkConfig);
    }

    @Test
    public void testAutoSave() throws Exception {
        this.conf.setFile(this.testSaveConf);
        Assert.assertFalse((boolean)this.conf.isAutoSave());
        this.conf.setAutoSave(true);
        Assert.assertTrue((boolean)this.conf.isAutoSave());
        this.conf.setProperty("autosave", (Object)"ok");
        XMLConfiguration conf2 = new XMLConfiguration(this.conf.getFile());
        Assert.assertEquals((String)"'autosave' property", (Object)"ok", (Object)conf2.getString("autosave"));
        this.conf.clearTree("clear");
        conf2 = new XMLConfiguration(this.conf.getFile());
        Configuration sub = conf2.subset("clear");
        Assert.assertTrue((boolean)sub.isEmpty());
    }

    @Test
    public void testAppend() throws Exception {
        this.conf = new XMLConfiguration();
        this.conf.setFileName(this.testProperties);
        this.conf.load();
        this.conf.load(this.testProperties2);
        Assert.assertEquals((Object)"value", (Object)this.conf.getString("element"));
        Assert.assertEquals((Object)"tasks", (Object)this.conf.getString("table.name"));
        this.conf.save(this.testSaveConf);
        this.conf = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((Object)"value", (Object)this.conf.getString("element"));
        Assert.assertEquals((Object)"tasks", (Object)this.conf.getString("table.name"));
        Assert.assertEquals((Object)"application", (Object)this.conf.getString("table[@tableType]"));
    }

    @Test
    public void testSaveAttributes() throws Exception {
        this.conf.clear();
        this.conf.load();
        this.conf.save(this.testSaveConf);
        this.conf = new XMLConfiguration();
        this.conf.load(this.testSaveConf);
        Assert.assertEquals((Object)"foo", (Object)this.conf.getString("element3[@name]"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloading() throws Exception {
        Assert.assertNotNull((Object)this.conf.getReloadingStrategy());
        Assert.assertTrue((boolean)(this.conf.getReloadingStrategy() instanceof InvariantReloadingStrategy));
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.testSaveConf));
            out.println("<?xml version=\"1.0\"?><config><test>1</test></config>");
            out.close();
            out = null;
            this.conf.setFile(this.testSaveConf);
            FileAlwaysReloadingStrategy strategy = new FileAlwaysReloadingStrategy();
            strategy.setRefreshDelay(100L);
            this.conf.setReloadingStrategy((ReloadingStrategy)strategy);
            Assert.assertEquals((Object)((Object)strategy), (Object)this.conf.getReloadingStrategy());
            Assert.assertEquals((String)"Wrong file monitored", (Object)this.testSaveConf.getAbsolutePath(), (Object)strategy.getMonitoredFile().getAbsolutePath());
            this.conf.load();
            Assert.assertEquals((long)1L, (long)this.conf.getInt("test"));
            out = new PrintWriter(new FileWriter(this.testSaveConf));
            out.println("<?xml version=\"1.0\"?><config><test>2</test></config>");
            out.close();
            out = null;
            int value = this.conf.getInt("test");
            Assert.assertEquals((String)"No reloading performed", (long)2L, (long)value);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReloadingOOM() throws Exception {
        Assert.assertNotNull((Object)this.conf.getReloadingStrategy());
        Assert.assertTrue((boolean)(this.conf.getReloadingStrategy() instanceof InvariantReloadingStrategy));
        PrintWriter out = null;
        try {
            out = new PrintWriter(new FileWriter(this.testSaveConf));
            out.println("<?xml version=\"1.0\"?><config><test>1</test></config>");
            out.close();
            out = null;
            this.conf.setFile(this.testSaveConf);
            FileAlwaysReloadingStrategy strategy = new FileAlwaysReloadingStrategy();
            strategy.setRefreshDelay(100L);
            this.conf.setReloadingStrategy((ReloadingStrategy)strategy);
            this.conf.load();
            Assert.assertEquals((long)1L, (long)this.conf.getInt("test"));
            for (int i = 1; i < 100; ++i) {
                Assert.assertEquals((long)1L, (long)this.conf.getInt("test"));
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Test
    public void testRefresh() throws ConfigurationException {
        this.conf.setProperty("element", (Object)"anotherValue");
        this.conf.refresh();
        Assert.assertEquals((String)"Wrong property after refresh", (Object)"value", (Object)this.conf.getString("element"));
    }

    @Test(expected=ConfigurationException.class)
    public void testRefreshNoFile() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.refresh();
    }

    @Test
    public void testComplexNames() {
        Assert.assertEquals((Object)"Name with dot", (Object)this.conf.getString("complexNames.my..elem"));
        Assert.assertEquals((Object)"Another dot", (Object)this.conf.getString("complexNames.my..elem.sub..elem"));
    }

    private DocumentBuilder createValidatingDocBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(new DefaultHandler(){

            public void error(SAXParseException ex) throws SAXException {
                throw ex;
            }
        });
        return builder;
    }

    @Test
    public void testCustomDocBuilder() throws Exception {
        this.conf = new XMLConfiguration();
        this.conf.load(ConfigurationAssert.getTestFile("testValidateInvalid.xml"));
        Assert.assertEquals((Object)"customers", (Object)this.conf.getString("table.name"));
        Assert.assertFalse((boolean)this.conf.containsKey("table.fields.field(1).type"));
    }

    @Test(expected=ConfigurationException.class)
    public void testCustomDocBuilderValidationError() throws Exception {
        DocumentBuilder builder = this.createValidatingDocBuilder();
        this.conf = new XMLConfiguration();
        this.conf.setDocumentBuilder(builder);
        this.conf.load(new File("conf/testValidateInvalid.xml"));
    }

    @Test
    public void testCustomDocBuilderValidationSuccess() throws Exception {
        DocumentBuilder builder = this.createValidatingDocBuilder();
        this.conf = new XMLConfiguration();
        this.conf.setDocumentBuilder(builder);
        this.conf.load(ConfigurationAssert.getTestFile("testValidateValid.xml"));
        Assert.assertTrue((boolean)this.conf.containsKey("table.fields.field(1).type"));
    }

    @Test
    public void testClone() {
        Configuration c = (Configuration)this.conf.clone();
        Assert.assertTrue((boolean)(c instanceof XMLConfiguration));
        XMLConfiguration copy = (XMLConfiguration)c;
        Assert.assertNotNull((Object)this.conf.getDocument());
        Assert.assertNull((Object)copy.getDocument());
        Assert.assertNotNull((Object)this.conf.getFileName());
        Assert.assertNull((Object)copy.getFileName());
        copy.setProperty("element3", (Object)"clonedValue");
        Assert.assertEquals((Object)"value", (Object)this.conf.getString("element3"));
        this.conf.setProperty("element3[@name]", (Object)"originalFoo");
        Assert.assertEquals((Object)"foo", (Object)copy.getString("element3[@name]"));
    }

    @Test
    public void testCloneWithSave() throws ConfigurationException {
        XMLConfiguration c = (XMLConfiguration)this.conf.clone();
        c.addProperty("test.newProperty", (Object)Boolean.TRUE);
        this.conf.addProperty("test.orgProperty", (Object)Boolean.TRUE);
        c.save(this.testSaveConf);
        XMLConfiguration c2 = new XMLConfiguration(this.testSaveConf);
        Assert.assertTrue((String)"New property after clone() was not saved", (boolean)c2.getBoolean("test.newProperty"));
        Assert.assertFalse((String)"Property of original config was saved", (boolean)c2.containsKey("test.orgProperty"));
    }

    @Test
    public void testSubset() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.load(ConfigurationAssert.getTestFile("testHierarchicalXMLConfiguration.xml"));
        this.conf.subset("tables.table(0)");
        this.conf.save(this.testSaveConf);
        this.conf = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((Object)"users", (Object)this.conf.getString("tables.table(0).name"));
    }

    @Test
    public void testSplitLists() {
        Assert.assertEquals((Object)"a", (Object)this.conf.getString("split.list3[@values]"));
        Assert.assertEquals((long)2L, (long)this.conf.getMaxIndex("split.list3[@values]"));
        Assert.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split.list4[@values]"));
        Assert.assertEquals((Object)"a", (Object)this.conf.getString("split.list1"));
        Assert.assertEquals((long)2L, (long)this.conf.getMaxIndex("split.list1"));
        Assert.assertEquals((Object)"a,b,c", (Object)this.conf.getString("split.list2"));
    }

    @Test
    public void testDelimiterParsingDisabled() throws ConfigurationException {
        XMLConfiguration conf2 = new XMLConfiguration();
        conf2.setDelimiterParsingDisabled(true);
        conf2.setFile(new File(this.testProperties));
        conf2.load();
        Assert.assertEquals((Object)"a,b,c", (Object)conf2.getString("split.list3[@values]"));
        Assert.assertEquals((long)0L, (long)conf2.getMaxIndex("split.list3[@values]"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split.list4[@values]"));
        Assert.assertEquals((Object)"a,b,c", (Object)conf2.getString("split.list1"));
        Assert.assertEquals((long)0L, (long)conf2.getMaxIndex("split.list1"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split.list2"));
        conf2 = new XMLConfiguration();
        conf2.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        conf2.setDelimiterParsingDisabled(true);
        conf2.setFile(new File(this.testProperties));
        conf2.load();
        Assert.assertEquals((Object)"a,b,c", (Object)conf2.getString("split/list3/@values"));
        Assert.assertEquals((long)0L, (long)conf2.getMaxIndex("split/list3/@values"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split/list4/@values"));
        Assert.assertEquals((Object)"a,b,c", (Object)conf2.getString("split/list1"));
        Assert.assertEquals((long)0L, (long)conf2.getMaxIndex("split/list1"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf2.getString("split/list2"));
    }

    @Test
    public void testSaveWithDelimiterParsingDisabled() throws ConfigurationException {
        XMLConfiguration conf = new XMLConfiguration();
        conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        conf.setDelimiterParsingDisabled(true);
        conf.setAttributeSplittingDisabled(true);
        conf.setFile(new File(this.testProperties));
        conf.load();
        Assert.assertEquals((Object)"a,b,c", (Object)conf.getString("split/list3/@values"));
        Assert.assertEquals((long)0L, (long)conf.getMaxIndex("split/list3/@values"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf.getString("split/list4/@values"));
        Assert.assertEquals((Object)"a,b,c", (Object)conf.getString("split/list1"));
        Assert.assertEquals((long)0L, (long)conf.getMaxIndex("split/list1"));
        Assert.assertEquals((Object)"a\\,b\\,c", (Object)conf.getString("split/list2"));
        conf.save(this.testSaveConf.getAbsolutePath());
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setFileName(this.testSaveConf.getAbsolutePath());
        this.checkSavedConfig((FileConfiguration)checkConfig);
        XMLConfiguration config = new XMLConfiguration();
        config.setFileName(this.testFile2);
        config.setDelimiterParsingDisabled(true);
        config.setAttributeSplittingDisabled(true);
        config.load();
        config.setProperty("Employee[@attr1]", (Object)"3,2,1");
        Assert.assertEquals((Object)"3,2,1", (Object)config.getString("Employee[@attr1]"));
        config.save(this.testSaveFile.getAbsolutePath());
        config = new XMLConfiguration();
        config.setFileName(this.testSaveFile.getAbsolutePath());
        config.setDelimiterParsingDisabled(true);
        config.setAttributeSplittingDisabled(true);
        config.load();
        config.setProperty("Employee[@attr1]", (Object)"1,2,3");
        Assert.assertEquals((Object)"1,2,3", (Object)config.getString("Employee[@attr1]"));
        config.setProperty("Employee[@attr2]", (Object)"one, two, three");
        Assert.assertEquals((Object)"one, two, three", (Object)config.getString("Employee[@attr2]"));
        config.setProperty("Employee.text", (Object)"a,b,d");
        Assert.assertEquals((Object)"a,b,d", (Object)config.getString("Employee.text"));
        config.setProperty("Employee.Salary", (Object)"100,000");
        Assert.assertEquals((Object)"100,000", (Object)config.getString("Employee.Salary"));
        config.save(this.testSaveFile.getAbsolutePath());
        checkConfig = new XMLConfiguration();
        checkConfig.setFileName(this.testSaveFile.getAbsolutePath());
        checkConfig.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        checkConfig.setDelimiterParsingDisabled(true);
        checkConfig.setAttributeSplittingDisabled(true);
        checkConfig.load();
        Assert.assertEquals((Object)"1,2,3", (Object)checkConfig.getString("Employee/@attr1"));
        Assert.assertEquals((Object)"one, two, three", (Object)checkConfig.getString("Employee/@attr2"));
        Assert.assertEquals((Object)"a,b,d", (Object)checkConfig.getString("Employee/text"));
        Assert.assertEquals((Object)"100,000", (Object)checkConfig.getString("Employee/Salary"));
    }

    @Test
    public void testDtd() throws ConfigurationException {
        this.conf = new XMLConfiguration("testDtd.xml");
        Assert.assertEquals((Object)"value1", (Object)this.conf.getString("entry(0)"));
        Assert.assertEquals((Object)"test2", (Object)this.conf.getString("entry(1)[@key]"));
    }

    @Test
    public void testValidating() throws ConfigurationException {
        File nonValidFile = ConfigurationAssert.getTestFile("testValidateInvalid.xml");
        this.conf = new XMLConfiguration();
        Assert.assertFalse((boolean)this.conf.isValidating());
        this.conf.load(nonValidFile);
        Assert.assertEquals((Object)"customers", (Object)this.conf.getString("table.name"));
        Assert.assertFalse((boolean)this.conf.containsKey("table.fields.field(1).type"));
        this.conf.setValidating(true);
        try {
            this.conf.load(nonValidFile);
            Assert.fail((String)"Validation was not performed!");
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptyElements() throws ConfigurationException {
        Assert.assertTrue((boolean)this.conf.containsKey("empty"));
        Assert.assertEquals((Object)"", (Object)this.conf.getString("empty"));
        this.conf.addProperty("empty2", (Object)"");
        this.conf.setProperty("empty", (Object)"no more empty");
        this.conf.save(this.testSaveConf);
        this.conf = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((Object)"no more empty", (Object)this.conf.getString("empty"));
        Assert.assertEquals((Object)"", (Object)this.conf.getProperty("empty2"));
    }

    @Test
    public void testEmptyReload() throws ConfigurationException {
        XMLConfiguration config = new XMLConfiguration();
        Assert.assertTrue((String)"Newly created configuration not empty", (boolean)config.isEmpty());
        config.save(this.testSaveConf);
        config.load(this.testSaveConf);
        Assert.assertTrue((String)"Reloaded configuration not empty", (boolean)config.isEmpty());
    }

    @Test
    public void testLoadWithEncoding() throws ConfigurationException {
        File file = ConfigurationAssert.getTestFile("testEncoding.xml");
        this.conf = new XMLConfiguration();
        this.conf.load(file);
        Assert.assertEquals((Object)"test3_yoge", (Object)this.conf.getString("yoge"));
    }

    @Test
    public void testSaveWithEncoding() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setProperty("test", (Object)"a value");
        this.conf.setEncoding(ENCODING);
        StringWriter out = new StringWriter();
        this.conf.save((Writer)out);
        Assert.assertTrue((String)"Encoding was not written to file", (out.toString().indexOf("encoding=\"ISO-8859-1\"") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSaveWithNullEncoding() throws ConfigurationException {
        this.conf = new XMLConfiguration();
        this.conf.setProperty("testNoEncoding", (Object)"yes");
        this.conf.setEncoding(null);
        StringWriter out = new StringWriter();
        this.conf.save((Writer)out);
        Assert.assertTrue((String)"Encoding was written to file", (out.toString().indexOf("encoding=\"UTF-") >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSaveWithDoctype() throws ConfigurationException {
        String content = "<?xml  version=\"1.0\"?><!DOCTYPE properties PUBLIC \"-//Commons Configuration//DTD Test Configuration 1.3//EN\" \"properties.dtd\"><properties version=\"1.0\"><entry key=\"test\">value</entry></properties>";
        StringReader in = new StringReader(content);
        this.conf = new XMLConfiguration();
        this.conf.setFileName("testDtd.xml");
        this.conf.load();
        this.conf.clear();
        this.conf.load((Reader)in);
        Assert.assertEquals((String)"Wrong public ID", (Object)PUBLIC_ID, (Object)this.conf.getPublicID());
        Assert.assertEquals((String)"Wrong system ID", (Object)SYSTEM_ID, (Object)this.conf.getSystemID());
        StringWriter out = new StringWriter();
        this.conf.save((Writer)out);
        Assert.assertTrue((String)"Did not find DOCTYPE", (out.toString().indexOf(DOCTYPE) >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSaveWithDoctypeIDs() throws ConfigurationException {
        Assert.assertNull((String)"A public ID was found", (Object)this.conf.getPublicID());
        Assert.assertNull((String)"A system ID was found", (Object)this.conf.getSystemID());
        this.conf.setPublicID(PUBLIC_ID);
        this.conf.setSystemID(SYSTEM_ID);
        StringWriter out = new StringWriter();
        this.conf.save((Writer)out);
        Assert.assertTrue((String)"Did not find DOCTYPE", (out.toString().indexOf("<!DOCTYPE testconfig PUBLIC \"-//Commons Configuration//DTD Test Configuration 1.3//EN\" \"properties.dtd\">") >= 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSaveWithInvalidTransformerFactory() {
        System.setProperty(PROP_FACTORY, "an.invalid.Class");
        try {
            this.conf.save(this.testSaveConf);
            Assert.fail((String)"Could save with invalid TransformerFactory!");
        }
        catch (ConfigurationException configurationException) {
        }
        finally {
            System.getProperties().remove(PROP_FACTORY);
        }
    }

    @Test
    public void testSubsetWithReload() throws ConfigurationException {
        XMLConfiguration c = this.setUpReloadTest();
        Configuration sub = c.subset("test");
        Assert.assertEquals((String)"New value not read", (Object)"newValue", (Object)sub.getString("entity"));
    }

    @Test
    public void testConfigurationAtWithReload() throws ConfigurationException {
        XMLConfiguration c = this.setUpReloadTest();
        SubnodeConfiguration sub = c.configurationAt("test(0)");
        Assert.assertEquals((String)"New value not read", (Object)"newValue", (Object)sub.getString("entity"));
    }

    @Test
    public void testConfigurationsAtWithReload() throws ConfigurationException {
        XMLConfiguration c = this.setUpReloadTest();
        List configs = c.configurationsAt("test");
        Assert.assertEquals((String)"New value not read", (Object)"newValue", (Object)((HierarchicalConfiguration)configs.get(0)).getString("entity"));
    }

    @Test
    public void testGetKeysWithReload() throws ConfigurationException {
        XMLConfiguration c = this.setUpReloadTest();
        this.conf.addProperty("aNewKey", (Object)"aNewValue");
        this.conf.save(this.testSaveConf);
        boolean found = false;
        Iterator it = c.getKeys();
        while (it.hasNext()) {
            if (!"aNewKey".equals(it.next())) continue;
            found = true;
        }
        Assert.assertTrue((String)"Reload not performed", (boolean)found);
    }

    @Test
    public void testXPathExpressionEngine() {
        this.conf.setExpressionEngine((ExpressionEngine)new XPathExpressionEngine());
        Assert.assertEquals((String)"Wrong attribute value", (Object)"foo\"bar", (Object)this.conf.getString("test[1]/entity/@name"));
        this.conf.clear();
        Assert.assertNull((Object)this.conf.getString("test[1]/entity/@name"));
    }

    @Test
    public void testInitCopy() throws ConfigurationException {
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        Assert.assertEquals((Object)"value", (Object)copy.getProperty("element"));
        Assert.assertNull((String)"Document was copied, too", (Object)copy.getDocument());
        ConfigurationNode root = copy.getRootNode();
        for (ConfigurationNode node : root.getChildren()) {
            Assert.assertNull((String)"Reference was not cleared", (Object)node.getReference());
        }
        this.removeTestFile();
        copy.setFile(this.testSaveConf);
        copy.save();
        copy.clear();
        this.checkSavedConfig((FileConfiguration)copy);
    }

    @Test
    public void testSetTextRootElement() throws ConfigurationException {
        this.conf.setProperty("", (Object)"Root text");
        this.conf.save(this.testSaveConf);
        XMLConfiguration copy = new XMLConfiguration();
        copy.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)copy);
    }

    @Test
    public void testClearTextRootElement() throws ConfigurationException {
        String xml = "<e a=\"v\">text</e>";
        this.conf.clear();
        StringReader in = new StringReader("<e a=\"v\">text</e>");
        this.conf.load((Reader)in);
        Assert.assertEquals((String)"Wrong text of root", (Object)"text", (Object)this.conf.getString(""));
        this.conf.clearProperty("");
        this.conf.save(this.testSaveConf);
        XMLConfiguration copy = new XMLConfiguration();
        copy.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)copy);
    }

    @Test
    public void testListWithAttributes() {
        Assert.assertEquals((String)"Wrong number of <a> elements", (long)6L, (long)this.conf.getList("attrList.a").size());
        Assert.assertEquals((String)"Wrong value of first element", (Object)"ABC", (Object)this.conf.getString("attrList.a(0)"));
        Assert.assertEquals((String)"Wrong value of first name attribute", (Object)"x", (Object)this.conf.getString("attrList.a(0)[@name]"));
        Assert.assertEquals((String)"Wrong number of name attributes", (long)6L, (long)this.conf.getList("attrList.a[@name]").size());
    }

    @Test
    public void testListWithAttributesMultiValue() {
        Assert.assertEquals((String)"Wrong value of 2nd element", (Object)"1", (Object)this.conf.getString("attrList.a(1)"));
        Assert.assertEquals((String)"Wrong value of 2nd name attribute", (Object)"y", (Object)this.conf.getString("attrList.a(1)[@name]"));
        for (int i = 1; i <= 3; ++i) {
            Assert.assertEquals((String)("Wrong value of element " + (i + 1)), (long)i, (long)this.conf.getInt("attrList.a(" + i + ")"));
            Assert.assertEquals((String)("Wrong name attribute for element " + i), (Object)"y", (Object)this.conf.getString("attrList.a(" + i + ")[@name]"));
        }
    }

    @Test
    public void testListWithMultipleAttributesMultiValue() {
        for (int i = 1; i <= 2; ++i) {
            String idxStr = String.format("(%d)", i + 3);
            String nodeKey = "attrList.a" + idxStr;
            Assert.assertEquals((String)"Wrong value of multi-valued node", (Object)("value" + i), (Object)this.conf.getString(nodeKey));
            Assert.assertEquals((String)("Wrong name attribute at " + i), (Object)"u", (Object)this.conf.getString(nodeKey + "[@name]"));
            Assert.assertEquals((String)("Wrong test attribute at " + i), (Object)"yes", (Object)this.conf.getString(nodeKey + "[@test]"));
        }
    }

    @Test
    public void testAutoSaveWithSubnodeConfig() throws ConfigurationException {
        String newValue = "I am autosaved";
        this.conf.setFile(this.testSaveConf);
        this.conf.setAutoSave(true);
        SubnodeConfiguration sub = this.conf.configurationAt("element2.subelement");
        sub.setProperty("subsubelement", (Object)"I am autosaved");
        Assert.assertEquals((String)"Change not visible to parent", (Object)"I am autosaved", (Object)this.conf.getString("element2.subelement.subsubelement"));
        XMLConfiguration conf2 = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((String)"Change was not saved", (Object)"I am autosaved", (Object)conf2.getString("element2.subelement.subsubelement"));
    }

    @Test
    public void testAutoSaveWithSubSubnodeConfig() throws ConfigurationException {
        String newValue = "I am autosaved";
        this.conf.setFile(this.testSaveConf);
        this.conf.setAutoSave(true);
        SubnodeConfiguration sub1 = this.conf.configurationAt("element2");
        SubnodeConfiguration sub2 = sub1.configurationAt("subelement");
        sub2.setProperty("subsubelement", (Object)"I am autosaved");
        Assert.assertEquals((String)"Change not visible to parent", (Object)"I am autosaved", (Object)this.conf.getString("element2.subelement.subsubelement"));
        XMLConfiguration conf2 = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((String)"Change was not saved", (Object)"I am autosaved", (Object)conf2.getString("element2.subelement.subsubelement"));
    }

    @Test
    public void testSaveDelimiterParsingDisabled() throws ConfigurationException {
        this.checkSaveDelimiterParsingDisabled("list.delimiter.test");
    }

    @Test
    public void testSaveDelimiterParsingDisabledAttrs() throws ConfigurationException {
        this.checkSaveDelimiterParsingDisabled("list.delimiter.test[@attr]");
    }

    private void checkSaveDelimiterParsingDisabled(String key) throws ConfigurationException {
        this.conf.clear();
        this.conf.setDelimiterParsingDisabled(true);
        this.conf.load();
        this.conf.setProperty(key, (Object)"C:\\Temp\\,C:\\Data\\");
        this.conf.addProperty(key, (Object)"a,b,c");
        this.conf.save(this.testSaveConf);
        XMLConfiguration checkConf = new XMLConfiguration();
        checkConf.setDelimiterParsingDisabled(true);
        checkConf.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)checkConf);
    }

    @Test
    public void testDelimiterParsingDisabledMultiAttrValues() throws ConfigurationException {
        this.conf.clear();
        this.conf.setDelimiterParsingDisabled(true);
        this.conf.load();
        List expr = this.conf.getList("expressions[@value]");
        Assert.assertEquals((String)"Wrong list size", (long)2L, (long)expr.size());
        Assert.assertEquals((String)"Wrong element 1", (Object)"a || (b && c)", expr.get(0));
        Assert.assertEquals((String)"Wrong element 2", (Object)"!d", expr.get(1));
    }

    @Test
    public void testMultipleAttrValuesEscaped() throws ConfigurationException {
        this.conf.addProperty("test.dir[@name]", (Object)"C:\\Temp\\");
        this.conf.addProperty("test.dir[@name]", (Object)"C:\\Data\\");
        this.conf.save(this.testSaveConf);
        XMLConfiguration checkConf = new XMLConfiguration();
        checkConf.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)checkConf);
    }

    @Test
    public void testAutoSaveWithReloadingStrategy() throws ConfigurationException {
        this.conf.setFile(this.testSaveConf);
        this.conf.save();
        this.conf.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        this.conf.setAutoSave(true);
        Assert.assertEquals((String)"Value not found", (Object)"value", (Object)this.conf.getProperty("element"));
    }

    @Test
    public void testAddNodesCopy() throws ConfigurationException {
        XMLConfiguration c2 = new XMLConfiguration(this.testProperties2);
        this.conf.addNodes("copiedProperties", (Collection)c2.getRootNode().getChildren());
        this.conf.save(this.testSaveConf);
        XMLConfiguration checkConf = new XMLConfiguration();
        checkConf.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)checkConf);
    }

    @Test
    public void testAutoSaveAddNodes() throws ConfigurationException {
        this.conf.setFile(this.testSaveConf);
        this.conf.setAutoSave(true);
        HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node("addNodesTest", (Object)Boolean.TRUE);
        ArrayList<HierarchicalConfiguration.Node> nodes = new ArrayList<HierarchicalConfiguration.Node>(1);
        nodes.add(node);
        this.conf.addNodes("test.autosave", nodes);
        XMLConfiguration c2 = new XMLConfiguration(this.testSaveConf);
        Assert.assertTrue((String)"Added nodes are not saved", (boolean)c2.getBoolean("test.autosave.addNodesTest"));
    }

    @Test
    public void testAddNodesAndSave() throws ConfigurationException {
        HierarchicalConfiguration.Node node = new HierarchicalConfiguration.Node("test");
        HierarchicalConfiguration.Node child = new HierarchicalConfiguration.Node("child");
        node.addChild((ConfigurationNode)child);
        HierarchicalConfiguration.Node attr = new HierarchicalConfiguration.Node("attr");
        node.addAttribute((ConfigurationNode)attr);
        HierarchicalConfiguration.Node node2 = this.conf.createNode("test2");
        ArrayList<HierarchicalConfiguration.Node> nodes = new ArrayList<HierarchicalConfiguration.Node>(2);
        nodes.add(node);
        nodes.add(node2);
        this.conf.addNodes("add.nodes", nodes);
        this.conf.setFile(this.testSaveConf);
        this.conf.save();
        this.conf.setProperty("add.nodes.test", (Object)"true");
        this.conf.setProperty("add.nodes.test.child", (Object)"yes");
        this.conf.setProperty("add.nodes.test[@attr]", (Object)"existing");
        this.conf.setProperty("add.nodes.test2", (Object)"anotherValue");
        this.conf.save();
        XMLConfiguration c2 = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((String)"Value was not saved", (Object)"true", (Object)c2.getString("add.nodes.test"));
        Assert.assertEquals((String)"Child value was not saved", (Object)"yes", (Object)c2.getString("add.nodes.test.child"));
        Assert.assertEquals((String)"Attr value was not saved", (Object)"existing", (Object)c2.getString("add.nodes.test[@attr]"));
        Assert.assertEquals((String)"Node2 not saved", (Object)"anotherValue", (Object)c2.getString("add.nodes.test2"));
    }

    @Test
    public void testRegisterEntityId() throws Exception {
        URL dtdURL = this.getClass().getResource("/properties.dtd");
        String publicId = "http://commons.apache.org/test/properties.dtd";
        this.conf = new XMLConfiguration("testDtd.xml");
        this.conf.setPublicID("http://commons.apache.org/test/properties.dtd");
        this.conf.save(this.testSaveConf);
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setFile(this.testSaveConf);
        checkConfig.registerEntityId("http://commons.apache.org/test/properties.dtd", dtdURL);
        checkConfig.setValidating(true);
        this.checkSavedConfig((FileConfiguration)checkConfig);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterEntityIdNull() throws IOException {
        this.conf.registerEntityId(null, new URL("http://commons.apache.org"));
    }

    @Test
    public void testSaveAfterCreateWithCopyConstructor() throws ConfigurationException {
        SubnodeConfiguration hc = this.conf.configurationAt("element2");
        this.conf = new XMLConfiguration((HierarchicalConfiguration)hc);
        this.conf.save(this.testSaveConf);
        XMLConfiguration checkConfig = new XMLConfiguration();
        checkConfig.setFile(this.testSaveConf);
        this.checkSavedConfig((FileConfiguration)checkConfig);
        Assert.assertEquals((String)"Wrong name of root element", (Object)"element2", (Object)checkConfig.getRootElementName());
    }

    @Test
    public void testCopyRootName() throws ConfigurationException {
        String rootName = "rootElement";
        String xml = "<rootElement><test>true</test></rootElement>";
        this.conf.clear();
        this.conf.load((Reader)new StringReader("<rootElement><test>true</test></rootElement>"));
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        Assert.assertEquals((String)"Wrong name of root element", (Object)"rootElement", (Object)copy.getRootElementName());
        copy.save(this.testSaveConf);
        copy = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((String)"Wrong name of root element after save", (Object)"rootElement", (Object)copy.getRootElementName());
    }

    @Test
    public void testCopyRootNameNoDocument() throws ConfigurationException {
        String rootName = "rootElement";
        this.conf = new XMLConfiguration();
        this.conf.setRootElementName("rootElement");
        this.conf.setProperty("test", (Object)Boolean.TRUE);
        XMLConfiguration copy = new XMLConfiguration((HierarchicalConfiguration)this.conf);
        Assert.assertEquals((String)"Wrong name of root element", (Object)"rootElement", (Object)copy.getRootElementName());
        copy.save(this.testSaveConf);
        copy = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((String)"Wrong name of root element after save", (Object)"rootElement", (Object)copy.getRootElementName());
    }

    @Test
    public void testAddNodesAttributeNode() {
        this.conf.addProperty("testAddNodes.property[@name]", (Object)"prop1");
        this.conf.addProperty("testAddNodes.property(0).value", (Object)"value1");
        this.conf.addProperty("testAddNodes.property(-1)[@name]", (Object)"prop2");
        this.conf.addProperty("testAddNodes.property(1).value", (Object)"value2");
        ArrayList<HierarchicalConfiguration.Node> nodes = new ArrayList<HierarchicalConfiguration.Node>();
        nodes.add(new HierarchicalConfiguration.Node("property"));
        this.conf.addNodes("testAddNodes", nodes);
        nodes.clear();
        HierarchicalConfiguration.Node nd = new HierarchicalConfiguration.Node("name", (Object)"prop3");
        nd.setAttribute(true);
        nodes.add(nd);
        this.conf.addNodes("testAddNodes.property(2)", nodes);
        Assert.assertEquals((String)"Attribute not added", (Object)"prop3", (Object)this.conf.getString("testAddNodes.property(2)[@name]"));
    }

    @Test
    public void testPreserveSpace() {
        Assert.assertEquals((String)"Wrong value of blanc", (Object)" ", (Object)this.conf.getString("space.blanc"));
        Assert.assertEquals((String)"Wrong value of stars", (Object)" * * ", (Object)this.conf.getString("space.stars"));
    }

    @Test
    public void testPreserveSpaceOnElement() {
        Assert.assertEquals((String)"Wrong value", (Object)" preserved ", (Object)this.conf.getString("spaceElement"));
    }

    @Test
    public void testPreserveSpaceOverride() {
        Assert.assertEquals((String)"Not trimmed", (Object)"Some text", (Object)this.conf.getString("space.description"));
    }

    @Test
    public void testPreserveSpaceInvalid() {
        Assert.assertEquals((String)"Invalid not trimmed", (Object)"Some other text", (Object)this.conf.getString("space.testInvalid"));
    }

    @Test
    public void testAttributeSplittingDisabled() throws ConfigurationException {
        List values = this.conf.getList("expressions[@value2]");
        Assert.assertEquals((String)"Wrong number of attribute values", (long)2L, (long)values.size());
        Assert.assertEquals((String)"Wrong value 1", (Object)"a", values.get(0));
        Assert.assertEquals((String)"Wrong value 2", (Object)"b|c", values.get(1));
        XMLConfiguration conf2 = new XMLConfiguration();
        conf2.setAttributeSplittingDisabled(true);
        conf2.setFile(this.conf.getFile());
        conf2.load();
        Assert.assertEquals((String)"Attribute was split", (Object)"a,b|c", (Object)conf2.getString("expressions[@value2]"));
    }

    @Test
    public void testAttributeSplittingAndDelimiterParsingDisabled() throws ConfigurationException {
        this.conf.clear();
        this.conf.setDelimiterParsingDisabled(true);
        this.conf.load();
        List values = this.conf.getList("expressions[@value2]");
        Assert.assertEquals((String)"Wrong number of attribute values", (long)2L, (long)values.size());
        Assert.assertEquals((String)"Wrong value 1", (Object)"a,b", values.get(0));
        Assert.assertEquals((String)"Wrong value 2", (Object)"c", values.get(1));
        XMLConfiguration conf2 = new XMLConfiguration();
        conf2.setAttributeSplittingDisabled(true);
        conf2.setDelimiterParsingDisabled(true);
        conf2.setFile(this.conf.getFile());
        conf2.load();
        Assert.assertEquals((String)"Attribute was split", (Object)"a,b|c", (Object)conf2.getString("expressions[@value2]"));
    }

    @Test
    public void testSaveWithValidation() throws Exception {
        CatalogResolver resolver = new CatalogResolver();
        resolver.setCatalogFiles(CATALOG_FILES);
        this.conf = new XMLConfiguration();
        this.conf.setEntityResolver((EntityResolver)resolver);
        this.conf.setFileName(this.testFile2);
        this.conf.setSchemaValidation(true);
        this.conf.load();
        this.conf.setProperty("Employee.SSN", (Object)"123456789");
        this.conf.validate();
        this.conf.save(this.testSaveConf);
        this.conf = new XMLConfiguration(this.testSaveConf);
        Assert.assertEquals((Object)"123456789", (Object)this.conf.getString("Employee.SSN"));
    }

    @Test
    public void testSaveWithValidationFailure() throws Exception {
        CatalogResolver resolver = new CatalogResolver();
        resolver.setCatalogFiles(CATALOG_FILES);
        this.conf = new XMLConfiguration();
        this.conf.setEntityResolver((EntityResolver)resolver);
        this.conf.setFileName(this.testFile2);
        this.conf.setSchemaValidation(true);
        this.conf.load();
        this.conf.setProperty("Employee.Email", (Object)"JohnDoe@apache.org");
        try {
            this.conf.validate();
            Assert.fail((String)"No validation failure on save");
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            Assert.assertNotNull((String)"No cause for exception on save", (Object)cause);
            Assert.assertTrue((String)"Incorrect exception on save", (boolean)(cause instanceof SAXParseException));
        }
    }

    @Test
    public void testConcurrentGetAndReload() throws Exception {
        int i;
        XMLConfiguration config = new XMLConfiguration("test.xml");
        config.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        Assert.assertTrue((String)"Property not found", (config.getProperty("test.short") != null ? 1 : 0) != 0);
        Thread[] testThreads = new Thread[5];
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i] = new ReloadThread((FileConfiguration)config);
            testThreads[i].start();
        }
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((String)"Property not found", (config.getProperty("test.short") != null ? 1 : 0) != 0);
        }
        for (i = 0; i < testThreads.length; ++i) {
            testThreads[i].join();
        }
    }

    @Test
    public void testSaveWindowsPath() throws ConfigurationException {
        this.conf.clear();
        this.conf.addProperty("path", (Object)"C:\\Temp");
        StringWriter writer = new StringWriter();
        this.conf.save((Writer)writer);
        String content = writer.toString();
        Assert.assertTrue((String)("Path not found: " + content), (content.indexOf("<path>C:\\Temp</path>") >= 0 ? 1 : 0) != 0);
        this.conf.save(this.testSaveFile);
        XMLConfiguration conf2 = new XMLConfiguration(this.testSaveFile);
        Assert.assertEquals((String)"Wrong windows path", (Object)"C:\\Temp", (Object)conf2.getString("path"));
    }

    @Test
    public void testEmptyAttribute() throws ConfigurationException {
        String key = "element3[@value]";
        this.conf.setProperty(key, (Object)"");
        Assert.assertTrue((String)"Key not found", (boolean)this.conf.containsKey(key));
        Assert.assertEquals((String)"Wrong value", (Object)"", (Object)this.conf.getString(key));
        this.conf.save(this.testSaveConf);
        this.conf = new XMLConfiguration();
        this.conf.load(this.testSaveConf);
        Assert.assertTrue((String)"Key not found after save", (boolean)this.conf.containsKey(key));
        Assert.assertEquals((String)"Wrong value after save", (Object)"", (Object)this.conf.getString(key));
    }

    @Test
    public void testAddNodesToSubnodeConfiguration() throws Exception {
        SubnodeConfiguration sub = this.conf.configurationAt("element2");
        sub.addProperty("newKey", (Object)"newvalue");
        ConfigurationNode root = this.conf.getRootNode();
        ConfigurationNode elem = (ConfigurationNode)root.getChildren("element2").get(0);
        ConfigurationNode newNode = (ConfigurationNode)elem.getChildren("newKey").get(0);
        Assert.assertTrue((String)("Wrong node type: " + newNode), (boolean)(newNode instanceof XMLConfiguration.XMLNode));
    }

    @Test
    public void testSetPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        String prop = "delimiterListProp";
        this.conf.setDelimiterParsingDisabled(true);
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.setProperty(prop, list);
        this.conf.setFile(this.testSaveFile);
        this.conf.save();
        this.conf.clear();
        this.conf.load();
        Assert.assertEquals((String)"Wrong list property", list, (Object)this.conf.getProperty(prop));
    }

    @Test
    public void testAddPropertyListWithDelimiterParsingDisabled() throws ConfigurationException {
        String prop = "delimiterListProp";
        this.conf.setDelimiterParsingDisabled(true);
        List<String> list = Arrays.asList("val", "val2", "val3");
        this.conf.addProperty(prop, list);
        this.conf.setFile(this.testSaveFile);
        this.conf.save();
        this.conf.clear();
        this.conf.load();
        Assert.assertEquals((String)"Wrong list property", list, (Object)this.conf.getProperty(prop));
    }

    private XMLConfiguration setUpReloadTest() throws ConfigurationException {
        this.removeTestFile();
        this.conf.save(this.testSaveConf);
        XMLConfiguration c = new XMLConfiguration(this.testSaveConf);
        c.setReloadingStrategy((ReloadingStrategy)new FileAlwaysReloadingStrategy());
        this.conf.setProperty("test(0).entity", (Object)"newValue");
        this.conf.save(this.testSaveConf);
        return c;
    }

    private void removeTestFile() {
        if (this.testSaveConf.exists()) {
            Assert.assertTrue((boolean)this.testSaveConf.delete());
        }
    }

    private void checkSavedConfig(FileConfiguration checkConfig) throws ConfigurationException {
        checkConfig.load();
        ConfigurationAssert.assertEquals((Configuration)this.conf, (Configuration)checkConfig);
    }

    private class ReloadThread
    extends Thread {
        FileConfiguration config;

        ReloadThread(FileConfiguration config) {
            this.config = config;
        }

        public void run() {
            for (int i = 0; i < 100; ++i) {
                this.config.reload();
            }
        }
    }
}

