/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.core.resourceadapter;

import java.io.PrintWriter;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.logging.LoggerHelper;
import org.apache.cxf.jca.core.resourceadapter.AbstractManagedConnectionImpl;
import org.apache.cxf.jca.core.resourceadapter.ResourceBean;

public abstract class AbstractManagedConnectionFactoryImpl
extends ResourceBean
implements ManagedConnectionFactory {
    private static final long serialVersionUID = 1886331424891906960L;
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractManagedConnectionFactoryImpl.class);
    private PrintWriter printWriter;

    public AbstractManagedConnectionFactoryImpl() {
    }

    public AbstractManagedConnectionFactoryImpl(Properties props) {
        super(props);
    }

    public abstract Object createConnectionFactory(ConnectionManager var1) throws ResourceException;

    public abstract Object createConnectionFactory() throws ResourceException;

    public abstract ManagedConnection createManagedConnection(Subject var1, ConnectionRequestInfo var2) throws ResourceException;

    public abstract void close() throws ResourceAdapterInternalException;

    protected abstract void validateReference(AbstractManagedConnectionImpl var1, Subject var2) throws ResourceAdapterInternalException;

    public ManagedConnection matchManagedConnections(Set aMCSet, Subject subject, ConnectionRequestInfo crInfo) throws ResourceException {
        LOG.log(Level.FINE, "MATCHING_CONNECTIONS", new Object[]{aMCSet.size(), crInfo, subject});
        for (AbstractManagedConnectionImpl conn : aMCSet) {
            LOG.log(Level.FINE, "MATCH_CONNECTION_AGAINST", new Object[]{conn.getConnectionRequestInfo(), crInfo});
            if (!conn.isBound()) {
                LOG.fine("Match against unbounded, con= " + String.valueOf(conn) + ", info=" + String.valueOf(crInfo));
                return conn;
            }
            if (!this.isMatch(conn, crInfo, subject)) continue;
            LOG.fine("Match against bounded, con= " + String.valueOf(conn) + ", info=" + String.valueOf(crInfo));
            return conn;
        }
        return null;
    }

    private boolean isMatch(AbstractManagedConnectionImpl candidateConn, ConnectionRequestInfo crInfo, Subject subject) throws ResourceAdapterInternalException {
        boolean result = false;
        ConnectionRequestInfo candidate = candidateConn.getConnectionRequestInfo();
        if (candidate.equals((Object)crInfo) && (subject == null || subject.equals(candidateConn.getSubject()))) {
            try {
                this.validateReference(candidateConn, subject);
                result = true;
            }
            catch (Exception thrown) {
                result = false;
            }
        }
        return result;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.printWriter;
    }

    public void setLogWriter(PrintWriter aPrintWriter) throws ResourceException {
        if (aPrintWriter == null) {
            throw new IllegalArgumentException("NULL_LOG_WRITER");
        }
        this.printWriter = aPrintWriter;
        LoggerHelper.initializeLoggingOnWriter(this.printWriter);
    }
}

