/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;

public final class BroadcastGroupConfiguration
implements Serializable {
    private static final long serialVersionUID = 2335634694112319124L;
    private String name = null;
    private long broadcastPeriod = ActiveMQDefaultConfiguration.getDefaultBroadcastPeriod();
    private BroadcastEndpointFactory endpointFactory = null;
    private List<String> connectorInfos = null;

    public String getName() {
        return this.name;
    }

    public long getBroadcastPeriod() {
        return this.broadcastPeriod;
    }

    public List<String> getConnectorInfos() {
        return this.connectorInfos;
    }

    public BroadcastGroupConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public BroadcastGroupConfiguration setBroadcastPeriod(long broadcastPeriod) {
        this.broadcastPeriod = broadcastPeriod;
        return this;
    }

    public BroadcastGroupConfiguration setConnectorInfos(List<String> connectorInfos) {
        this.connectorInfos = connectorInfos;
        return this;
    }

    public BroadcastEndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public BroadcastGroupConfiguration setEndpointFactory(BroadcastEndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.broadcastPeriod, this.connectorInfos, this.endpointFactory, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BroadcastGroupConfiguration)) {
            return false;
        }
        BroadcastGroupConfiguration other = (BroadcastGroupConfiguration)obj;
        return this.broadcastPeriod == other.broadcastPeriod && Objects.equals(this.connectorInfos, other.connectorInfos) && Objects.equals(this.endpointFactory, other.endpointFactory) && Objects.equals(this.name, other.name);
    }
}

