/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class DataSourceSerializationTest
extends BaseJDBCTestCase {
    private static final String VERSION_10_0_2_1 = "10_0_2_1";
    private static final String VERSION_10_1_3_1 = "10_1_3_1";
    private static final String VERSION_10_2_2_0 = "10_2_2_0";
    private static final String VERSION_10_3_2_1 = "10_3_2_1";
    private static final String VERSION_10_10_1_0 = "10_10_1_0";
    private static final String VERSION_10_11_1_0 = "10_11_1_0";
    private final String _40Suffix = "40";

    public DataSourceSerializationTest(String name) {
        super(name);
    }

    public void serTestEmbeddedDataSource() throws Exception {
        String EMBEDDED_CLASS;
        if (JDBC.vmSupportsJNDI()) {
            EMBEDDED_CLASS = "EmbeddedDataSource";
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_0_2_1, true);
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("EmbeddedDataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("EmbeddedDataSource40", VERSION_10_10_1_0, true);
        }
        EMBEDDED_CLASS = "BasicEmbeddedDataSource40";
        this.deSerializeDs("BasicEmbeddedDataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestEmbeddedConnectionPoolDataSource() throws Exception {
        String EMBEDDED_CLASS;
        if (JDBC.vmSupportsJNDI()) {
            EMBEDDED_CLASS = "EmbeddedConnectionPoolDataSource";
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_0_2_1, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("EmbeddedConnectionPoolDataSource40", VERSION_10_10_1_0, true);
        }
        EMBEDDED_CLASS = "BasicEmbeddedConnectionPoolDataSource40";
        this.deSerializeDs("BasicEmbeddedConnectionPoolDataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestEmbeddedXADataSource() throws Exception {
        String EMBEDDED_CLASS;
        if (JDBC.vmSupportsJNDI()) {
            EMBEDDED_CLASS = "EmbeddedXADataSource";
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_0_2_1, true);
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("EmbeddedXADataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("EmbeddedXADataSource40", VERSION_10_10_1_0, true);
        }
        EMBEDDED_CLASS = "BasicEmbeddedXADataSource40";
        this.deSerializeDs("BasicEmbeddedXADataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestClientDataSource() throws Exception {
        String CLIENT_CLASS;
        if (JDBC.vmSupportsJNDI()) {
            CLIENT_CLASS = "ClientDataSource";
            this.deSerializeDs("ClientDataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("ClientDataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("ClientDataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("ClientDataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("ClientDataSource40", VERSION_10_10_1_0, true);
        }
        CLIENT_CLASS = "BasicClientDataSource40";
        this.deSerializeDs("BasicClientDataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestClientConnectionPoolDataSource() throws Exception {
        String CLIENT_CLASS;
        if (JDBC.vmSupportsJNDI()) {
            CLIENT_CLASS = "ClientConnectionPoolDataSource";
            this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("ClientConnectionPoolDataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("ClientConnectionPoolDataSource40", VERSION_10_10_1_0, true);
        }
        CLIENT_CLASS = "BasicClientConnectionPoolDataSource40";
        this.deSerializeDs("BasicClientConnectionPoolDataSource40", VERSION_10_10_1_0, false);
    }

    public void serTestClientXADataSource() throws Exception {
        String CLIENT_CLASS;
        if (JDBC.vmSupportsJNDI()) {
            CLIENT_CLASS = "ClientXADataSource";
            this.deSerializeDs("ClientXADataSource", VERSION_10_1_3_1, true);
            this.deSerializeDs("ClientXADataSource", VERSION_10_2_2_0, true);
            this.deSerializeDs("ClientXADataSource", VERSION_10_3_2_1, true);
            this.deSerializeDs("ClientXADataSource", VERSION_10_10_1_0, true);
            this.deSerializeDs("ClientXADataSource40", VERSION_10_10_1_0, true);
        }
        CLIENT_CLASS = "BasicClientXADataSource40";
        this.deSerializeDs("BasicClientXADataSource40", VERSION_10_10_1_0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deSerializeDs(String className, String version, boolean dsHasJNDI) throws Exception {
        if (!JDBC.vmSupportsJDBC4() && className.contains("40")) {
            return;
        }
        StringBuffer fname = new StringBuffer(className);
        fname.append('-');
        fname.append(version);
        fname.append(".ser");
        DataSourceSerializationTest.println("Deserializing " + fname.toString());
        FileInputStream is = new FileInputStream(SupportFilesSetup.getReadOnly(fname.toString()));
        DataSourceSerializationTest.assertNotNull((String)"FileInputStream is null", (Object)is);
        Object dsObj = null;
        DataSource ds = null;
        Object dsRef = null;
        boolean testSequencePassed = false;
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            String buildVersion = ois.readUTF();
            String buildNumber = ois.readUTF();
            DataSourceSerializationTest.println("Data source " + className + ", version " + buildVersion + ", build " + buildNumber);
            dsObj = ois.readObject();
            DataSourceSerializationTest.assertNotNull((String)"De-serialized data source is null", (Object)dsObj);
            DataSourceSerializationTest.assertTrue((String)("Unexpected class instantiated: " + dsObj.getClass().getName()), (dsObj.getClass().getName().indexOf(className) > 0 ? 1 : 0) != 0);
            ds = (DataSource)dsObj;
            int newTimeout = ds.getLoginTimeout() + 9;
            DataSourceSerializationTest.assertFalse((ds.getLoginTimeout() == newTimeout ? 1 : 0) != 0);
            ds.setLoginTimeout(newTimeout);
            DataSourceSerializationTest.assertEquals((int)newTimeout, (int)ds.getLoginTimeout());
            if (dsHasJNDI) {
                dsRef = ois.readObject();
            }
            ois.close();
            testSequencePassed = true;
        }
        finally {
            if (testSequencePassed) {
                ((InputStream)is).close();
            } else {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ois) {}
            }
        }
        if (dsHasJNDI) {
            Method getFactoryClassName = Class.forName("javax.naming.Reference").getMethod("getFactoryClassName", null);
            String factoryClassName = (String)getFactoryClassName.invoke(dsRef, null);
            Class<?> clazz = Class.forName(factoryClassName);
            Object factory = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method getObjectInstance = factory.getClass().getMethod("getObjectInstance", Class.forName("java.lang.Object"), Class.forName("javax.naming.Name"), Class.forName("javax.naming.Context"), Class.forName("java.util.Hashtable"));
            Object recreatedDs = getObjectInstance.invoke(factory, dsRef, null, null, null);
            ds = (DataSource)recreatedDs;
            DataSourceSerializationTest.assertTrue((String)("Unexpected class instantiated by Reference: " + dsObj.getClass().getName()), (dsObj.getClass().getName().indexOf(className) > 0 ? 1 : 0) != 0);
        }
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("DataSourceSerializationTest");
        String filePrefix = "functionTests/testData/serializedDataSources/";
        if (Derby.hasEmbedded()) {
            suite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedDataSource"));
            suite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedConnectionPoolDataSource"));
            suite.addTest((Test)new DataSourceSerializationTest("serTestEmbeddedXADataSource"));
        }
        if (Derby.hasClient()) {
            suite.addTest((Test)new DataSourceSerializationTest("serTestClientDataSource"));
            suite.addTest((Test)new DataSourceSerializationTest("serTestClientConnectionPoolDataSource"));
            suite.addTest((Test)new DataSourceSerializationTest("serTestClientXADataSource"));
        }
        return new SupportFilesSetup((Test)suite, new String[]{filePrefix + "EmbeddedDataSource-10_0_2_1.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_0_2_1.ser", filePrefix + "EmbeddedXADataSource-10_0_2_1.ser", filePrefix + "EmbeddedDataSource-10_1_3_1.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_1_3_1.ser", filePrefix + "EmbeddedXADataSource-10_1_3_1.ser", filePrefix + "ClientDataSource-10_1_3_1.ser", filePrefix + "ClientConnectionPoolDataSource-10_1_3_1.ser", filePrefix + "ClientXADataSource-10_1_3_1.ser", filePrefix + "EmbeddedDataSource-10_2_2_0.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_2_2_0.ser", filePrefix + "EmbeddedXADataSource-10_2_2_0.ser", filePrefix + "ClientDataSource-10_2_2_0.ser", filePrefix + "ClientConnectionPoolDataSource-10_2_2_0.ser", filePrefix + "ClientXADataSource-10_2_2_0.ser", filePrefix + "EmbeddedDataSource-10_3_2_1.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_3_2_1.ser", filePrefix + "EmbeddedXADataSource-10_3_2_1.ser", filePrefix + "ClientDataSource-10_3_2_1.ser", filePrefix + "ClientConnectionPoolDataSource-10_3_2_1.ser", filePrefix + "ClientXADataSource-10_3_2_1.ser", filePrefix + "EmbeddedDataSource-10_10_1_0.ser", filePrefix + "EmbeddedDataSource40-10_10_1_0.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_10_1_0.ser", filePrefix + "EmbeddedConnectionPoolDataSource40-10_10_1_0.ser", filePrefix + "EmbeddedXADataSource-10_10_1_0.ser", filePrefix + "EmbeddedXADataSource40-10_10_1_0.ser", filePrefix + "ClientDataSource-10_10_1_0.ser", filePrefix + "ClientDataSource40-10_10_1_0.ser", filePrefix + "ClientConnectionPoolDataSource-10_10_1_0.ser", filePrefix + "ClientConnectionPoolDataSource40-10_10_1_0.ser", filePrefix + "ClientXADataSource-10_10_1_0.ser", filePrefix + "ClientXADataSource40-10_10_1_0.ser", filePrefix + "BasicEmbeddedDataSource40-10_10_1_0.ser", filePrefix + "BasicEmbeddedConnectionPoolDataSource40-10_10_1_0.ser", filePrefix + "BasicEmbeddedXADataSource40-10_10_1_0.ser", filePrefix + "BasicClientDataSource40-10_10_1_0.ser", filePrefix + "BasicClientConnectionPoolDataSource40-10_10_1_0.ser", filePrefix + "BasicClientXADataSource40-10_10_1_0.ser", filePrefix + "EmbeddedDataSource-10_11_1_0.ser", filePrefix + "EmbeddedDataSource40-10_11_1_0.ser", filePrefix + "EmbeddedConnectionPoolDataSource-10_11_1_0.ser", filePrefix + "EmbeddedConnectionPoolDataSource40-10_11_1_0.ser", filePrefix + "EmbeddedXADataSource-10_11_1_0.ser", filePrefix + "EmbeddedXADataSource40-10_11_1_0.ser", filePrefix + "ClientDataSource-10_11_1_0.ser", filePrefix + "ClientDataSource40-10_11_1_0.ser", filePrefix + "ClientConnectionPoolDataSource-10_11_1_0.ser", filePrefix + "ClientConnectionPoolDataSource40-10_11_1_0.ser", filePrefix + "ClientXADataSource-10_11_1_0.ser", filePrefix + "ClientXADataSource40-10_11_1_0.ser", filePrefix + "BasicEmbeddedDataSource40-10_11_1_0.ser", filePrefix + "BasicEmbeddedConnectionPoolDataSource40-10_11_1_0.ser", filePrefix + "BasicEmbeddedXADataSource40-10_11_1_0.ser", filePrefix + "BasicClientDataSource40-10_11_1_0.ser", filePrefix + "BasicClientConnectionPoolDataSource40-10_11_1_0.ser", filePrefix + "BasicClientXADataSource40-10_11_1_0.ser"});
    }
}

