/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.shared.common.error.DerbySQLIntegrityConstraintViolationException;
import org.apache.derbyTesting.functionTests.tests.lang.DBOperations;
import org.apache.derbyTesting.functionTests.tests.lang.LockTableTest;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.XATestUtil;

public class ConstraintCharacteristicsTest
extends BaseJDBCTestCase {
    private static final String LANG_DUPLICATE_KEY_CONSTRAINT = "23505";
    private static final String LANG_DEFERRED_DUP_VIOLATION_T = "23506";
    private static final String LANG_DEFERRED_DUP_VIOLATION_S = "23507";
    private static final String LANG_CHECK_CONSTRAINT_VIOLATED = "23513";
    private static final String LANG_DEFERRED_CHECK_VIOLATION_T = "23514";
    private static final String LANG_DEFERRED_CHECK_VIOLATION_S = "23515";
    private static final String LANG_DEFERRED_FK_VIOLATION_T = "23516";
    private static final String LANG_DEFERRED_FK_VIOLATION_S = "23517";
    private static final String LOCK_TIMEOUT = "40XL1";
    private static final String LANG_INCONSISTENT_C_CHARACTERISTICS = "42X97";
    private static final String LANG_DROP_OR_ALTER_NON_EXISTING_C = "42X86";
    private static final String LANG_SYNTAX_ERROR = "42X01";
    private static final String NOT_IMPLEMENTED = "0A000";
    private static final String LANG_NOT_NULL_CHARACTERISTICS = "42XAN";
    private static final String LANG_OBJECT_NOT_FOUND = "42X94";
    private static final String LANG_DB2_DUPLICATE_NAMES = "42734";
    private static final String LANG_ADD_CHECK_CONSTRAINT_FAILED = "X0Y59";
    private static String expImpDataFile;
    private static String expImpDataWithNullsFile;
    private static boolean exportFilesCreatedEmbedded;
    private static boolean exportFilesCreatedClient;
    private static final int WAIT_TIMEOUT_DURATION = 1;
    static final String[] uniqueForms;
    static final String[] uniqueSpec;
    static final String[] checkForms;
    static final String[] fkForms;
    static final String[] checkSpec;
    static final String[][] initialContents;
    static final String[][] negatedInitialContents;
    static final String[] setConstraintsForms;
    static final long NO_OF_INSERTED_ROWS = 4096L;
    static final String DID = "deferrable initially deferred";
    private static final String[] tableConstraintTypes;
    private static final String[] columnConstraintTypes;
    private static final String[][] defaultCharacteristics;
    private static final String[][] nonDefaultCharacteristics;
    private static final String[] illegalCharacteristics;
    private static final String[] illegalAlterCharacteristics;
    private static final Map<String, String[]> inverseState;

    public ConstraintCharacteristicsTest(String name) {
        super(name);
    }

    public static Test suite() {
        String nameRoot = ConstraintCharacteristicsTest.class.getName();
        BaseTestSuite suite = new BaseTestSuite(nameRoot);
        suite.addTest(ConstraintCharacteristicsTest.baseSuite1(nameRoot + ":embedded 1"));
        suite.addTest(TestConfiguration.clientServerDecorator(ConstraintCharacteristicsTest.baseSuite1(nameRoot + ":client 1")));
        suite.addTest(ConstraintCharacteristicsTest.baseSuite2(nameRoot + ":embedded 2"));
        suite.addTest(TestConfiguration.clientServerDecorator(ConstraintCharacteristicsTest.baseSuite2(nameRoot + ":client 2")));
        suite.addTest(ConstraintCharacteristicsTest.baseSuite3(nameRoot + ":embedded 3"));
        suite.addTest(TestConfiguration.clientServerDecorator(ConstraintCharacteristicsTest.baseSuite3(nameRoot + ":client 3")));
        return suite;
    }

    private static Test baseSuite3(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTest((Test)new ConstraintCharacteristicsTest("testDeferredRowsInvalidation"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testLockingForUniquePK"));
        Properties systemProperties = new Properties();
        systemProperties.setProperty("derby.locks.waitTimeout", Integer.toString(1));
        return new SupportFilesSetup((Test)new SystemPropertyTestSetup((Test)suite, systemProperties, true));
    }

    private static Test baseSuite2(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        Properties systemProperties = new Properties();
        systemProperties.setProperty("derby.language.logQueryPlan", "true");
        suite.addTest((Test)new SupportFilesSetup((Test)new SystemPropertyTestSetup((Test)new ConstraintCharacteristicsTest("testDerby6666"), systemProperties, true)));
        return suite;
    }

    private static Test baseSuite1(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTest((Test)new ConstraintCharacteristicsTest("testSyntaxAndBinding"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testDropNotNullOnUniqueColumn"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testCompressTableOKUnique"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testLockingForUniquePKWithCommit"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testLockingForUniquePKWithRollback"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testDatabaseMetaData"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testCreateConstraintDictionaryEncodings"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testAlterConstraintDictionaryEncodings"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testAlterConstraintInvalidation"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testBasicDeferral"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testRoutines"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testImport"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testDerby6374"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testXA"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testAlmostRemovedAllDups"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testCheckConstraintsWithDeferredRows"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testSeveralCheckConstraints"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testDerby6670_a"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testDerby6670_b"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testManySimilarDuplicates"));
        suite.addTest((Test)new ConstraintCharacteristicsTest("testDerby6773"));
        Properties systemProperties = new Properties();
        systemProperties.setProperty("derby.locks.waitTimeout", Integer.toString(500));
        return new SupportFilesSetup((Test)new SystemPropertyTestSetup((Test)suite, systemProperties, true));
    }

    protected void setUp() throws Exception {
        super.setUp();
        Statement s = this.createStatement();
        s.executeUpdate("create table referenced(    i int primary key, j int default 0)");
        if (ConstraintCharacteristicsTest.usingEmbedded() && !exportFilesCreatedEmbedded || ConstraintCharacteristicsTest.usingDerbyNetClient() && !exportFilesCreatedClient) {
            if (ConstraintCharacteristicsTest.usingEmbedded()) {
                exportFilesCreatedEmbedded = true;
            } else {
                exportFilesCreatedClient = true;
            }
            expImpDataFile = SupportFilesSetup.getReadWrite("t.data").getPath();
            expImpDataWithNullsFile = SupportFilesSetup.getReadWrite("t_with_nulls.data").getPath();
            s.executeUpdate("create table t(i int)");
            s.executeUpdate("insert into t values 1,-2,-2, 3");
            s.executeUpdate("create table t_with_nulls(i int)");
            s.executeUpdate("insert into t_with_nulls values 1,null, null, 3");
            s.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null)");
            s.executeUpdate("call SYSCS_UTIL.SYSCS_EXPORT_TABLE (    'APP' , 'T_WITH_NULLS' , '" + expImpDataWithNullsFile + "', null, null , null)");
            s.executeUpdate("drop table t");
            s.executeUpdate("drop table t_with_nulls");
        }
        s.close();
        this.setAutoCommit(false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        this.setAutoCommit(true);
        this.getConnection().createStatement().executeUpdate("drop table referenced");
        super.tearDown();
    }

    public void testSyntaxAndBinding() throws SQLException {
        Connection c = this.getConnection();
        Statement s = c.createStatement();
        ConstraintCharacteristicsTest.assertTableLevelDefaultBehaviorAccepted(c, s);
        ConstraintCharacteristicsTest.assertTableLevelNonDefaultAccepted(s);
        s.executeUpdate("create table t(i int, constraint app.c primary key(i))");
        s.executeUpdate("alter table t alter constraint c enforced");
        ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, s, "alter table t alter constraint c not enforced");
        for (String ch : illegalAlterCharacteristics) {
            ConstraintCharacteristicsTest.assertStatementError(LANG_SYNTAX_ERROR, s, "alter table t alter constraint c " + ch);
        }
        ConstraintCharacteristicsTest.assertStatementError(LANG_DROP_OR_ALTER_NON_EXISTING_C, s, "alter table t alter constraint cuckoo not enforced");
        s.executeUpdate("alter table t drop constraint c");
        s.executeUpdate("alter table t add constraint c     primary key(i) deferrable");
        s.executeUpdate("set constraints c deferred");
        s.executeUpdate("set constraints all deferred");
        ConstraintCharacteristicsTest.assertStatementError(LANG_OBJECT_NOT_FOUND, s, "set constraints cuckoo deferred");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DB2_DUPLICATE_NAMES, s, "set constraints c,c deferred");
        c.rollback();
        ConstraintCharacteristicsTest.assertColumnLevelDefaultBehaviorAccepted(c, s);
        ConstraintCharacteristicsTest.assertColumnLevelNonDefaultAccepted(s);
        ConstraintCharacteristicsTest.assertStatementError(LANG_NOT_NULL_CHARACTERISTICS, s, "create table t(i int not null deferrable initially immediate)");
    }

    public void testCreateConstraintDictionaryEncodings() throws SQLException {
        Statement s = this.getConnection().createStatement();
        for (String[] stringArray : defaultCharacteristics) {
            this.assertDictState(s, stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : nonDefaultCharacteristics) {
            this.assertDictState(s, stringArray[0], stringArray[1]);
        }
        for (String[] stringArray : illegalCharacteristics) {
            this.assertCreateInconsistentCharacteristics(s, (String)stringArray);
        }
        this.rollback();
    }

    public void testAlterConstraintDictionaryEncodings() throws SQLException {
        Statement s = this.getConnection().createStatement();
        for (String[] stringArray : defaultCharacteristics) {
            s.executeUpdate("create table t(i int, constraint c primary key(i) " + stringArray[0] + ")");
            this.assertAlterDictState(s, "enforced");
            this.assertAlterDictState(s, "not enforced");
            this.rollback();
        }
        for (String[] stringArray : nonDefaultCharacteristics) {
            if (stringArray[0].contains("not enforced")) {
                ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, s, "create table t(i int, constraint c primary key(i) " + stringArray[0] + ")");
                continue;
            }
            s.executeUpdate("create table t(i int, constraint c primary key(i) " + stringArray[0] + ")");
            this.assertAlterDictState(s, "enforced");
            this.assertAlterDictState(s, "not enforced");
            this.rollback();
        }
        for (String[] stringArray : illegalAlterCharacteristics) {
            this.assertAlterInconsistentCharacteristics(s, (String)stringArray);
        }
    }

    public void testAlterConstraintInvalidation() throws SQLException {
        if (ConstraintCharacteristicsTest.usingDerbyNetClient()) {
            return;
        }
        Connection c = this.getConnection();
        Statement s = this.createStatement();
        s.executeUpdate("create table t(i int, constraint c primary key(i))");
        PreparedStatement ps = c.prepareStatement("insert into t values 3");
        ps.execute();
        s.executeUpdate("alter table t alter constraint c enforced ");
        LanguageConnectionContext lcc = ConstraintCharacteristicsTest.getLCC(c);
        GenericPreparedStatement derbyPs = (GenericPreparedStatement)lcc.getLastActivation().getPreparedStatement();
        ConstraintCharacteristicsTest.assertFalse((boolean)derbyPs.isValid());
        this.rollback();
    }

    public void testDatabaseMetaData() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t(i int not null     constraint c primary key deferrable initially immediate)");
        DatabaseMetaData dbmd = s.getConnection().getMetaData();
        ResultSet rs = dbmd.getIndexInfo(null, null, "T", false, false);
        rs.next();
        ConstraintCharacteristicsTest.assertEquals((String)"false", (String)rs.getString("NON_UNIQUE"));
        String[] cchars = new String[]{"deferrable initially immediate", DID, "not deferrable"};
        int[] dbmdState = new int[]{6, 5, 7};
        for (int i = 0; i < cchars.length; ++i) {
            s.executeUpdate("create table child(i int, constraint c2 foreign key(i)     references t(i) " + cchars[i] + ")");
            rs = dbmd.getImportedKeys(null, null, "CHILD");
            rs.next();
            ConstraintCharacteristicsTest.assertEquals((String)Integer.toString(dbmdState[i]), (String)rs.getString("DEFERRABILITY"));
            rs.close();
            rs = dbmd.getExportedKeys(null, null, "T");
            rs.next();
            ConstraintCharacteristicsTest.assertEquals((String)Integer.toString(dbmdState[i]), (String)rs.getString("DEFERRABILITY"));
            rs.close();
            rs = dbmd.getCrossReference(null, null, "T", null, null, "CHILD");
            rs.next();
            ConstraintCharacteristicsTest.assertEquals((String)Integer.toString(dbmdState[i]), (String)rs.getString("DEFERRABILITY"));
            rs.close();
            s.executeUpdate("drop table child");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockingForUniquePK() throws SQLException {
        Statement s2;
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(i int, constraint c1 primary key(i) not deferrable)");
        s.executeUpdate("create table t2(i int, constraint c2 primary key(i) deferrable initially deferred)");
        s.executeUpdate("insert into t1 values 1,2,3");
        s.executeUpdate("insert into t2 values 1,2,3");
        this.commit();
        s.executeUpdate("insert into t1 values 4");
        ResultSet rs = s.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTransaction", "TABLE", "2", "IX", "T1", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "ROW", "1", "X", "T1", "(1,10)", "GRANT", "ACTIVE"}});
        Connection c2 = null;
        try {
            c2 = this.openDefaultConnection();
            c2.setAutoCommit(false);
            s2 = c2.createStatement();
            ConstraintCharacteristicsTest.assertStatementError(LOCK_TIMEOUT, s2, "insert into t1 values 4");
        }
        finally {
            if (c2 != null) {
                c2.rollback();
                c2.close();
            }
        }
        this.commit();
        s.executeUpdate("insert into t2 values 4");
        rs = s.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTransaction", "TABLE", "1", "IS", "T2", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "TABLE", "2", "IX", "T2", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "ROW", "1", "X", "T2", "(1,10)", "GRANT", "ACTIVE"}});
        this.commit();
        s.executeUpdate("insert into t2 values 4");
        rs = s.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(rs, new String[][]{{"APP", "UserTransaction", "TABLE", "1", "IS", "T2", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "TABLE", "2", "IX", "T2", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTransaction", "ROW", "1", "X", "T2", "(1,11)", "GRANT", "ACTIVE"}});
        try {
            c2 = this.openDefaultConnection();
            c2.setAutoCommit(false);
            s2 = c2.createStatement();
            s2.executeUpdate("insert into t2 values 4");
            ConstraintCharacteristicsTest.assertCommitError(LOCK_TIMEOUT, c2);
        }
        finally {
            try {
                if (c2 != null) {
                    c2.rollback();
                    c2.close();
                }
            }
            catch (SQLException s22) {}
        }
        this.rollback();
        s.executeUpdate("insert into t2 values 5");
        c2 = this.openDefaultConnection();
        c2.setAutoCommit(false);
        s2 = c2.createStatement();
        s2.executeUpdate("insert into t2 values 5");
        this.commit();
        c2.rollback();
        s2.executeUpdate("insert into t2 values 10,12");
        s.executeUpdate("insert into t2 values 11,11");
        Statement us = this.createStatement(1003, 1008);
        rs = us.executeQuery("select * from t2 where i=11");
        rs.next();
        rs.deleteRow();
        rs.close();
        this.commit();
        c2.rollback();
        c2.close();
        s.executeUpdate("drop table t1");
        s.executeUpdate("drop table t2");
        this.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testBasicDeferral() throws SQLException {
        Statement s = this.createStatement();
        for (String sCF : setConstraintsForms) {
            int idx = 0;
            for (String ct : uniqueForms) {
                try {
                    s.executeUpdate(ct + " deferrable initially immediate)");
                    s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    this.commit();
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, s, "insert into t values (2,30)");
                    s.executeUpdate(sCF + " deferred");
                    s.executeUpdate("insert into t values (2,19),(2,21),(3,31)");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t"), new String[][]{{"1", "10"}, {"2", "20"}, {"3", "30"}, {"2", "19"}, {"2", "21"}, {"3", "31"}});
                    JDBC.assertFullResultSet(s.executeQuery("select * from t --DERBY-PROPERTIES constraint=c\n     order by i"), new String[][]{{"1", "10"}, {"2", "20"}, {"2", "19"}, {"2", "21"}, {"3", "30"}, {"3", "31"}});
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, s, sCF + " immediate");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, s, sCF + " immediate");
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_DUP_VIOLATION_T, this.getConnection());
                    JDBC.assertFullResultSet(s.executeQuery("select * from t"), initialContents);
                    s.executeUpdate(sCF + " immediate");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, s, "insert into t values (2,30)");
                    s.executeUpdate(sCF + " deferred");
                    s.executeUpdate("insert into t values (2,19),(2,21),(3,31)");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, s, sCF + " immediate");
                    this.rollback();
                    s.executeUpdate(sCF + " deferred");
                    s.executeUpdate("insert into t values (20,19),(200,21),(30,31)");
                    s.executeUpdate("update t set i=2 where i=20");
                    s.executeUpdate("update t set i=2 where i=200");
                    s.executeUpdate("update t set i=3 where i=30");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t --DERBY-PROPERTIES constraint=c\n     order by i"), new String[][]{{"1", "10"}, {"2", "20"}, {"2", "19"}, {"2", "21"}, {"3", "30"}, {"3", "31"}});
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_DUP_VIOLATION_T, this.getConnection());
                    JDBC.assertFullResultSet(s.executeQuery("select * from t"), initialContents);
                    JDBC.assertFullResultSet(s.executeQuery("select * from t --DERBY-PROPERTIES constraint=c\n     order by i"), initialContents);
                    ConstraintCharacteristicsTest.checkConsistencyOfBaseTableAndIndex(s);
                    s.execute("alter table t drop constraint c");
                    s.executeUpdate("insert into t values (2,19),(2,21),(3,31)");
                    this.commit();
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, s, "alter table t add constraint c " + uniqueSpec[idx]);
                    s.executeUpdate("alter table t add constraint c " + uniqueSpec[idx] + " deferrable initially deferred");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t --DERBY-PROPERTIES constraint=c\n     order by i"), new String[][]{{"1", "10"}, {"2", "20"}, {"2", "19"}, {"2", "21"}, {"3", "30"}, {"3", "31"}});
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_DUP_VIOLATION_T, this.getConnection());
                    ConstraintCharacteristicsTest.checkConsistencyOfBaseTableAndIndex(s);
                }
                finally {
                    ++idx;
                    this.dropTable("t");
                    this.commit();
                }
            }
            idx = 0;
            for (String ct : checkForms) {
                try {
                    s.executeUpdate(ct + " deferrable initially immediate)");
                    s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    this.commit();
                    ConstraintCharacteristicsTest.assertStatementError(LANG_CHECK_CONSTRAINT_VIOLATED, s, "insert into t values (-2,30)");
                    try {
                        s.execute("insert into t values (-2,30)");
                        ConstraintCharacteristicsTest.fail();
                    }
                    catch (DerbySQLIntegrityConstraintViolationException dsicve) {
                        ConstraintCharacteristicsTest.assertSQLState(LANG_CHECK_CONSTRAINT_VIOLATED, (SQLException)((Object)dsicve));
                        ConstraintCharacteristicsTest.assertEquals((String)"\"APP\".\"T\"", (String)dsicve.getTableName());
                        ConstraintCharacteristicsTest.assertEquals((String)"C", (String)dsicve.getConstraintName());
                    }
                    s.executeUpdate(sCF + " deferred");
                    s.executeUpdate("insert into t values (-2,30),(1,31),(-3,32)");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t"), new String[][]{{"1", "10"}, {"2", "20"}, {"3", "30"}, {"-2", "30"}, {"1", "31"}, {"-3", "32"}});
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, s, sCF + " immediate");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, s, sCF + " immediate");
                    try {
                        s.execute(sCF + " immediate");
                        ConstraintCharacteristicsTest.fail();
                    }
                    catch (DerbySQLIntegrityConstraintViolationException dsicve) {
                        ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_S, (SQLException)((Object)dsicve));
                        ConstraintCharacteristicsTest.assertEquals((String)"\"APP\".\"T\"", (String)dsicve.getTableName());
                        ConstraintCharacteristicsTest.assertEquals((String)"C", (String)dsicve.getConstraintName());
                    }
                    try {
                        this.getConnection().commit();
                        ConstraintCharacteristicsTest.fail();
                    }
                    catch (DerbySQLIntegrityConstraintViolationException dsicve) {
                        ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_T, (SQLException)((Object)dsicve));
                        ConstraintCharacteristicsTest.assertEquals((String)"\"APP\".\"T\"", (String)dsicve.getTableName());
                        ConstraintCharacteristicsTest.assertEquals((String)"C", (String)dsicve.getConstraintName());
                    }
                    JDBC.assertFullResultSet(s.executeQuery("select * from t"), initialContents);
                    s.executeUpdate(sCF + " immediate");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_CHECK_CONSTRAINT_VIOLATED, s, "insert into t values (-2,30)");
                    s.executeUpdate(sCF + " deferred");
                    s.executeUpdate("insert into t values (-2,19),(2,21),(-3,31)");
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, s, sCF + " immediate");
                    this.rollback();
                    s.executeUpdate(sCF + " deferred");
                    s.executeUpdate("insert into t values (20,19),(200,21),(30,31)");
                    s.executeUpdate("update t set i=-2 where i=20");
                    s.executeUpdate("update t set i=-3 where i=200");
                    s.executeUpdate("update t set i=-4 where i=30");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t order by j"), new String[][]{{"1", "10"}, {"-2", "19"}, {"2", "20"}, {"-3", "21"}, {"3", "30"}, {"-4", "31"}});
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
                    JDBC.assertFullResultSet(s.executeQuery("select * from t"), initialContents);
                    JDBC.assertFullResultSet(s.executeQuery("select * from t order by i"), initialContents);
                    ConstraintCharacteristicsTest.checkConsistencyOfBaseTableAndIndex(s);
                    s.execute("alter table t drop constraint c");
                    s.executeUpdate("insert into t values (-2,19),(2,21),(-3,31)");
                    this.commit();
                    ConstraintCharacteristicsTest.assertStatementError(LANG_ADD_CHECK_CONSTRAINT_FAILED, s, "alter table t add constraint c " + checkSpec[idx]);
                    s.executeUpdate("alter table t add constraint c " + checkSpec[idx] + " deferrable initially deferred");
                    JDBC.assertFullResultSet(s.executeQuery("select * from t order by i,j"), new String[][]{{"-3", "31"}, {"-2", "19"}, {"1", "10"}, {"2", "20"}, {"2", "21"}, {"3", "30"}});
                    ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
                    ConstraintCharacteristicsTest.checkConsistencyOfBaseTableAndIndex(s);
                }
                finally {
                    ++idx;
                    this.dropTable("t");
                    this.commit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRoutines() throws SQLException {
        Statement s = this.createStatement();
        for (String ct : uniqueForms) {
            try {
                s.executeUpdate(ct + " deferrable initially immediate)");
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.commit();
                this.declareCalledNested(s);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, s, "call calledNested(false)");
            }
            finally {
                this.dropTable("t");
            }
        }
        for (String setConstraintForm : setConstraintsForms) {
            for (String ct : uniqueForms) {
                try {
                    s.executeUpdate(ct + " deferrable initially deferred)");
                    s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    this.commit();
                    s.executeUpdate(setConstraintForm + " immediate");
                    this.declareCalledNested(s);
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, s, "call calledNested(false)");
                }
                finally {
                    this.dropTable("t");
                    this.commit();
                }
            }
        }
        for (String ct : uniqueForms) {
            try {
                s.executeUpdate(ct + " deferrable initially deferred)");
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.declareCalledNested(s);
                s.executeUpdate("call calledNested(false)");
            }
            finally {
                this.rollback();
            }
        }
        for (String ct : checkForms) {
            try {
                s.executeUpdate(ct + " deferrable initially immediate)");
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.commit();
                this.declareCalledNested(s);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_T, s, "call calledNested(true)");
            }
            finally {
                this.dropTable("t");
                this.commit();
            }
        }
        for (String setConstraintForm : setConstraintsForms) {
            for (String ct : checkForms) {
                try {
                    s.executeUpdate(ct + " deferrable initially deferred)");
                    s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    this.commit();
                    s.executeUpdate(setConstraintForm + " immediate");
                    this.declareCalledNested(s);
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_T, s, "call calledNested(true)");
                }
                finally {
                    this.dropTable("t");
                    this.commit();
                }
            }
        }
        for (String ct : checkForms) {
            try {
                s.executeUpdate(ct + " deferrable initially deferred)");
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(negatedInitialContents));
                this.declareCalledNested(s);
                s.executeUpdate("call calledNested(true)");
            }
            finally {
                this.rollback();
            }
        }
        for (String ct : checkForms) {
            try {
                s.executeUpdate(ct + " deferrable initially deferred)");
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(negatedInitialContents));
                this.declareCalledNestedSetImmediate(s);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, s, "call calledNestedSetImmediate()");
            }
            finally {
                this.rollback();
            }
        }
        for (String ct : fkForms) {
            try {
                s.executeUpdate(ct + " deferrable initially immediate)");
                s.executeUpdate("insert into referenced values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.commit();
                this.declareCalledNestedFk(s);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_T, s, "call calledNestedFk()");
            }
            finally {
                this.dropTable("t");
                this.dontThrow(s, "delete from referenced");
                this.commit();
            }
        }
        for (String setConstraintForm : setConstraintsForms) {
            for (String ct : fkForms) {
                try {
                    s.executeUpdate(ct + " deferrable initially deferred)");
                    s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                    s.executeUpdate("insert into referenced(i) select i from t");
                    this.commit();
                    s.executeUpdate(setConstraintForm + " immediate");
                    this.declareCalledNestedFk(s);
                    ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_T, s, "call calledNestedFk()");
                }
                finally {
                    this.dropTable("t");
                    this.dontThrow(s, "delete from referenced");
                    this.commit();
                }
            }
        }
        for (String ct : fkForms) {
            try {
                s.executeUpdate(ct + " deferrable initially deferred)");
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.declareCalledNestedFk(s);
                s.executeUpdate("call calledNestedFk()");
                ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_FK_VIOLATION_T, this.getConnection());
            }
            finally {
                this.rollback();
            }
        }
        for (String ct : fkForms) {
            try {
                s.executeUpdate(ct + " deferrable initially deferred)");
                s.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(initialContents));
                this.declareCalledNestedSetImmediate(s);
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, s, "call calledNestedSetImmediate()");
            }
            finally {
                this.rollback();
            }
        }
    }

    public void testDeferredRowsInvalidation() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        s.executeUpdate("insert into t values 1,2,2,3");
        s.executeUpdate("alter table t drop constraint c");
        this.commit();
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        s.executeUpdate("insert into t values 1,2,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        s.executeUpdate("insert into t values 1,2,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("truncate table t");
        s.executeUpdate("set constraints c immediate");
        s.executeUpdate("set constraints c deferred");
        s.executeUpdate("insert into t values 1,2,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        s.executeUpdate("insert into t values 1,2,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("delete from t where i=1");
        s.executeUpdate("call syscs_util.syscs_compress_table('APP', 'T', 0)");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_S, s, "set constraints c immediate");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_DUP_VIOLATION_T, this.getConnection());
        s.executeUpdate("create table t(i int,   constraint c primary key (i) initially deferred)");
        this.commit();
        s.executeUpdate("insert into t values 1,2,3");
        s.executeUpdate("delete from t where i=1");
        ConstraintCharacteristicsTest.assertStatementError(LOCK_TIMEOUT, s, "call syscs_util.syscs_inplace_compress_table('APP', 'T', 1, 1, 1)");
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        s.executeUpdate("insert into t values -1,-2, -2, -3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("alter table t drop constraint c");
        this.commit();
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        s.executeUpdate("insert into t values -1, -2, -2, -3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        s.executeUpdate("insert into t values -1, -2, -2, -3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("truncate table t");
        this.commit();
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        s.executeUpdate("insert into t values -1, -2, -2, -3");
        s.executeUpdate("delete from t where i=-2");
        s.executeUpdate("call syscs_util.syscs_compress_table('APP', 'T', 0)");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
        s.executeUpdate("create table t(i int,   constraint c check (i > 0) initially deferred)");
        this.commit();
        s.executeUpdate("insert into t values -1, -2, -2, -3");
        s.executeUpdate("delete from t where i=-2");
        s.executeUpdate("call syscs_util.syscs_inplace_compress_table('APP', 'T', 1, 1, 1)");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) initially deferred)");
        s.executeUpdate("insert into t values 1,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("alter table t drop constraint c");
        this.commit();
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) initially deferred)");
        s.executeUpdate("insert into t values 1,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("truncate table t");
        this.commit();
        s.executeUpdate("insert into t values 1,2,3");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("drop table t");
        this.commit();
        s.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) initially deferred)");
        s.executeUpdate("insert into referenced(i) values 4,5,6");
        s.executeUpdate("insert into t values 4,5,6,7");
        s.executeUpdate("delete from t where i=5");
        s.executeUpdate("call syscs_util.syscs_compress_table('APP', 'T', 0)");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_FK_VIOLATION_T, this.getConnection());
        s.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) initially deferred)");
        s.executeUpdate("insert into referenced(i) values 4,5,6");
        s.executeUpdate("insert into t values 4,5,6,7");
        s.executeUpdate("delete from t where i=5");
        ConstraintCharacteristicsTest.assertStatementError(LOCK_TIMEOUT, s, "call syscs_util.syscs_inplace_compress_table('APP', 'T', 1,1,1)");
        s.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) ON DELETE NO ACTION initially deferred)");
        s.executeUpdate("insert into referenced(i) values 4,5,6");
        s.executeUpdate("insert into t values 4,5,6");
        s.executeUpdate("delete from referenced where i=5");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, s, "set constraints c immediate");
        s.executeUpdate("call syscs_util.syscs_compress_table('APP', 'T', 0)");
        ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_FK_VIOLATION_T, this.getConnection());
        s.executeUpdate("create table t(i int, constraint c foreign key(i) references referenced(i) ON DELETE NO ACTION initially deferred)");
        s.executeUpdate("insert into referenced(i) values 4,5,6");
        s.executeUpdate("insert into t values 4,5,6");
        s.executeUpdate("delete from referenced where i=5");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_FK_VIOLATION_S, s, "set constraints c immediate");
        ConstraintCharacteristicsTest.assertStatementError(LOCK_TIMEOUT, s, "call syscs_util.syscs_inplace_compress_table('APP', 'T', 1, 1, 1)");
    }

    public void testImport() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t(i int)");
        try {
            for (int addOrReplace = 0; addOrReplace < 2; ++addOrReplace) {
                s.executeUpdate("alter table t alter column i not null");
                s.executeUpdate("alter table t add constraint c primary key(i)     deferrable initially immediate");
                this.commit();
                s.executeUpdate("set constraints c deferred");
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, s, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + addOrReplace + ")");
                s.executeUpdate("alter table t alter column i not null");
                s.executeUpdate("alter table t drop constraint c");
                s.executeUpdate("alter table t add constraint c unique(i)     deferrable initially immediate");
                this.commit();
                s.executeUpdate("set constraints c deferred");
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, s, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + addOrReplace + ")");
                s.executeUpdate("alter table t alter column i null");
                s.executeUpdate("alter table t drop constraint c");
                s.executeUpdate("alter table t add constraint c unique(i) initially deferred");
                this.commit();
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_DUP_VIOLATION_T, s, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + addOrReplace + ")");
                s.executeUpdate("call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataWithNullsFile + "',    null, null , null, " + addOrReplace + ")");
                s.executeUpdate("alter table t drop constraint c");
                s.executeUpdate("truncate table t");
                this.commit();
                s.executeUpdate("alter table t add constraint c check (i > 0) initially deferred");
                ConstraintCharacteristicsTest.assertStatementError(LANG_DEFERRED_CHECK_VIOLATION_T, s, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + addOrReplace + ")");
                s.executeUpdate("truncate table t");
                this.commit();
            }
        }
        finally {
            this.dropTable("t");
            this.commit();
        }
    }

    public void testDropNotNullOnUniqueColumn() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table constraintest (val1 varchar (20) not null, val2 varchar (20))");
        s.executeUpdate("alter table constraintest add constraint u_con unique (val1) deferrable initially immediate");
        s.executeUpdate("alter table constraintest alter column val1 null");
        s.executeUpdate("insert into constraintest(val1) values 'name1'");
        ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, s, "insert into constraintest(val1) values 'name1'");
        PreparedStatement ps = this.prepareStatement("insert into constraintest(val1) values (?)");
        ps.setString(1, null);
        ps.executeUpdate();
        ps.setString(1, null);
        ps.executeUpdate();
    }

    public void testDerby6374() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t(i int)");
        try {
            for (int addOrReplace = 0; addOrReplace < 2; ++addOrReplace) {
                s.executeUpdate("alter table t add constraint c unique(i)");
                this.commit();
                ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, s, "call SYSCS_UTIL.SYSCS_IMPORT_TABLE (    'APP' , 'T' , '" + expImpDataFile + "',    null, null , null, " + addOrReplace + ")");
                s.executeUpdate("alter table t drop constraint c");
            }
        }
        finally {
            this.dropTable("t");
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testXA() throws SQLException, XAException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "wombat");
        boolean UNIQUE_PK = false;
        boolean CHECK = true;
        String[] expectedError = new String[]{LANG_DEFERRED_DUP_VIOLATION_T, LANG_DEFERRED_CHECK_VIOLATION_T};
        for (int i = 0; i <= 1; ++i) {
            XAConnection xaconn = xads.getXAConnection();
            try {
                Throwable t;
                XAResource xar = xaconn.getXAResource();
                Connection conn = xaconn.getConnection();
                conn.setAutoCommit(false);
                Statement s = conn.createStatement();
                Xid xid = i == 0 ? this.doXAWorkUniquePK(s, xar) : this.doXAWorkCheck(s, xar);
                xar.rollback(xid);
                this.assertXidRolledBack(xar, xid);
                xid = i == 0 ? this.doXAWorkUniquePK(s, xar) : this.doXAWorkCheck(s, xar);
                try {
                    xar.prepare(xid);
                    ConstraintCharacteristicsTest.fail((String)"Expected XA prepare to fail due to constraint violation");
                }
                catch (XAException xe) {
                    ConstraintCharacteristicsTest.assertEquals((int)103, (int)xe.errorCode);
                    if (!ConstraintCharacteristicsTest.usingDerbyNetClient()) {
                        t = xe.getCause();
                        ConstraintCharacteristicsTest.assertTrue((t != null && t instanceof SQLException ? 1 : 0) != 0);
                        ConstraintCharacteristicsTest.assertSQLState(expectedError[i], (SQLException)t);
                    }
                    this.assertXidRolledBack(xar, xid);
                }
                xid = i == 0 ? this.doXAWorkUniquePK(s, xar) : this.doXAWorkCheck(s, xar);
                try {
                    xar.commit(xid, true);
                    ConstraintCharacteristicsTest.fail((String)"Expected XA commit to fail due to constraint violation");
                }
                catch (XAException xe) {
                    if (xe.errorCode == -3) {
                        System.err.println("huff");
                    } else {
                        ConstraintCharacteristicsTest.assertEquals((int)103, (int)xe.errorCode);
                        if (!ConstraintCharacteristicsTest.usingDerbyNetClient()) {
                            t = xe.getCause();
                            ConstraintCharacteristicsTest.assertTrue((t != null && t instanceof SQLException ? 1 : 0) != 0);
                            ConstraintCharacteristicsTest.assertSQLState(expectedError[i], (SQLException)t);
                        }
                    }
                    this.assertXidRolledBack(xar, xid);
                }
                continue;
            }
            finally {
                if (ConstraintCharacteristicsTest.usingDerbyNetClient()) {
                    xaconn.getConnection().rollback();
                }
                xaconn.close();
            }
        }
    }

    public void testCompressTableOKUnique() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("create table table1(name1 int unique deferrable initially immediate, name2 int unique not null, name3 int primary key)");
        try {
            stmt.execute("call syscs_util.syscs_compress_table('APP','TABLE1',1)");
            stmt.executeUpdate("insert into table1 values(1,11,111)");
            ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, stmt, "insert into table1 values(1,22,222)");
            ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, stmt, "insert into table1 values(3,11,333)");
            ConstraintCharacteristicsTest.assertStatementError(LANG_DUPLICATE_KEY_CONSTRAINT, stmt, "insert into table1 values(4,44,111)");
            try {
                stmt.execute("insert into table1 values(1,22,222)");
                ConstraintCharacteristicsTest.fail();
            }
            catch (DerbySQLIntegrityConstraintViolationException dsicve) {
                ConstraintCharacteristicsTest.assertSQLState(LANG_DUPLICATE_KEY_CONSTRAINT, (SQLException)((Object)dsicve));
                ConstraintCharacteristicsTest.assertEquals((String)"TABLE1", (String)dsicve.getTableName());
                ConstraintCharacteristicsTest.assertTrue((boolean)dsicve.getConstraintName().startsWith("SQL"));
            }
        }
        finally {
            stmt.executeUpdate("drop table table1");
        }
    }

    public void testManySimilarDuplicates() throws SQLException {
        if (ConstraintCharacteristicsTest.usingDerbyNetClient()) {
            return;
        }
        Connection c = this.getConnection();
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        try {
            s.executeUpdate("create table t (i varchar(256),     constraint c primary key(i) initially deferred)");
            PreparedStatement ps = c.prepareStatement("insert into t values ?");
            char[] value = new char[256];
            Arrays.fill(value, 'a');
            ps.setString(1, String.valueOf(value));
            for (long l = 0L; l < 4096L; ++l) {
                ps.executeUpdate();
            }
            c.commit();
            ConstraintCharacteristicsTest.fail();
        }
        catch (SQLException e) {
            ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_DUP_VIOLATION_T, e);
            s.executeUpdate("call syscs_util.syscs_checkpoint_database()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAlmostRemovedAllDups() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t(i int, j int,     constraint c primary key (i) initially deferred)");
        try {
            int i;
            PreparedStatement ps = this.prepareStatement("insert into t values (?,?)");
            for (i = 0; i < 10; ++i) {
                ps.setInt(1, 1);
                ps.setInt(2, i);
                ps.executeUpdate();
            }
            s.executeUpdate("delete from t where j > 0");
            this.commit();
            s.executeUpdate("truncate table t");
            for (i = 0; i < 10; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.executeUpdate();
                ps.setInt(1, i);
                ps.setInt(2, i);
                ps.executeUpdate();
            }
            s.execute("delete from t where i < 9");
            JDBC.assertFullResultSet(s.executeQuery("select * from t"), new String[][]{{"9", "9"}, {"9", "9"}});
            this.commit();
        }
        catch (SQLException e) {
            ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_DUP_VIOLATION_T, e);
        }
        finally {
            this.dropTable("t");
            this.commit();
        }
    }

    private static void setupTab1(Connection c) throws SQLException {
        Statement stmt = c.createStatement();
        stmt.execute("create table tab1 (i integer)");
        stmt.executeUpdate("alter table tab1 add constraint con1 unique (i) deferrable");
        PreparedStatement ps = c.prepareStatement("insert into tab1 values (?)");
        for (int i = 0; i < 10; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
        }
        ps.close();
        stmt.close();
        c.commit();
    }

    private static void dropTab1(Connection c) throws SQLException {
        Statement stmt = c.createStatement();
        try {
            stmt.execute("drop table tab1");
            c.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void testLockingForUniquePKWithCommit() throws Exception {
        ConstraintCharacteristicsTest.setupTab1(this.getConnection());
        try {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    ConstraintCharacteristicsTest.executeThreads(this, (int)Math.pow(2.0, i), (int)Math.pow(2.0, j), true);
                }
            }
        }
        finally {
            ConstraintCharacteristicsTest.dropTab1(this.getConnection());
        }
    }

    public void testLockingForUniquePKWithRollback() throws Exception {
        ConstraintCharacteristicsTest.setupTab1(this.getConnection());
        try {
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    ConstraintCharacteristicsTest.executeThreads(this, (int)Math.pow(2.0, i), (int)Math.pow(2.0, j), false);
                }
            }
        }
        finally {
            ConstraintCharacteristicsTest.dropTab1(this.getConnection());
        }
    }

    public void testCheckConstraintsWithDeferredRows() throws SQLException {
        Statement s = this.createStatement();
        try {
            s.executeUpdate("create table tab1 (c1 int, constraint c check (c1 > 0) deferrable initially deferred)");
            this.commit();
            s.executeUpdate("insert into tab1 values (4)");
            s.executeUpdate("insert into tab1 values (3)");
            s.executeUpdate("insert into tab1 select c1-3 from tab1");
            ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
            s.executeUpdate("insert into tab1 values (2)");
            s.executeUpdate("update tab1 as grr set c1=-1 where c1 = 2 and ((select max(c1) from tab1 where grr.c1 > 0) > 0)");
            ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
            s.executeUpdate("insert into tab1 values (2)");
            s.executeUpdate("create table trigtab(i int)");
            s.executeUpdate("create trigger mytrigger after update on tab1 insert into trigtab values 1");
            s.executeUpdate("update tab1 as grr set c1=-1 where c1 = 2 and ((select max(c1) from tab1 where grr.c1 > 0) > 0)");
            ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
        }
        finally {
            this.dropTable("tab1");
            this.dropTable("trigtab");
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSeveralCheckConstraints() throws SQLException {
        Statement s = this.createStatement();
        try {
            int i;
            s.executeUpdate("create table t(i int, constraint ci check (i > 0) deferrable initially deferred, j int, constraint cj check (j > 0) deferrable initially deferred, k int, constraint ck check (k > 0) deferrable initially deferred)");
            this.commit();
            String[] setStrings = new String[]{"j = -j, k = -k", "i = -i, k = -k", "i = -i, j = -j"};
            String[] makeImmediate = new String[]{"ci", "cj", "ck"};
            for (i = 0; i < 3; ++i) {
                s.executeUpdate("insert into t values (-1, -2, -3)");
                s.executeUpdate("update t set " + setStrings[i]);
                try {
                    s.executeUpdate("set constraints " + makeImmediate[i] + " immediate");
                    ConstraintCharacteristicsTest.fail((String)("expected violation: " + i));
                }
                catch (SQLException e) {
                    ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_S, e);
                    ConstraintCharacteristicsTest.assertTrue((boolean)e.getMessage().contains(makeImmediate[i].toUpperCase()));
                }
                this.rollback();
            }
            s.executeUpdate("insert into t values (-1,  2,  3)");
            s.executeUpdate("insert into t values ( 1, -2,  3)");
            s.executeUpdate("insert into t values ( 1,  2, -3)");
            for (i = 0; i < 3; ++i) {
                try {
                    s.executeUpdate("set constraints " + makeImmediate[i] + " immediate");
                    ConstraintCharacteristicsTest.fail((String)("expected violation: " + i));
                    continue;
                }
                catch (SQLException e) {
                    ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_S, e);
                    ConstraintCharacteristicsTest.assertTrue((boolean)e.getMessage().contains(makeImmediate[i].toUpperCase()));
                }
            }
            this.rollback();
            s.executeUpdate("insert into t values (-1,  2,  3)");
            s.executeUpdate("update t set i=-1");
            s.executeUpdate("update t set i=-1");
            ConstraintCharacteristicsTest.assertCommitError(LANG_DEFERRED_CHECK_VIOLATION_T, this.getConnection());
        }
        finally {
            this.dropTable("t");
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void executeThreads(ConstraintCharacteristicsTest thisTest, int isolation1, int isolation2, boolean commit) throws Exception {
        Connection con1 = thisTest.openDefaultConnection();
        con1.setTransactionIsolation(isolation1);
        Connection con2 = thisTest.openDefaultConnection();
        try {
            con2.setTransactionIsolation(isolation2);
            DBOperations dbo1 = new DBOperations(con1, 5);
            DBOperations dbo2 = new DBOperations(con2, 5);
            dbo1.delete();
            Thread t = new Thread(dbo2);
            t.start();
            Thread.sleep(500L);
            if (commit) {
                dbo1.rollback();
                t.join();
                ConstraintCharacteristicsTest.assertSQLState("isolation levels: " + isolation1 + " " + isolation2, LANG_DUPLICATE_KEY_CONSTRAINT, dbo2.getException());
            } else {
                dbo1.commit();
                t.join();
                ConstraintCharacteristicsTest.assertNull((String)("isolation levels: " + isolation1 + " " + isolation2 + ": exception " + String.valueOf(dbo2.getException())), (Object)dbo2.getException());
            }
            ConstraintCharacteristicsTest.assertNull((String)("unexpected failure: " + isolation1 + " " + isolation2 + ": exception " + String.valueOf(dbo2.getUnexpectedException())), (Object)dbo2.getUnexpectedException());
        }
        finally {
            con1.commit();
            con2.commit();
            con1.close();
            con2.close();
        }
    }

    private Xid doXAWorkUniquePK(Statement s, XAResource xar) throws SQLException, XAException {
        Xid xid = XATestUtil.getXid(1, 5, 32);
        xar.start(xid, 0);
        s.executeUpdate("create table derby532xa(i int,     constraint derby532xa_c primary key(i) initially deferred)");
        s.executeUpdate("insert into derby532xa values 1,1,2");
        xar.end(xid, 0x4000000);
        return xid;
    }

    private Xid doXAWorkCheck(Statement s, XAResource xar) throws SQLException, XAException {
        Xid xid = XATestUtil.getXid(1, 5, 32);
        xar.start(xid, 0);
        s.executeUpdate("create table derby532xa(i int,     constraint derby532xa_c check(i > 0) initially deferred)");
        s.executeUpdate("insert into derby532xa values -1, 1,-2");
        xar.end(xid, 0x4000000);
        return xid;
    }

    private void assertXidRolledBack(XAResource xar, Xid xid) {
        try {
            xar.rollback(xid);
            ConstraintCharacteristicsTest.fail((String)"expected the transaction to be unknown");
        }
        catch (XAException xe) {
            ConstraintCharacteristicsTest.assertEquals((int)xe.errorCode, (int)-4);
        }
    }

    private static String rs2Values(String[][] rs) {
        StringBuilder sb = new StringBuilder();
        for (String[] row : rs) {
            sb.append('(');
            for (String v : row) {
                sb.append(v);
                sb.append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("),");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private static void checkConsistencyOfBaseTableAndIndex(Statement s) throws SQLException {
        JDBC.assertFullResultSet(s.executeQuery("values SYSCS_UTIL.SYSCS_CHECK_TABLE('APP', 'T')"), new String[][]{{"1"}});
    }

    private static void assertTableLevelNonDefaultAccepted(Statement s) throws SQLException {
        for (String ct : tableConstraintTypes) {
            for (String[] ch : nonDefaultCharacteristics) {
                if (ch[0].contains("not enforced")) {
                    ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, s, "create table t(i int, constraint c " + ct + ch[0] + ")");
                    continue;
                }
                s.executeUpdate("create table t(i int, constraint c " + ct + ch[0] + ")");
                s.executeUpdate("drop table t");
            }
        }
    }

    private static void assertColumnLevelNonDefaultAccepted(Statement s) throws SQLException {
        for (String ct : columnConstraintTypes) {
            for (String[] ch : nonDefaultCharacteristics) {
                if (ch[0].contains("not enforced")) {
                    ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, s, "create table t(i int " + ct + ch[0] + ")");
                    continue;
                }
                s.executeUpdate("create table t(i int " + ct + ch[0] + ")");
                s.executeUpdate("drop table t");
            }
        }
    }

    private static void assertTableLevelDefaultBehaviorAccepted(Connection c, Statement s) throws SQLException {
        for (String ct : tableConstraintTypes) {
            for (String[] ch : defaultCharacteristics) {
                ConstraintCharacteristicsTest.assertUpdateCount(s, 0, "create table t(i int, constraint c " + ct + ch[0] + ")");
                c.rollback();
            }
        }
    }

    private static void assertColumnLevelDefaultBehaviorAccepted(Connection c, Statement s) throws SQLException {
        for (String ct : columnConstraintTypes) {
            for (String[] ch : defaultCharacteristics) {
                ConstraintCharacteristicsTest.assertUpdateCount(s, 0, "create table t(i int " + ct + ch[0] + ")");
                c.rollback();
            }
        }
    }

    private void assertDictState(Statement s, String characteristics, String code) throws SQLException {
        for (String ct : tableConstraintTypes) {
            try {
                s.executeUpdate("create table t(i int, constraint c " + ct + " " + characteristics + ")");
                if (characteristics.contains("not enforced")) {
                    ConstraintCharacteristicsTest.fail();
                    continue;
                }
                JDBC.assertFullResultSet(s.executeQuery("select state from sys.sysconstraints     where constraintname = 'C'"), new String[][]{{code}});
                this.rollback();
            }
            catch (SQLException e) {
                if (characteristics.contains("not enforced")) {
                    ConstraintCharacteristicsTest.assertSQLState(NOT_IMPLEMENTED, e);
                    continue;
                }
                throw e;
            }
        }
    }

    private void assertAlterDictState(Statement s, String enforcement) throws SQLException {
        String oldState = this.getOldState(s);
        String newState = this.computeNewState(oldState, enforcement);
        if (!enforcement.contains("not enforced")) {
            s.executeUpdate("alter table t alter constraint c " + enforcement);
            JDBC.assertFullResultSet(s.executeQuery("select state from sys.sysconstraints     where constraintname = 'C'"), new String[][]{{newState}});
        } else {
            ConstraintCharacteristicsTest.assertStatementError(NOT_IMPLEMENTED, s, "alter table t alter constraint c " + enforcement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getOldState(Statement s) throws SQLException {
        try (ResultSet rs = s.executeQuery("select state from sys.sysconstraints     where constraintname = 'C'");){
            rs.next();
            String string = rs.getString(1);
            return string;
        }
    }

    private String computeNewState(String oldState, String enforcement) {
        return inverseState.get(oldState)[enforcement.equals("enforced") ? 0 : 1];
    }

    private void assertCreateInconsistentCharacteristics(Statement s, String characteristics) throws SQLException {
        for (String ct : tableConstraintTypes) {
            try {
                s.executeUpdate("create table t(i int, constraint c " + ct + " " + characteristics + ")");
                ConstraintCharacteristicsTest.fail((String)"wrong characteristics unexpectedly passed muster");
                this.rollback();
            }
            catch (SQLException e) {
                ConstraintCharacteristicsTest.assertSQLState(LANG_INCONSISTENT_C_CHARACTERISTICS, e);
            }
        }
    }

    private void assertAlterInconsistentCharacteristics(Statement s, String characteristics) throws SQLException {
        try {
            s.executeUpdate("alter table t alter constraint c " + characteristics);
            ConstraintCharacteristicsTest.fail((String)"wrong characteristics unexpectedly passed muster");
            this.rollback();
        }
        catch (SQLException e) {
            ConstraintCharacteristicsTest.assertSQLState(LANG_SYNTAX_ERROR, e);
        }
    }

    private void declareCalledNested(Statement s) throws SQLException {
        s.executeUpdate("create procedure calledNested(isCheckConstraint boolean)  language java parameter style java  external name '" + ((Object)((Object)this)).getClass().getName() + ".calledNested' modifies sql data");
    }

    private void declareCalledNestedFk(Statement s) throws SQLException {
        s.executeUpdate("create procedure calledNestedFk()  language java parameter style java  external name '" + ((Object)((Object)this)).getClass().getName() + ".calledNestedFk' modifies sql data");
    }

    private void declareCalledNestedSetImmediate(Statement s) throws SQLException {
        s.executeUpdate("create procedure calledNestedSetImmediate()  language java parameter style java  external name '" + ((Object)((Object)this)).getClass().getName() + ".calledNestedSetImmediate' modifies sql data");
    }

    public static void calledNested(boolean isCheckConstraint) throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement cStmt = c.createStatement();
        cStmt.executeUpdate("set constraints c deferred");
        cStmt.executeUpdate("insert into t values " + ConstraintCharacteristicsTest.rs2Values(isCheckConstraint ? negatedInitialContents : initialContents));
        c.close();
    }

    public static void calledNestedFk() throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement cStmt = c.createStatement();
        cStmt.executeUpdate("set constraints c deferred");
        cStmt.executeUpdate("insert into t select i*2, j*2 from t");
        c.close();
    }

    public static void calledNestedSetImmediate() throws SQLException {
        Connection c = DriverManager.getConnection("jdbc:default:connection");
        Statement cStmt = c.createStatement();
        try {
            cStmt.executeUpdate("set constraints c immediate");
        }
        finally {
            c.close();
        }
    }

    private void dontThrow(Statement st, String stm) {
        try {
            st.executeUpdate(stm);
        }
        catch (SQLException e) {
            ConstraintCharacteristicsTest.println("\"" + stm + "\"failed: " + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby6670_a() throws SQLException {
        String[] types;
        Connection c = this.getConnection();
        Statement s = this.createStatement();
        for (String type : types = new String[]{"pk", "fk", "check"}) {
            String expectedErr = null;
            try {
                if (type.equals("pk")) {
                    s.execute("create table derby6670_1(x int primary key     initially deferred)");
                    s.execute("insert into derby6670_1 values 1,1,1,1");
                    expectedErr = LANG_DEFERRED_DUP_VIOLATION_T;
                } else if (type.equals("fk")) {
                    s.execute("create table derby6670_11(x int primary key)");
                    s.execute("create table derby6670_1(x int   references derby6670_11 initially deferred)");
                    s.execute("insert into derby6670_1 values 1");
                    expectedErr = LANG_DEFERRED_FK_VIOLATION_T;
                } else if (type.equals("check")) {
                    s.execute("create table derby6670_1(x int check (x < 0)     initially deferred)");
                    s.execute("insert into derby6670_1 values 1");
                    expectedErr = LANG_DEFERRED_CHECK_VIOLATION_T;
                }
                Savepoint sp = c.setSavepoint();
                s.execute("drop table derby6670_1");
                c.rollback(sp);
                try {
                    this.commit();
                    ConstraintCharacteristicsTest.fail();
                }
                catch (SQLException e) {
                    ConstraintCharacteristicsTest.assertSQLState(expectedErr, e);
                }
                sp = c.setSavepoint();
                if (type.equals("pk")) {
                    s.execute("create table derby6670_2(x int primary key     initially deferred)");
                    s.execute("insert into derby6670_2 values 1,1,1,1");
                } else if (type.equals("fk")) {
                    s.execute("create table derby6670_22(x int primary key)");
                    s.execute("create table derby6670_2(x int   references derby6670_22 initially deferred)");
                    s.execute("insert into derby6670_2 values 1");
                } else if (type.equals("check")) {
                    s.execute("create table derby6670_2(x int)");
                    s.execute("alter table derby6670_2 add constraint c   check(x > 0) deferrable initially deferred");
                    s.execute("insert into derby6670_2 values -1");
                }
                c.rollback(sp);
                this.commit();
                s.execute("create table derby6670_3(x int not null)");
                this.commit();
                sp = c.setSavepoint();
                if (type.equals("pk")) {
                    s.execute("alter table derby6670_3 add constraint c   primary key(x) deferrable   initially deferred");
                    s.execute("insert into derby6670_3 values 1,1");
                } else if (type.equals("fk")) {
                    s.execute("create table derby6670_33(x int primary key)");
                    s.execute("alter table derby6670_3 add constraint c    foreign key(x) references derby6670_33    deferrable initially deferred");
                    s.execute("insert into derby6670_3 values -1");
                } else if (type.equals("check")) {
                    s.execute("alter table derby6670_3 add constraint c    check(x > 0) deferrable initially deferred");
                    s.execute("insert into derby6670_3 values -1");
                }
                c.rollback(sp);
                this.commit();
                s.execute("create table derby6670_4(x int not null)");
                c.commit();
                if (type.equals("pk")) {
                    s.execute("alter table derby6670_4 add constraint c   primary key(x) deferrable   initially deferred");
                    s.execute("insert into derby6670_4 values 1,1");
                } else if (type.equals("fk")) {
                    s.execute("create table derby6670_44(x int primary key)");
                    s.execute("alter table derby6670_4 add constraint c    foreign key(x) references derby6670_44    deferrable initially deferred");
                    s.execute("insert into derby6670_4 values -1");
                } else if (type.equals("check")) {
                    s.execute("alter table derby6670_4 add constraint c    check(x > 0) deferrable initially deferred");
                    s.execute("insert into derby6670_4 values -1");
                }
                sp = c.setSavepoint();
                s.execute("alter table derby6670_4 drop constraint c");
                c.rollback(sp);
                try {
                    c.commit();
                    ConstraintCharacteristicsTest.fail();
                }
                catch (SQLException e) {
                    ConstraintCharacteristicsTest.assertSQLState(expectedErr, e);
                }
            }
            finally {
                for (int i = 1; i <= 4; ++i) {
                    this.dropTable("derby6670_" + i);
                }
                c.commit();
            }
        }
    }

    public void testDerby6670_b() throws SQLException {
        String[] forms;
        Connection c = this.getConnection();
        Statement s = this.createStatement();
        for (String form : forms = new String[]{"c", "all"}) {
            s.execute("create table t1(x int primary key,     constraint c check(x > 0) initially deferred)");
            s.execute("insert into t1 values -1");
            Savepoint sp = c.setSavepoint();
            s.execute("delete from t1");
            s.execute("set constraints " + form + " immediate");
            c.rollback(sp);
            try {
                c.commit();
                ConstraintCharacteristicsTest.fail();
            }
            catch (SQLException e) {
                ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_T, e);
            }
        }
    }

    public void testDerby6666() throws SQLException {
        Statement s = this.createStatement();
        s.executeUpdate("create table t1(x int primary key)");
        s.executeUpdate("create table t2(y int, constraint c check(y > 0)    initially deferred, constraint fk    foreign key(y) references t1 initially deferred)");
        this.setAutoCommit(false);
        s.executeUpdate("insert into t1 values -1, 1");
        s.executeUpdate("insert into t2 values 1");
        s.executeUpdate("update t2 set y = -1");
        try {
            this.commit();
            ConstraintCharacteristicsTest.fail();
        }
        catch (SQLException e) {
            ConstraintCharacteristicsTest.assertSQLState(LANG_DEFERRED_CHECK_VIOLATION_T, e);
        }
    }

    public void testDerby6773() throws Exception {
        Statement s = this.createStatement();
        s.executeUpdate("create table Application    (id bigint generated by default as identity,    name varchar(255),    shortName varchar(32),    userId varchar(32),    primary key (id))");
        s.executeUpdate("create unique index UK_APPLICATION_SHORTNAME     on Application (shortName)");
        s.executeUpdate("create unique index UK_APPLICATION_NAME     on Application (name)");
        s.executeUpdate("insert into Application (name, shortName, userId)     VALUES ('fooApp', 'Foo Application 0', 'me')");
        try {
            s.executeUpdate("insert into Application (name, shortName, userId)     VALUES ('fooApp', 'Foo Application 1', 'me')");
            ConstraintCharacteristicsTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException dsicve) {
            ConstraintCharacteristicsTest.assertEquals((String)"APPLICATION", (String)dsicve.getTableName());
            ConstraintCharacteristicsTest.assertEquals((String)"UK_APPLICATION_NAME", (String)dsicve.getConstraintName());
        }
        try {
            s.executeUpdate("insert into Application (name, shortName, userId)     VALUES ('BarApp', 'Foo Application 0', 'me')");
            ConstraintCharacteristicsTest.fail();
        }
        catch (DerbySQLIntegrityConstraintViolationException dsicve) {
            ConstraintCharacteristicsTest.assertEquals((String)"APPLICATION", (String)dsicve.getTableName());
            ConstraintCharacteristicsTest.assertEquals((String)"UK_APPLICATION_SHORTNAME", (String)dsicve.getConstraintName());
        }
    }

    public static LanguageConnectionContext getLCC(Connection conn) {
        ContextManager contextManager = ((EmbedConnection)conn).getContextManager();
        return (LanguageConnectionContext)contextManager.getContext("LanguageConnectionContext");
    }

    static {
        exportFilesCreatedEmbedded = false;
        exportFilesCreatedClient = false;
        uniqueForms = new String[]{"create table t(i int, j int, constraint c primary key(i)", "create table t(i int, j int, constraint c unique(i)", "create table t(i int not null, j int, constraint c unique(i)"};
        uniqueSpec = new String[]{"primary key(i)", "unique(i)", "unique(i)"};
        checkForms = new String[]{"create table t(i int, j int, constraint c check (i > 0)"};
        fkForms = new String[]{"create table t(i int, j int,     constraint c foreign key(i) references referenced(i)"};
        checkSpec = new String[]{"check (i > 0)"};
        initialContents = new String[][]{{"1", "10"}, {"2", "20"}, {"3", "30"}};
        negatedInitialContents = new String[][]{{"-1", "10"}, {"-2", "20"}, {"-3", "30"}};
        setConstraintsForms = new String[]{"set constraints all", "set constraints c"};
        tableConstraintTypes = new String[]{" foreign key (i) references referenced(i)", " primary key(i)", " unique(i)", " check(i<3)"};
        columnConstraintTypes = new String[]{" references referenced(i)", " primary key", " unique", " check(i<3)"};
        defaultCharacteristics = new String[][]{{" not deferrable initially immediate enforced", "E"}, {" not deferrable initially immediate", "E"}, {" not deferrable enforced", "E"}, {" not deferrable", "E"}, {" initially immediate enforced", "E"}, {" initially immediate", "E"}, {" enforced", "E"}, {"", "E"}};
        nonDefaultCharacteristics = new String[][]{{" deferrable", "i"}, {" deferrable initially immediate", "i"}, {" deferrable enforced", "i"}, {" deferrable initially immediate enforced", "i"}, {" deferrable initially deferred", "e"}, {" deferrable initially deferred enforced", "e"}, {" initially deferred enforced", "e"}, {" initially deferred", "e"}, {" deferrable not enforced", "j"}, {" deferrable initially immediate not enforced", "j"}, {" deferrable initially deferred not enforced", "d"}, {" initially deferred not enforced", "d"}, {" not enforced", "D"}, {" initially immediate not enforced", "D"}, {" not deferrable not enforced", "D"}, {" not deferrable initially immediate not enforced", "D"}};
        illegalCharacteristics = new String[]{" not deferrable initially deferred", " not deferrable initially deferred enforced", " not deferrable initially deferred not enforced"};
        ArrayList<String> characteristics = new ArrayList<String>();
        characteristics.addAll(Arrays.asList(defaultCharacteristics[0]));
        characteristics.addAll(Arrays.asList(nonDefaultCharacteristics[0]));
        characteristics.addAll(Arrays.asList(illegalCharacteristics));
        characteristics.remove(" not enforced");
        characteristics.remove(" enforced");
        characteristics.remove("");
        illegalAlterCharacteristics = characteristics.toArray(new String[0]);
        inverseState = new HashMap<String, String[]>();
        inverseState.put("E", new String[]{"E", "D"});
        inverseState.put("D", new String[]{"E", "D"});
        inverseState.put("i", new String[]{"i", "j"});
        inverseState.put("j", new String[]{"i", "j"});
        inverseState.put("i", new String[]{"i", "j"});
        inverseState.put("e", new String[]{"e", "d"});
        inverseState.put("d", new String[]{"e", "d"});
    }
}

