/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class RecoveryAfterBackup {
    public static void main(String[] stringArray) throws Throwable {
        try {
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            connection.setAutoCommit(true);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT COUNT(a), SUM(a) FROM t1");
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                int n2 = resultSet.getInt(2);
                if (n != 2 || n2 != 1) {
                    System.out.print("Unexpected initial database state: ");
                }
                System.out.println("Count: " + n + " Sum: " + n2);
            }
            System.out.println("Inserting records ...");
            statement.execute("INSERT INTO t1 SELECT a+2 FROM t1");
            statement.execute("INSERT INTO t1 SELECT a+4 FROM t1");
            statement.execute("INSERT INTO t1 SELECT a+8 FROM t1");
            statement.execute("INSERT INTO t1 SELECT a+16 FROM t1");
            statement.execute("INSERT INTO t1 SELECT a+32 FROM t1");
            statement.execute("INSERT INTO t1 SELECT a+64 FROM t1");
            statement.execute("INSERT INTO t1 SELECT a+128 FROM t1");
            System.out.println("Shutting down database ...");
            try {
                TestUtil.getConnection("", "shutdown=true");
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("XJ015")) {
                    System.out.println("Database shutdown completed");
                }
                throw sQLException;
            }
            System.out.println("Starting restore with roll-forward recovery..");
            String string = "hairynosedwombat";
            String string2 = "rollForwardRecoveryFrom=extinout/mybackup/hairynosedwombat";
            connection = TestUtil.getConnection(string, string2);
            System.out.println("Verifying database ...");
            statement = connection.createStatement();
            resultSet = statement.executeQuery("SELECT COUNT(a), SUM(a) FROM t1");
            while (resultSet.next()) {
                int n = resultSet.getInt(1);
                int n3 = resultSet.getInt(2);
                if (n != 256 || n3 != 32640) {
                    System.out.print("Test FAILED: ");
                }
                System.out.println("Count: " + n + " Sum: " + n3);
            }
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
            sQLException.printStackTrace(System.out);
        }
    }
}

