/*
 * Decompiled with CFR 0.152.
 */
package org.grails.spring;

import grails.core.GrailsApplication;
import grails.spring.BeanBuilder;
import grails.util.CollectionUtils;
import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.Script;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.spring.RuntimeSpringConfiguration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.ClassUtils;

public class RuntimeSpringConfigUtilities {
    private static final Log LOG = LogFactory.getLog(RuntimeSpringConfigUtilities.class);
    public static final String GRAILS_URL_MAPPINGS = "grailsUrlMappings";
    public static final String SPRING_RESOURCES_XML = "classpath:spring/resources.xml";
    public static final String SPRING_RESOURCES_GROOVY = "classpath:spring/resources.groovy";
    public static final String SPRING_RESOURCES_CLASS = "resources";
    private static final String DEVELOPMENT_SPRING_RESOURCES_XML = "file:./grails-app/conf/spring/resources.xml";
    private static volatile BeanBuilder springGroovyResourcesBeanBuilder = null;

    private RuntimeSpringConfigUtilities() {
    }

    private static void doLoadSpringGroovyResources(RuntimeSpringConfiguration config, GrailsApplication application2, GenericApplicationContext context) {
        RuntimeSpringConfigUtilities.loadExternalSpringConfig(config, application2);
        if (context != null) {
            springGroovyResourcesBeanBuilder.registerBeans(context);
        }
    }

    public static void loadExternalSpringConfig(RuntimeSpringConfiguration config, GrailsApplication application2) {
        if (springGroovyResourcesBeanBuilder == null) {
            try {
                Class<?> groovySpringResourcesClass = null;
                try {
                    groovySpringResourcesClass = ClassUtils.forName(SPRING_RESOURCES_CLASS, application2.getClassLoader());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (groovySpringResourcesClass != null) {
                    RuntimeSpringConfigUtilities.reloadSpringResourcesConfig(config, application2, groovySpringResourcesClass);
                }
            }
            catch (Exception ex) {
                LOG.error("[RuntimeConfiguration] Unable to load beans from resources.groovy", ex);
            }
        } else if (!springGroovyResourcesBeanBuilder.getSpringConfig().equals(config)) {
            springGroovyResourcesBeanBuilder.registerBeans(config);
        }
    }

    public static BeanBuilder reloadSpringResourcesConfig(RuntimeSpringConfiguration config, GrailsApplication application2, Class<?> groovySpringResourcesClass) throws InstantiationException, IllegalAccessException {
        springGroovyResourcesBeanBuilder = new BeanBuilder(null, config, Thread.currentThread().getContextClassLoader());
        springGroovyResourcesBeanBuilder.setBinding(new Binding(CollectionUtils.newMap("application", application2, "grailsApplication", application2)));
        Script script = (Script)groovySpringResourcesClass.newInstance();
        script.run();
        Object beans2 = script.getProperty("beans");
        springGroovyResourcesBeanBuilder.beans((Closure)beans2);
        return springGroovyResourcesBeanBuilder;
    }

    public static void loadSpringGroovyResources(RuntimeSpringConfiguration config, GrailsApplication application2) {
        RuntimeSpringConfigUtilities.loadExternalSpringConfig(config, application2);
    }

    public static void loadSpringGroovyResourcesIntoContext(RuntimeSpringConfiguration config, GrailsApplication application2, GenericApplicationContext context) {
        RuntimeSpringConfigUtilities.loadExternalSpringConfig(config, application2);
        RuntimeSpringConfigUtilities.doLoadSpringGroovyResources(config, application2, context);
    }

    public static void reset() {
        springGroovyResourcesBeanBuilder = null;
    }
}

