/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class ProfilesValidator
implements BindHandler {
    private static final String ALLOWED_CHARS = "-_.+@";
    private final boolean validate;

    private ProfilesValidator(boolean validate) {
        this.validate = validate;
    }

    @Override
    public Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
        this.validate(result);
        return result;
    }

    void validate(Object value, Supplier<String> wrappedExceptionMessage) {
        try {
            this.validate(value);
        }
        catch (IllegalStateException ex) {
            throw new IllegalStateException(wrappedExceptionMessage.get(), ex);
        }
    }

    private void validate(Object value) {
        if (!this.validate) {
            return;
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            list.forEach(this::validate);
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            map.forEach((k, v) -> this.validate(v));
            return;
        }
        String profile2 = value != null ? value.toString() : null;
        Assert.state(StringUtils.hasText(profile2), "Invalid empty profile");
        for (int i2 = 0; i2 < profile2.length(); ++i2) {
            int codePoint = profile2.codePointAt(i2);
            boolean isAllowedChar = ALLOWED_CHARS.indexOf(codePoint) != -1;
            Assert.state(isAllowedChar || Character.isLetterOrDigit(codePoint), () -> "Profile '%s' must contain a letter, digit or allowed char (%s)".formatted(profile2, Arrays.stream(ALLOWED_CHARS.split("")).collect(Collectors.joining("', '", "'", "'"))));
            Assert.state(i2 > 0 && i2 < profile2.length() - 1 || Character.isLetterOrDigit(codePoint), () -> "Profile '%s' must start and end with a letter or digit".formatted(profile2));
        }
    }

    static ProfilesValidator get(Binder binder) {
        return new ProfilesValidator(binder.bind("spring.profiles.validate", Boolean.class).orElse(true));
    }
}

