/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant.statemachine;

import java.util.Map;
import org.apache.helix.HelixException;
import org.apache.helix.NotificationContext;
import org.apache.helix.messaging.handling.HelixTaskExecutor;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.ScheduledTaskStateModelFactory;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledTaskStateModel
extends StateModel {
    static final String DEFAULT_INITIAL_STATE = "OFFLINE";
    Logger logger = LoggerFactory.getLogger(ScheduledTaskStateModel.class);
    protected String _currentState = "OFFLINE";
    final ScheduledTaskStateModelFactory _factory;
    final String _resourceName;
    final String _partitionKey;
    final HelixTaskExecutor _executor;

    public ScheduledTaskStateModel(ScheduledTaskStateModelFactory factory, HelixTaskExecutor executor, String resourceName, String partitionKey) {
        this._factory = factory;
        this._resourceName = resourceName;
        this._partitionKey = partitionKey;
        this._executor = executor;
    }

    @Transition(to="COMPLETED", from="OFFLINE")
    public void onBecomeCompletedFromOffline(Message message, NotificationContext context) throws InterruptedException {
        MessageHandler handler;
        this.logger.info(this._partitionKey + " onBecomeCompletedFromOffline");
        Map<String, String> messageInfo = message.getRecord().getMapField(Message.Attributes.INNER_MESSAGE.toString());
        ZNRecord record = new ZNRecord(this._partitionKey);
        record.getSimpleFields().putAll(messageInfo);
        Message taskMessage = new Message(record);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(taskMessage.getRecord().getSimpleFields().toString());
        }
        if ((handler = this._executor.createMessageHandler(taskMessage, new NotificationContext(null))) == null) {
            throw new HelixException("Task message " + taskMessage.getMsgType() + " handler not found, task id " + this._partitionKey);
        }
        handler.handleMessage();
        this.logger.info(this._partitionKey + " onBecomeCompletedFromOffline completed");
    }

    @Transition(to="OFFLINE", from="COMPLETED")
    public void onBecomeOfflineFromCompleted(Message message, NotificationContext context) {
        this.logger.info(this._partitionKey + " onBecomeOfflineFromCompleted");
    }

    @Transition(to="DROPPED", from="COMPLETED")
    public void onBecomeDroppedFromCompleted(Message message, NotificationContext context) {
        this.logger.info(this._partitionKey + " onBecomeDroppedFromCompleted");
        this.removeFromStatemodelFactory();
    }

    @Transition(to="DROPPED", from="OFFLINE")
    public void onBecomeDroppedFromOffline(Message message, NotificationContext context) throws InterruptedException {
        this.logger.info(this._partitionKey + " onBecomeDroppedFromScheduled");
        this.removeFromStatemodelFactory();
    }

    @Transition(to="OFFLINE", from="ERROR")
    public void onBecomeOfflineFromError(Message message, NotificationContext context) throws InterruptedException {
        this.logger.info(this._partitionKey + " onBecomeOfflineFromError");
    }

    @Override
    public void reset() {
        this.logger.info(this._partitionKey + " ScheduledTask reset");
        this.removeFromStatemodelFactory();
    }

    private void removeFromStatemodelFactory() {
        if (this._factory.getStateModel(this._resourceName, this._partitionKey) != null) {
            this._factory.removeStateModel(this._resourceName, this._partitionKey);
        } else {
            this.logger.warn(this._resourceName + "_ " + this._partitionKey + " not found in ScheduledTaskStateModelFactory");
        }
    }
}

