/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model.builder;

import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.builder.IdealStateBuilder;

public class CustomModeISBuilder
extends IdealStateBuilder {
    public CustomModeISBuilder(String resourceName) {
        super(resourceName);
        this.setRebalancerMode(IdealState.RebalanceMode.CUSTOMIZED);
    }

    public void add(String partitionName) {
        if (this._record.getMapField(partitionName) == null) {
            this._record.setMapField(partitionName, new TreeMap<String, String>());
        }
    }

    public CustomModeISBuilder assignInstanceAndState(String partitionName, String instanceName, String state) {
        this.add(partitionName);
        Map<String, String> partitionToInstanceStateMapping = this._record.getMapField(partitionName);
        partitionToInstanceStateMapping.put(instanceName, state);
        return this;
    }
}

