/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.catalog.sql.AbstractCatalogQuery;
import org.apache.ignite3.internal.catalog.sql.Name;
import org.apache.ignite3.internal.catalog.sql.Option;
import org.apache.ignite3.internal.catalog.sql.QueryContext;
import org.apache.ignite3.internal.catalog.sql.QueryPartCollection;
import org.apache.ignite3.sql.IgniteSql;

class CreateZoneImpl
extends AbstractCatalogQuery<Name> {
    private Name zoneName;
    private boolean ifNotExists;
    private final List<Option> withOptions = new ArrayList<Option>();

    CreateZoneImpl(IgniteSql sql) {
        super(sql);
    }

    @Override
    protected Name result() {
        return this.zoneName;
    }

    CreateZoneImpl name(String name) {
        Objects.requireNonNull(name, "Zone name must not be null.");
        this.zoneName = Name.simple(name);
        return this;
    }

    CreateZoneImpl ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    CreateZoneImpl replicas(Integer n) {
        Objects.requireNonNull(n, "Replicas count must not be null.");
        this.withOptions.add(Option.replicas(n));
        return this;
    }

    CreateZoneImpl quorumSize(Integer n) {
        Objects.requireNonNull(n, "Quorum size must not be null.");
        this.withOptions.add(Option.quorumSize(n));
        return this;
    }

    CreateZoneImpl partitions(Integer n) {
        Objects.requireNonNull(n, "Partitions must not be null.");
        this.withOptions.add(Option.partitions(n));
        return this;
    }

    CreateZoneImpl distributionAlgorithm(String distributionAlgorithm) {
        Objects.requireNonNull(distributionAlgorithm, "Partition distribution algorithm must not be null.");
        this.withOptions.add(Option.distributionAlgorithm(distributionAlgorithm));
        return this;
    }

    CreateZoneImpl dataNodesAutoAdjustScaleUp(Integer adjust) {
        Objects.requireNonNull(adjust, "Timeout between node added topology event itself and data nodes switch must not be null.");
        this.withOptions.add(Option.dataNodesAutoAdjustScaleUp(adjust));
        return this;
    }

    CreateZoneImpl dataNodesAutoAdjustScaleDown(Integer adjust) {
        Objects.requireNonNull(adjust, "Timeout between node left topology event itself and data nodes switch must not be null.");
        this.withOptions.add(Option.dataNodesAutoAdjustScaleDown(adjust));
        return this;
    }

    CreateZoneImpl filter(String filter) {
        Objects.requireNonNull(filter, "Filter must not be null.");
        this.withOptions.add(Option.filter(filter));
        return this;
    }

    CreateZoneImpl storageProfiles(String storageProfiles) {
        Objects.requireNonNull(storageProfiles, "Storage profiles must not be null");
        this.withOptions.add(Option.storageProfiles(storageProfiles));
        return this;
    }

    CreateZoneImpl consistencyMode(String consistencyMode) {
        Objects.requireNonNull(consistencyMode, "Consistency mode must not be null");
        if (!CreateZoneImpl.isValidConsistencyMode(consistencyMode)) {
            throw new IllegalArgumentException("Invalid consistency mode: " + consistencyMode);
        }
        this.withOptions.add(Option.consistencyMode(consistencyMode));
        return this;
    }

    private static boolean isValidConsistencyMode(String consistencyMode) {
        return "HIGH_AVAILABILITY".equals(consistencyMode) || "STRONG_CONSISTENCY".equals(consistencyMode);
    }

    @Override
    protected void accept(QueryContext ctx) {
        ctx.sql("CREATE ZONE ");
        if (this.ifNotExists) {
            ctx.sql("IF NOT EXISTS ");
        }
        ctx.visit(this.zoneName);
        if (!this.withOptions.isEmpty()) {
            ctx.sql(" ").sql("WITH ");
            ctx.visit(QueryPartCollection.partsList(this.withOptions));
        }
        ctx.sql(";");
    }
}

