/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.configuration.validation;

import java.util.Set;
import org.apache.ignite3.configuration.NamedListView;
import org.apache.ignite3.configuration.annotation.NamedConfigValue;
import org.apache.ignite3.configuration.validation.ValidationContext;
import org.apache.ignite3.configuration.validation.ValidationIssue;
import org.apache.ignite3.configuration.validation.Validator;
import org.apache.ignite3.internal.configuration.SystemPropertyView;

public class LongNumberSystemPropertyValueValidator
implements Validator<NamedConfigValue, NamedListView<SystemPropertyView>> {
    private final Set<String> propertyNames;

    public LongNumberSystemPropertyValueValidator(String ... propertyNames) {
        this.propertyNames = Set.of(propertyNames);
    }

    @Override
    public void validate(NamedConfigValue annotation, ValidationContext<NamedListView<SystemPropertyView>> ctx) {
        for (String propertyName : this.propertyNames) {
            SystemPropertyView systemPropertyView = ctx.getNewValue().get(propertyName);
            if (systemPropertyView == null || LongNumberSystemPropertyValueValidator.isLongValue(systemPropertyView.propertyValue())) continue;
            String message = String.format("'%s' system property value must be a long number '%s'", ctx.currentKey(), propertyName);
            ctx.addIssue(new ValidationIssue(ctx.currentKey(), message));
        }
    }

    private static boolean isLongValue(String propertyValue) {
        try {
            Long.parseLong(propertyValue);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

