/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.metrics;

import java.util.Iterator;
import org.apache.ignite3.internal.metrics.CompositeMetric;
import org.apache.ignite3.internal.metrics.Metric;

public class CompositeAwareIterator
implements Iterator<Metric> {
    private final Iterator<Metric> delegate;
    private Iterator<Metric> compositeMetricIterator = null;

    public CompositeAwareIterator(Iterator<Metric> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean hasNext() {
        if (this.compositeMetricIterator == null) {
            return this.delegate.hasNext();
        }
        if (this.compositeMetricIterator.hasNext()) {
            return true;
        }
        this.compositeMetricIterator = null;
        return this.delegate.hasNext();
    }

    @Override
    public Metric next() {
        if (this.compositeMetricIterator == null) {
            return this.nextCompositeAware();
        }
        if (this.compositeMetricIterator.hasNext()) {
            return this.compositeMetricIterator.next();
        }
        this.compositeMetricIterator = null;
        return this.nextCompositeAware();
    }

    private Metric nextCompositeAware() {
        Metric nextValue = this.delegate.next();
        if (nextValue instanceof CompositeMetric) {
            this.compositeMetricIterator = ((CompositeMetric)nextValue).asScalarMetrics().iterator();
            return this.compositeMetricIterator.next();
        }
        return nextValue;
    }
}

