/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.table.distributed;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryTuple;
import org.apache.ignite3.internal.schema.ColumnsExtractor;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.index.HashIndexStorage;
import org.apache.ignite3.internal.storage.index.IndexRowImpl;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.storage.index.SortedIndexStorage;
import org.apache.ignite3.internal.util.Cursor;

public class TableSchemaAwareIndexStorage {
    private final int indexId;
    private final IndexStorage storage;
    private final ColumnsExtractor indexRowResolver;
    private final int columnCount;

    public TableSchemaAwareIndexStorage(int indexId, IndexStorage storage, ColumnsExtractor indexRowResolver) {
        this.indexId = indexId;
        this.storage = storage;
        this.indexRowResolver = indexRowResolver;
        if (storage instanceof HashIndexStorage) {
            this.columnCount = ((HashIndexStorage)storage).indexDescriptor().columns().size();
        } else if (storage instanceof SortedIndexStorage) {
            this.columnCount = ((SortedIndexStorage)storage).indexDescriptor().columns().size();
        } else {
            throw new IllegalArgumentException("Unknown index type: " + storage);
        }
    }

    public int id() {
        return this.indexId;
    }

    public Cursor<RowId> get(BinaryRow binaryRow) throws StorageException {
        BinaryTuple tuple = this.indexRowResolver.extractColumns(binaryRow);
        return this.storage.get(tuple);
    }

    public void put(BinaryRow binaryRow, RowId rowId) {
        BinaryTuple tuple = this.indexRowResolver.extractColumns(binaryRow);
        this.storage.put(new IndexRowImpl(tuple, rowId));
    }

    public void remove(BinaryRow binaryRow, RowId rowId) {
        BinaryTuple tuple = this.indexRowResolver.extractColumns(binaryRow);
        this.storage.remove(new IndexRowImpl(tuple, rowId));
    }

    public ColumnsExtractor indexRowResolver() {
        return this.indexRowResolver;
    }

    public IndexStorage storage() {
        return this.storage;
    }

    public BinaryTuple resolve(ByteBuffer buffer) {
        return new BinaryTuple(this.columnCount, buffer);
    }
}

