/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.tx.impl;

import java.util.Objects;
import java.util.Set;
import org.apache.ignite3.internal.replicator.ReplicationGroupId;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class EnlistedPartitionGroup {
    private final ReplicationGroupId groupId;
    @IgniteToStringInclude
    private final Set<Integer> tableIds;

    public EnlistedPartitionGroup(ReplicationGroupId groupId, Set<Integer> tableIds) {
        this.groupId = groupId;
        this.tableIds = Set.copyOf(tableIds);
    }

    public EnlistedPartitionGroup(TablePartitionId groupId) {
        this(groupId, Set.of(Integer.valueOf(groupId.tableId())));
    }

    public ReplicationGroupId groupId() {
        return this.groupId;
    }

    public Set<Integer> tableIds() {
        return this.tableIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnlistedPartitionGroup that = (EnlistedPartitionGroup)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.tableIds, that.tableIds);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.groupId);
        result = 31 * result + Objects.hashCode(this.tableIds);
        return result;
    }

    public String toString() {
        return S.toString(EnlistedPartitionGroup.class, this);
    }
}

