/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.management.cache.CacheMetricsCommandArg;
import org.apache.ignite.internal.management.cache.CacheMetricsOperation;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class CacheMetricsTask
extends VisorOneNodeTask<CacheMetricsCommandArg, Map<String, Boolean>> {
    private static final long serialVersionUID = 0L;

    protected CacheMetricsJob job(CacheMetricsCommandArg arg) {
        return new CacheMetricsJob(arg, false);
    }

    private static class CacheMetricsJob
    extends VisorJob<CacheMetricsCommandArg, Map<String, Boolean>> {
        private static final long serialVersionUID = 0L;

        protected CacheMetricsJob(@Nullable CacheMetricsCommandArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected Map<String, Boolean> run(@Nullable CacheMetricsCommandArg arg) throws IgniteException {
            if (arg == null) {
                return null;
            }
            Collection<String> cacheNames = F.isEmpty(arg.caches()) ? this.ignite.cacheNames() : Arrays.asList(arg.caches());
            switch (arg.operation()) {
                case ENABLE: 
                case DISABLE: {
                    this.ignite.cluster().enableStatistics(cacheNames, CacheMetricsOperation.ENABLE == arg.operation());
                    return this.cacheMetricsStatus(cacheNames);
                }
                case STATUS: {
                    return this.cacheMetricsStatus(cacheNames);
                }
            }
            throw new IllegalStateException("Unexpected value: " + arg.operation());
        }

        private Map<String, Boolean> cacheMetricsStatus(Collection<String> cacheNames) {
            TreeMap<String, Boolean> cacheMetricsStatus = new TreeMap<String, Boolean>();
            for (String cacheName : cacheNames) {
                IgniteInternalCache cachex = this.ignite.cachex(cacheName);
                if (cachex != null) {
                    cacheMetricsStatus.put(cacheName, cachex.clusterMetrics().isStatisticsEnabled());
                    continue;
                }
                throw new IgniteException("Cache does not exist: " + cacheName);
            }
            return cacheMetricsStatus;
        }
    }
}

