/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response.partition;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.confignode.rpc.thrift.TDataPartitionTableResp;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.rpc.TSStatusCode;

public class DataPartitionResp
implements DataSet {
    private TSStatus status;
    private final boolean allPartitionsExist;
    private final Map<String, DataPartitionTable> dataPartition;

    public DataPartitionResp(TSStatus status, boolean allPartitionsExist, Map<String, DataPartitionTable> dataPartition) {
        this.status = status;
        this.allPartitionsExist = allPartitionsExist;
        this.dataPartition = dataPartition;
    }

    public TSStatus getStatus() {
        return this.status;
    }

    public void setStatus(TSStatus status) {
        this.status = status;
    }

    public boolean isAllPartitionsExist() {
        return this.allPartitionsExist;
    }

    public TDataPartitionTableResp convertToTDataPartitionTableResp() {
        TDataPartitionTableResp resp = new TDataPartitionTableResp();
        resp.setStatus(this.status);
        if (this.status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            ConcurrentHashMap dataPartitionMap = new ConcurrentHashMap();
            this.dataPartition.forEach((storageGroup, dataPartitionTable) -> {
                ConcurrentHashMap seriesPartitionSlotMap = new ConcurrentHashMap();
                dataPartitionTable.getDataPartitionMap().forEach((seriesPartitionSlot, seriesPartitionTable) -> seriesPartitionSlotMap.put(seriesPartitionSlot, seriesPartitionTable.getSeriesPartitionMap()));
                dataPartitionMap.put(storageGroup, seriesPartitionSlotMap);
            });
            resp.setDataPartitionTable(dataPartitionMap);
        }
        return resp;
    }
}

