/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.compression.ZlibCodecFactory;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionDecoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionEncoder;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.EmptyArrays;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.Mono;
import reactor.netty.Connection;
import reactor.netty.FutureMono;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.WebsocketServerOperations;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class Http2WebsocketServerOperations
extends WebsocketServerOperations {
    static final AsciiString V13 = AsciiString.cached((String)"13");
    WebsocketServerHandshaker handshakerHttp2;
    static final ChannelFutureListener EMPTY = f -> {};

    Http2WebsocketServerOperations(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        super(wsUrl, websocketServerSpec, replaced);
    }

    @Override
    @Nullable
    public String selectedSubprotocol() {
        return this.handshakerHttp2.selectedSubProtocol;
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format((Channel)this.channel(), (String)"WebSocket server inbound receiver cancelled, closing Websocket."));
        }
        this.sendCloseNow(new CloseWebSocketFrame(), WebSocketCloseStatus.ABNORMAL_CLOSURE, EMPTY);
    }

    @Override
    void initHandshaker(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        this.handshakerResult = this.channel().newPromise();
        if (this.isValid()) {
            Channel channel = this.channel();
            this.removeHandler("reactor.left.accessLogHandler");
            ChannelHandler handler = channel.pipeline().get("reactor.left.httpMetricsHandler");
            if (handler != null) {
                this.replaceHandler("reactor.left.httpMetricsHandler", (ChannelHandler)new WebsocketServerOperations.WebsocketHttpServerMetricsHandler((AbstractHttpServerMetricsHandler)handler));
            }
            DefaultHttpRequest request = new DefaultHttpRequest(replaced.version(), replaced.method(), replaced.uri());
            request.headers().set(replaced.nettyRequest.headers());
            if (websocketServerSpec.compress()) {
                this.removeHandler("reactor.left.compressionHandler");
                PerMessageDeflateServerExtensionHandshaker perMessageDeflateServerExtensionHandshaker = new PerMessageDeflateServerExtensionHandshaker(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, websocketServerSpec.compressionAllowServerNoContext(), websocketServerSpec.compressionPreferredClientNoContext(), 0);
                WebsocketServerExtensionHandler wsServerExtensionHandler = new WebsocketServerExtensionHandler(Arrays.asList(perMessageDeflateServerExtensionHandshaker, new DeflateFrameServerExtensionHandshaker(6, 0)));
                try {
                    ChannelPipeline pipeline = channel.pipeline();
                    wsServerExtensionHandler.channelRead(pipeline.context("reactor.right.reactiveBridge"), request);
                    if (pipeline.get("reactor.left.httpTrafficHandler") != null) {
                        pipeline.addAfter("reactor.left.httpTrafficHandler", "reactor.left.wsCompressionHandler", (ChannelHandler)wsServerExtensionHandler);
                    }
                }
                catch (Throwable e) {
                    log.error(ReactorNetty.format((Channel)channel, (String)""), e);
                }
            }
            this.handshakerHttp2 = new WebsocketServerHandshaker(wsUrl, websocketServerSpec);
            this.handshakerHttp2.handshake(channel, (HttpRequest)request, this.responseHeaders.remove((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), this.handshakerResult).addListener(f -> {
                if (replaced.rebind((Connection)this)) {
                    this.markPersistent(false);
                    channel.read();
                } else if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format((Channel)channel, (String)"Cannot bind Http2WebsocketServerOperations after the handshake."));
                }
            });
        }
    }

    boolean isValid() {
        String msg = null;
        if (this.nettyRequest instanceof FullHttpRequest) {
            msg = "Failed to upgrade to websocket. End of stream is received.";
        } else if (!HttpMethod.CONNECT.equals((Object)this.method())) {
            msg = "Invalid websocket request handshake method [" + this.method() + "].";
        } else if (!this.requestHeaders().contains((CharSequence)"x-http2-protocol", (CharSequence)HttpHeaderValues.WEBSOCKET, true)) {
            msg = "Invalid websocket request, missing [:protocol=websocket] header.";
        } else {
            String version = this.requestHeaders().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION);
            if (version == null || !version.equals(WebSocketVersion.V13.toHttpHeaderValue())) {
                msg = "Websocket version [" + version + "] is not supported.";
            }
        }
        if (msg != null) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST, Unpooled.EMPTY_BUFFER);
            res.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
            WebSocketServerHandshakeException handshakeException = new WebSocketServerHandshakeException(msg, this.nettyRequest);
            this.channel().writeAndFlush((Object)res).addListener(arg_0 -> this.lambda$isValid$1((Throwable)handshakeException, arg_0));
            return false;
        }
        return true;
    }

    @Override
    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.tryEmitValue((Object)new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    this.channel().write((Object)frame);
                    return this.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease((Object)frame));
        }
        frame.release();
        return Mono.empty();
    }

    @Override
    void sendCloseNow(CloseWebSocketFrame frame, WebSocketCloseStatus closeStatus, ChannelFutureListener listener) {
        if (!frame.isFinalFragment()) {
            this.channel().writeAndFlush((Object)frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.onCloseState.tryEmitValue((Object)closeStatus);
            this.channel().write((Object)frame);
            this.channel().writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)listener);
        } else {
            frame.release();
        }
    }

    @Override
    Subscriber<Void> websocketSubscriber(ContextView contextView) {
        return new HttpServerOperations.WebsocketSubscriber(this, Context.of((ContextView)contextView), EMPTY);
    }

    private /* synthetic */ void lambda$isValid$1(Throwable handshakeException, Future f) throws Exception {
        this.handshakerResult.setFailure(handshakeException);
    }

    static final class WebsocketServerExtensionHandler
    extends ChannelDuplexHandler {
        final List<WebSocketServerExtensionHandshaker> extensionHandshakers;
        final Queue<List<WebSocketServerExtension>> validExtensions = new ArrayDeque<List<WebSocketServerExtension>>(4);
        static final String EXTENSION_SEPARATOR = ",";
        static final String PARAMETER_SEPARATOR = ";";
        static final char PARAMETER_EQUAL = '=';

        WebsocketServerExtensionHandler(List<WebSocketServerExtensionHandshaker> extensionHandshakers) {
            this.extensionHandshakers = extensionHandshakers;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg != LastHttpContent.EMPTY_LAST_CONTENT) {
                if (msg instanceof DefaultHttpRequest) {
                    this.onHttpRequestChannelRead(ctx, (HttpRequest)((DefaultHttpRequest)msg));
                } else if (msg instanceof HttpRequest) {
                    this.onHttpRequestChannelRead(ctx, (HttpRequest)msg);
                } else {
                    ctx.fireChannelRead(msg);
                }
            } else {
                ctx.fireChannelRead(msg);
            }
        }

        void onHttpRequestChannelRead(ChannelHandlerContext ctx, HttpRequest request) {
            List validExtensionsList = null;
            String extensionsHeader = request.headers().getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
            if (extensionsHeader != null) {
                List extensions = WebSocketExtensionUtil.extractExtensions((String)extensionsHeader);
                int rsv = 0;
                for (WebSocketExtensionData extensionData : extensions) {
                    Iterator<WebSocketServerExtensionHandshaker> extensionHandshakersIterator = this.extensionHandshakers.iterator();
                    WebSocketServerExtension validExtension = null;
                    while (validExtension == null && extensionHandshakersIterator.hasNext()) {
                        WebSocketServerExtensionHandshaker extensionHandshaker = extensionHandshakersIterator.next();
                        validExtension = extensionHandshaker.handshakeExtension(extensionData);
                    }
                    if (validExtension == null || (validExtension.rsv() & rsv) != 0) continue;
                    if (validExtensionsList == null) {
                        validExtensionsList = new ArrayList(1);
                    }
                    rsv |= validExtension.rsv();
                    validExtensionsList.add(validExtension);
                }
            }
            if (validExtensionsList == null) {
                validExtensionsList = Collections.emptyList();
            }
            this.validExtensions.offer(validExtensionsList);
            ctx.fireChannelRead((Object)request);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            if (msg != Unpooled.EMPTY_BUFFER && !(msg instanceof ByteBuf)) {
                if (msg.getClass() == DefaultHttpResponse.class) {
                    this.onHttpResponseWrite(ctx, (HttpResponse)((DefaultHttpResponse)msg), promise);
                } else if (msg instanceof HttpResponse) {
                    this.onHttpResponseWrite(ctx, (HttpResponse)msg, promise);
                } else {
                    ctx.write(msg, promise);
                }
            } else {
                ctx.write(msg, promise);
            }
        }

        void onHttpResponseWrite(ChannelHandlerContext ctx, HttpResponse response, ChannelPromise promise) {
            List<WebSocketServerExtension> validExtensionsList = this.validExtensions.poll();
            if (HttpResponseStatus.OK.equals((Object)response.status())) {
                this.handlePotentialUpgrade(ctx, promise, response, validExtensionsList);
            }
            ctx.write((Object)response, promise);
        }

        void handlePotentialUpgrade(ChannelHandlerContext ctx, ChannelPromise promise, HttpResponse httpResponse, @Nullable List<WebSocketServerExtension> validExtensionsList) {
            HttpHeaders headers = httpResponse.headers();
            if (validExtensionsList != null && !validExtensionsList.isEmpty()) {
                String headerValue = headers.getAsString((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS);
                ArrayList<WebSocketExtensionData> extraExtensions = new ArrayList<WebSocketExtensionData>(this.extensionHandshakers.size());
                for (WebSocketServerExtension extension : validExtensionsList) {
                    extraExtensions.add(extension.newReponseData());
                }
                String newHeaderValue = WebsocketServerExtensionHandler.computeMergeExtensionsHeaderValue(headerValue, extraExtensions);
                promise.addListener(future -> {
                    if (future.isSuccess()) {
                        for (WebSocketServerExtension extension : validExtensionsList) {
                            WebSocketExtensionDecoder decoder = extension.newExtensionDecoder();
                            WebSocketExtensionEncoder encoder = extension.newExtensionEncoder();
                            String name = ctx.name();
                            ctx.pipeline().addAfter(name, decoder.getClass().getName(), (ChannelHandler)decoder).addAfter(name, encoder.getClass().getName(), (ChannelHandler)encoder);
                        }
                    }
                });
                if (!newHeaderValue.isEmpty()) {
                    headers.set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_EXTENSIONS, (Object)newHeaderValue);
                }
            }
            promise.addListener(future -> {
                if (future.isSuccess()) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            });
        }

        static String computeMergeExtensionsHeaderValue(@Nullable String userDefinedHeaderValue, List<WebSocketExtensionData> extraExtensions) {
            List userDefinedExtensions = userDefinedHeaderValue != null ? WebSocketExtensionUtil.extractExtensions((String)userDefinedHeaderValue) : Collections.emptyList();
            for (WebSocketExtensionData userDefined : userDefinedExtensions) {
                int i;
                WebSocketExtensionData matchingExtra = null;
                for (i = 0; i < extraExtensions.size(); ++i) {
                    WebSocketExtensionData extra = extraExtensions.get(i);
                    if (!extra.name().equals(userDefined.name())) continue;
                    matchingExtra = extra;
                    break;
                }
                if (matchingExtra == null) {
                    extraExtensions.add(userDefined);
                    continue;
                }
                HashMap mergedParameters = new HashMap(matchingExtra.parameters());
                mergedParameters.putAll(userDefined.parameters());
                extraExtensions.set(i, new WebSocketExtensionData(matchingExtra.name(), mergedParameters));
            }
            StringBuilder sb = new StringBuilder(150);
            for (WebSocketExtensionData data : extraExtensions) {
                sb.append(data.name());
                for (Map.Entry parameter : data.parameters().entrySet()) {
                    sb.append(PARAMETER_SEPARATOR);
                    sb.append((String)parameter.getKey());
                    if (parameter.getValue() == null) continue;
                    sb.append('=');
                    sb.append((String)parameter.getValue());
                }
                sb.append(EXTENSION_SEPARATOR);
            }
            if (!extraExtensions.isEmpty()) {
                sb.setLength(sb.length() - EXTENSION_SEPARATOR.length());
            }
            return sb.toString();
        }
    }

    static final class WebsocketServerHandshaker {
        static final String SUB_PROTOCOL_WILDCARD = "*";
        final String uri;
        final String[] subProtocols;
        final WebSocketDecoderConfig decoderConfig;
        String selectedSubProtocol;

        WebsocketServerHandshaker(String uri, WebsocketServerSpec websocketServerSpec) {
            this.uri = uri;
            String protocols = websocketServerSpec.protocols();
            if (protocols != null) {
                String[] subProtocolArray = protocols.split(",");
                for (int i = 0; i < subProtocolArray.length; ++i) {
                    subProtocolArray[i] = subProtocolArray[i].trim();
                }
                this.subProtocols = subProtocolArray;
            } else {
                this.subProtocols = EmptyArrays.EMPTY_STRINGS;
            }
            this.decoderConfig = WebSocketDecoderConfig.newBuilder().allowExtensions(true).maxFramePayloadLength(websocketServerSpec.maxFramePayloadLength()).allowMaskMismatch(false).build();
        }

        ChannelFuture handshake(Channel channel, HttpRequest req, HttpHeaders responseHeaders, ChannelPromise promise) {
            HttpResponse response = this.newHandshakeResponse(req.headers().get((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL), responseHeaders);
            ChannelPipeline p = channel.pipeline();
            channel.writeAndFlush((Object)response).addListener(future -> {
                if (future.isSuccess()) {
                    ChannelHandlerContext ctx = p.context("reactor.left.httpTrafficHandler");
                    p.addAfter(ctx.name(), "wsdecoder", (ChannelHandler)WebsocketServerHandshaker.newWebsocketDecoder(this.decoderConfig));
                    p.addAfter(ctx.name(), "wsencoder", (ChannelHandler)WebsocketServerHandshaker.newWebsocketEncoder());
                    p.replace(ctx.name(), "reactor.left.websocketStreamBridgeServerHandler", (ChannelHandler)WebsocketStreamBridgeServerHandler.INSTANCE);
                    promise.setSuccess();
                } else {
                    promise.setFailure(future.cause());
                }
            });
            return promise;
        }

        @Nullable
        String selectSubProtocol(@Nullable String requestedSubProtocols) {
            String[] requestedSubProtocolArray;
            if (requestedSubProtocols == null || this.subProtocols.length == 0) {
                return null;
            }
            for (String p : requestedSubProtocolArray = requestedSubProtocols.split(",")) {
                String requestedSubProtocol = p.trim();
                for (String supportedSubProtocol : this.subProtocols) {
                    if (!SUB_PROTOCOL_WILDCARD.equals(supportedSubProtocol) && !requestedSubProtocol.equals(supportedSubProtocol)) continue;
                    this.selectedSubProtocol = requestedSubProtocol;
                    return requestedSubProtocol;
                }
            }
            return null;
        }

        HttpResponse newHandshakeResponse(@Nullable String subProtocols, HttpHeaders headers) {
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            res.headers().add(headers);
            if (subProtocols != null) {
                String selectedSubProtocol = this.selectSubProtocol(subProtocols);
                if (selectedSubProtocol == null) {
                    if (HttpServerOperations.log.isDebugEnabled()) {
                        HttpServerOperations.log.debug("Requested subprotocol(s) not supported: {}", new Object[]{subProtocols});
                    }
                } else {
                    res.headers().set((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL, (Object)selectedSubProtocol);
                }
            }
            return res;
        }

        static WebSocketFrameDecoder newWebsocketDecoder(WebSocketDecoderConfig decoderConfig) {
            return new WebSocket13FrameDecoder(decoderConfig);
        }

        static WebSocketFrameEncoder newWebsocketEncoder() {
            return new WebSocket13FrameEncoder(false);
        }

        static final class WebsocketStreamBridgeServerHandler
        extends ChannelDuplexHandler {
            static final WebsocketStreamBridgeServerHandler INSTANCE = new WebsocketStreamBridgeServerHandler();
            static final String NAME = "reactor.left.websocketStreamBridgeServerHandler";

            WebsocketStreamBridgeServerHandler() {
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                if (!(msg instanceof FullHttpRequest) && msg instanceof HttpContent) {
                    ctx.fireChannelRead((Object)((HttpContent)msg).content());
                } else {
                    ctx.fireChannelRead(msg);
                }
            }

            public boolean isSharable() {
                return true;
            }

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (msg instanceof ByteBuf) {
                    ctx.write((Object)new DefaultHttpContent((ByteBuf)msg), promise);
                } else {
                    ctx.write(msg, promise);
                }
            }
        }
    }
}

