/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class NullIfExpression
extends Expression {
    private final Expression first;
    private final Expression second;

    public NullIfExpression(Expression first, Expression second) {
        super(null);
        this.first = Objects.requireNonNull(first, "first is null");
        this.second = Objects.requireNonNull(first, "second is null");
    }

    public NullIfExpression(NodeLocation location, Expression first, Expression second) {
        super(Objects.requireNonNull(location, "location is null"));
        this.first = Objects.requireNonNull(first, "first is null");
        this.second = Objects.requireNonNull(first, "second is null");
    }

    public Expression getFirst() {
        return this.first;
    }

    public Expression getSecond() {
        return this.second;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitNullIfExpression(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.first, (Object)this.second);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NullIfExpression that = (NullIfExpression)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return NullIfExpression.sameClass(this, other);
    }
}

