/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import org.apache.jena.graph.Graph;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecDatasetBuilder;
import org.apache.jena.sparql.exec.http.UpdateExecHTTP;
import org.apache.jena.update.UpdateProcessor;

public interface UpdateExec
extends UpdateProcessor {
    public static UpdateExecBuilder dataset(DatasetGraph dataset) {
        return UpdateExecDatasetBuilder.create().dataset(dataset);
    }

    public static UpdateExecBuilder dataset(Graph graph) {
        DatasetGraph dsg = DatasetGraphFactory.wrap(graph);
        return UpdateExecDatasetBuilder.create().dataset(dsg);
    }

    public static UpdateExecBuilder service(String serviceURL) {
        return (UpdateExecBuilder)UpdateExecHTTP.newBuilder().endpoint(serviceURL);
    }

    public static UpdateExecDatasetBuilder newBuilder() {
        return UpdateExecDatasetBuilder.create();
    }

    @Override
    public void execute();
}

