/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.http.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.api.core.Session;
import org.apache.wiki.api.spi.Wiki;

public class CsrfProtectionFilter
implements Filter {
    private static final Logger LOG = LogManager.getLogger(CsrfProtectionFilter.class);
    public static final String ANTICSRF_PARAM = "X-XSRF-TOKEN";

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (CsrfProtectionFilter.isPost((HttpServletRequest)request)) {
            Engine engine = Wiki.engine().find(request.getServletContext(), null);
            Session session = Wiki.session().find(engine, (HttpServletRequest)request);
            if (!CsrfProtectionFilter.requestContainsValidCsrfToken(request, session)) {
                LOG.error("Incorrect {} param with value '{}' received for {}", (Object)ANTICSRF_PARAM, (Object)request.getParameter(ANTICSRF_PARAM), (Object)((HttpServletRequest)request).getPathInfo());
                ((HttpServletResponse)response).sendRedirect("/error/Forbidden.html");
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public static boolean isCsrfProtectedPost(HttpServletRequest request) {
        if (CsrfProtectionFilter.isPost(request)) {
            Engine engine = Wiki.engine().find(request.getServletContext(), null);
            Session session = Wiki.session().find(engine, request);
            return CsrfProtectionFilter.requestContainsValidCsrfToken((ServletRequest)request, session);
        }
        return false;
    }

    private static boolean requestContainsValidCsrfToken(ServletRequest request, Session session) {
        return session.antiCsrfToken().equals(request.getParameter(ANTICSRF_PARAM));
    }

    static boolean isPost(HttpServletRequest request) {
        return "POST".equalsIgnoreCase(request.getMethod());
    }

    public void destroy() {
    }
}

