/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.util;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.uima.cas.ArrayFS;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.cas.ByteArrayFS;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.FloatArrayFS;
import org.apache.uima.cas.IntArrayFS;
import org.apache.uima.cas.LongArrayFS;
import org.apache.uima.cas.ShortArrayFS;
import org.apache.uima.cas.StringArrayFS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.FloatList;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.IntegerList;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.NonEmptyFloatList;
import org.apache.uima.jcas.cas.NonEmptyIntegerList;
import org.apache.uima.jcas.cas.NonEmptyStringList;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.StringList;
import org.apache.uima.jcas.cas.TOP;

public abstract class FSCollectionFactory<T extends FeatureStructure> {
    private FSCollectionFactory() {
    }

    public static Collection<FeatureStructure> create(CAS cas, Type type) {
        TypeSystem ts = cas.getTypeSystem();
        if (ts.subsumes(cas.getAnnotationType(), type)) {
            return FSCollectionFactory.create(cas.getAnnotationIndex(type));
        }
        return FSCollectionFactory.create(cas.getIndexRepository().getAllIndexedFS(type));
    }

    public static <T extends FeatureStructure> Collection<T> create(FSIterator<T> aIterator) {
        return new FSIteratorAdapter<T>(aIterator);
    }

    public static <T extends AnnotationFS> Collection<T> create(AnnotationIndex<T> aIndex) {
        return new AnnotationIndexAdapter<T>(aIndex);
    }

    public static Collection<FeatureStructure> create(ArrayFS aArray) {
        return FSCollectionFactory.create(aArray, (Type)null);
    }

    public static <T extends TOP> Collection<T> create(ArrayFS aArray, Class<T> aType) {
        return FSCollectionFactory.create(aArray, CasUtil.getType(aArray.getCAS(), aType));
    }

    public static Collection<FeatureStructure> create(ArrayFS aArray, Type aType) {
        TypeSystem ts = aArray.getCAS().getTypeSystem();
        ArrayList<FeatureStructure> data = new ArrayList<FeatureStructure>(aArray.size());
        for (int i = 0; i < aArray.size(); ++i) {
            FeatureStructure value = aArray.get(i);
            if (value == null || aType != null && !ts.subsumes(aType, value.getType())) continue;
            data.add(value);
        }
        return Arrays.asList(data.toArray(new FeatureStructure[data.size()]));
    }

    public static ArrayFS createArrayFS(CAS aCas, Collection<? extends FeatureStructure> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createArrayFS(aCollection.size()), aCollection);
    }

    public static ArrayFS createArrayFS(CAS aCas, FeatureStructure[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createArrayFS(aArray.length), Arrays.asList(aArray));
    }

    public static FSArray createFSArray(JCas aJCas, Collection<? extends FeatureStructure> aCollection) {
        return FSCollectionFactory.fillArrayFS(new FSArray(aJCas, aCollection.size()), aCollection);
    }

    public static FSArray createFSArray(JCas aJCas, FeatureStructure[] aArray) {
        return FSCollectionFactory.fillArrayFS(new FSArray(aJCas, aArray.length), Arrays.asList(aArray));
    }

    public static BooleanArrayFS createBooleanArray(CAS aCas, Collection<Boolean> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createBooleanArrayFS(aCollection.size()), aCollection);
    }

    public static BooleanArrayFS createBooleanArray(CAS aCas, boolean[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createBooleanArrayFS(aArray.length), aArray);
    }

    public static BooleanArrayFS createBooleanArray(JCas aJCas, Collection<Boolean> aCollection) {
        return FSCollectionFactory.fillArrayFS((BooleanArrayFS)new BooleanArray(aJCas, aCollection.size()), aCollection);
    }

    public static BooleanArrayFS createBooleanArray(JCas aJCas, boolean[] aArray) {
        return FSCollectionFactory.fillArrayFS((BooleanArrayFS)new BooleanArray(aJCas, aArray.length), aArray);
    }

    public static ByteArrayFS createByteArray(CAS aCas, Collection<Byte> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createByteArrayFS(aCollection.size()), aCollection);
    }

    public static ByteArrayFS createByteArray(CAS aCas, byte[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createByteArrayFS(aArray.length), aArray);
    }

    public static ByteArrayFS createByteArray(JCas aJCas, Collection<Byte> aCollection) {
        return FSCollectionFactory.fillArrayFS((ByteArrayFS)new ByteArray(aJCas, aCollection.size()), aCollection);
    }

    public static ByteArrayFS createByteArray(JCas aJCas, byte[] aArray) {
        return FSCollectionFactory.fillArrayFS((ByteArrayFS)new ByteArray(aJCas, aArray.length), aArray);
    }

    public static DoubleArrayFS createDoubleArray(CAS aCas, Collection<Double> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createDoubleArrayFS(aCollection.size()), aCollection);
    }

    public static DoubleArrayFS createDoubleArray(CAS aCas, double[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createDoubleArrayFS(aArray.length), aArray);
    }

    public static DoubleArrayFS createDoubleArray(JCas aJCas, Collection<Double> aCollection) {
        return FSCollectionFactory.fillArrayFS((DoubleArrayFS)new DoubleArray(aJCas, aCollection.size()), aCollection);
    }

    public static DoubleArrayFS createDoubleArray(JCas aJCas, double[] aArray) {
        return FSCollectionFactory.fillArrayFS((DoubleArrayFS)new DoubleArray(aJCas, aArray.length), aArray);
    }

    public static FloatArrayFS createFloatArray(CAS aCas, Collection<Float> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createFloatArrayFS(aCollection.size()), aCollection);
    }

    public static FloatArrayFS createFloatArray(CAS aCas, float[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createFloatArrayFS(aArray.length), aArray);
    }

    public static FloatArrayFS createFloatArray(JCas aJCas, Collection<Float> aCollection) {
        return FSCollectionFactory.fillArrayFS((FloatArrayFS)new FloatArray(aJCas, aCollection.size()), aCollection);
    }

    public static FloatArrayFS createFloatArray(JCas aJCas, float[] aArray) {
        return FSCollectionFactory.fillArrayFS((FloatArrayFS)new FloatArray(aJCas, aArray.length), aArray);
    }

    public static IntArrayFS createIntArray(CAS aCas, Collection<Integer> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createIntArrayFS(aCollection.size()), aCollection);
    }

    public static IntArrayFS createIntArray(CAS aCas, int[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createIntArrayFS(aArray.length), aArray);
    }

    public static IntArrayFS createIntArray(JCas aJCas, Collection<Integer> aCollection) {
        return FSCollectionFactory.fillArrayFS((IntArrayFS)new IntegerArray(aJCas, aCollection.size()), aCollection);
    }

    public static IntArrayFS createIntArray(JCas aJCas, int[] aArray) {
        return FSCollectionFactory.fillArrayFS((IntArrayFS)new IntegerArray(aJCas, aArray.length), aArray);
    }

    public static LongArrayFS createLongArray(CAS aCas, Collection<Long> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createLongArrayFS(aCollection.size()), aCollection);
    }

    public static LongArrayFS createLongArray(CAS aCas, long[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createLongArrayFS(aArray.length), aArray);
    }

    public static LongArrayFS createLongArray(JCas aJCas, Collection<Long> aCollection) {
        return FSCollectionFactory.fillArrayFS((LongArrayFS)new LongArray(aJCas, aCollection.size()), aCollection);
    }

    public static LongArrayFS createLongArray(JCas aJCas, long[] aArray) {
        return FSCollectionFactory.fillArrayFS((LongArrayFS)new LongArray(aJCas, aArray.length), aArray);
    }

    public static ShortArrayFS createShortArray(CAS aCas, Collection<Short> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createShortArrayFS(aCollection.size()), aCollection);
    }

    public static ShortArrayFS createShortArray(CAS aCas, short[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createShortArrayFS(aArray.length), aArray);
    }

    public static ShortArrayFS createShortArray(JCas aJCas, Collection<Short> aCollection) {
        return FSCollectionFactory.fillArrayFS((ShortArrayFS)new ShortArray(aJCas, aCollection.size()), aCollection);
    }

    public static ShortArrayFS createShortArray(JCas aJCas, short[] aArray) {
        return FSCollectionFactory.fillArrayFS((ShortArrayFS)new ShortArray(aJCas, aArray.length), aArray);
    }

    public static StringArrayFS createStringArray(CAS aCas, Collection<String> aCollection) {
        return FSCollectionFactory.fillArrayFS(aCas.createStringArrayFS(aCollection.size()), aCollection);
    }

    public static StringArrayFS createStringArray(CAS aCas, String[] aArray) {
        return FSCollectionFactory.fillArrayFS(aCas.createStringArrayFS(aArray.length), aArray);
    }

    public static StringArrayFS createStringArray(JCas aJCas, Collection<String> aCollection) {
        return FSCollectionFactory.fillArrayFS((StringArrayFS)new StringArray(aJCas, aCollection.size()), aCollection);
    }

    public static StringArrayFS createStringArray(JCas aJCas, String[] aArray) {
        return FSCollectionFactory.fillArrayFS((StringArrayFS)new StringArray(aJCas, aArray.length), aArray);
    }

    public static <T extends ArrayFS> T fillArrayFS(T aArrayFs, Iterable<? extends FeatureStructure> aCollection) {
        int i = 0;
        for (FeatureStructure featureStructure : aCollection) {
            aArrayFs.set(i, featureStructure);
            ++i;
        }
        return aArrayFs;
    }

    public static ArrayFS fillArrayFS(ArrayFS aArrayFs, FeatureStructure[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static BooleanArrayFS fillArrayFS(BooleanArrayFS aArrayFs, Iterable<Boolean> aCollection) {
        int i = 0;
        for (Boolean fs : aCollection) {
            aArrayFs.set(i, fs.booleanValue());
            ++i;
        }
        return aArrayFs;
    }

    public static BooleanArrayFS fillArrayFS(BooleanArrayFS aArrayFs, boolean[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static ByteArrayFS fillArrayFS(ByteArrayFS aArrayFs, Iterable<Byte> aCollection) {
        int i = 0;
        for (Byte fs : aCollection) {
            aArrayFs.set(i, fs.byteValue());
            ++i;
        }
        return aArrayFs;
    }

    public static ByteArrayFS fillArrayFS(ByteArrayFS aArrayFs, byte[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static DoubleArrayFS fillArrayFS(DoubleArrayFS aArrayFs, Iterable<Double> aCollection) {
        int i = 0;
        for (Double fs : aCollection) {
            aArrayFs.set(i, fs.doubleValue());
            ++i;
        }
        return aArrayFs;
    }

    public static DoubleArrayFS fillArrayFS(DoubleArrayFS aArrayFs, double[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static FloatArrayFS fillArrayFS(FloatArrayFS aArrayFs, Iterable<Float> aCollection) {
        int i = 0;
        for (Float fs : aCollection) {
            aArrayFs.set(i, fs.floatValue());
            ++i;
        }
        return aArrayFs;
    }

    public static FloatArrayFS fillArrayFS(FloatArrayFS aArrayFs, float[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static IntArrayFS fillArrayFS(IntArrayFS aArrayFs, Iterable<Integer> aCollection) {
        int i = 0;
        for (Integer fs : aCollection) {
            aArrayFs.set(i, fs.intValue());
            ++i;
        }
        return aArrayFs;
    }

    public static IntArrayFS fillArrayFS(IntArrayFS aArrayFs, int[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static LongArrayFS fillArrayFS(LongArrayFS aArrayFs, Iterable<Long> aCollection) {
        int i = 0;
        for (Long fs : aCollection) {
            aArrayFs.set(i, fs.longValue());
            ++i;
        }
        return aArrayFs;
    }

    public static LongArrayFS fillArrayFS(LongArrayFS aArrayFs, long[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static ShortArrayFS fillArrayFS(ShortArrayFS aArrayFs, Iterable<Short> aCollection) {
        int i = 0;
        for (Short fs : aCollection) {
            aArrayFs.set(i, fs.shortValue());
            ++i;
        }
        return aArrayFs;
    }

    public static ShortArrayFS fillArrayFS(ShortArrayFS aArrayFs, short[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static StringArrayFS fillArrayFS(StringArrayFS aArrayFs, Iterable<String> aCollection) {
        int i = 0;
        for (String fs : aCollection) {
            aArrayFs.set(i, fs);
            ++i;
        }
        return aArrayFs;
    }

    public static StringArrayFS fillArrayFS(StringArrayFS aArrayFs, String[] aArray) {
        aArrayFs.copyFromArray(aArray, 0, 0, aArrayFs.size());
        return aArrayFs;
    }

    public static Collection<TOP> create(FSList aList) {
        return FSCollectionFactory.create(aList, (Type)null);
    }

    public static <T extends TOP> Collection<T> create(FSList aList, Class<T> aType) {
        return FSCollectionFactory.create(aList, CasUtil.getType(aList.getCAS(), aType));
    }

    public static Collection<TOP> create(FSList aList, Type type) {
        TypeSystem ts = aList.getCAS().getTypeSystem();
        ArrayList<TOP> data = new ArrayList<TOP>();
        FSList i = aList;
        while (i instanceof NonEmptyFSList) {
            NonEmptyFSList l = (NonEmptyFSList)i;
            TOP value = l.getHead();
            if (value != null && (type == null || ts.subsumes(type, value.getType()))) {
                data.add(l.getHead());
            }
            i = l.getTail();
        }
        return Arrays.asList(data.toArray(new TOP[data.size()]));
    }

    public static Collection<String> create(StringList aList) {
        ArrayList<String> data = new ArrayList<String>();
        StringList i = aList;
        while (i instanceof NonEmptyStringList) {
            NonEmptyStringList l = (NonEmptyStringList)i;
            data.add(l.getHead());
            i = l.getTail();
        }
        return Arrays.asList(data.toArray(new String[data.size()]));
    }

    public static Collection<Integer> create(IntegerList aList) {
        ArrayList<Integer> data = new ArrayList<Integer>();
        IntegerList i = aList;
        while (i instanceof NonEmptyIntegerList) {
            NonEmptyIntegerList l = (NonEmptyIntegerList)i;
            data.add(l.getHead());
            i = l.getTail();
        }
        return Arrays.asList(data.toArray(new Integer[data.size()]));
    }

    public static Collection<Float> create(FloatList aList) {
        ArrayList<Float> data = new ArrayList<Float>();
        FloatList i = aList;
        while (i instanceof NonEmptyFloatList) {
            NonEmptyFloatList l = (NonEmptyFloatList)i;
            data.add(Float.valueOf(l.getHead()));
            i = l.getTail();
        }
        return Arrays.asList(data.toArray(new Float[data.size()]));
    }

    public static FSList createFSList(JCas aJCas, Collection<? extends TOP> aCollection) {
        return (FSList)FSCollectionFactory.createFSList(aJCas.getCas(), aCollection);
    }

    public static <T extends FeatureStructure> T createFSList(CAS aCas, FeatureStructure ... aValues) {
        return FSCollectionFactory.createFSList(aCas, Arrays.asList(aValues));
    }

    public static <T extends FeatureStructure> T createFSList(CAS aCas, Collection<? extends FeatureStructure> aValues) {
        FeatureStructure head;
        if (aValues == null) {
            return null;
        }
        TypeSystem ts = aCas.getTypeSystem();
        Type emptyType = ts.getType("uima.cas.EmptyFSList");
        if (aValues.size() == 0) {
            return (T)aCas.createFS(emptyType);
        }
        Type nonEmptyType = ts.getType("uima.cas.NonEmptyFSList");
        Feature headFeature = nonEmptyType.getFeatureByBaseName("head");
        Feature tailFeature = nonEmptyType.getFeatureByBaseName("tail");
        FeatureStructure list = head = aCas.createFS(nonEmptyType);
        Iterator<? extends FeatureStructure> i = aValues.iterator();
        while (i.hasNext()) {
            head.setFeatureValue(headFeature, i.next());
            if (i.hasNext()) {
                FeatureStructure tail = aCas.createFS(nonEmptyType);
                head.setFeatureValue(tailFeature, tail);
                head = tail;
                continue;
            }
            head.setFeatureValue(tailFeature, aCas.createFS(emptyType));
        }
        return (T)list;
    }

    public static FloatList createFloatList(JCas aJCas, float ... aValues) {
        return (FloatList)FSCollectionFactory.createFloatList(aJCas.getCas(), aValues);
    }

    public static <T extends FeatureStructure> T createFloatList(CAS aCas, float ... aValues) {
        FeatureStructure head;
        if (aValues == null) {
            return null;
        }
        TypeSystem ts = aCas.getTypeSystem();
        Type emptyType = ts.getType("uima.cas.EmptyFloatList");
        if (aValues.length == 0) {
            return (T)aCas.createFS(emptyType);
        }
        Type nonEmptyType = ts.getType("uima.cas.NonEmptyFloatList");
        Feature headFeature = nonEmptyType.getFeatureByBaseName("head");
        Feature tailFeature = nonEmptyType.getFeatureByBaseName("tail");
        FeatureStructure list = head = aCas.createFS(nonEmptyType);
        int i = 0;
        while (i < aValues.length) {
            head.setFloatValue(headFeature, aValues[i]);
            if (++i < aValues.length) {
                FeatureStructure tail = aCas.createFS(nonEmptyType);
                head.setFeatureValue(tailFeature, tail);
                head = tail;
                continue;
            }
            head.setFeatureValue(tailFeature, aCas.createFS(emptyType));
        }
        return (T)list;
    }

    public static <T extends FeatureStructure> T createFloatList(CAS aCas, Collection<Float> aValues) {
        FeatureStructure head;
        if (aValues == null) {
            return null;
        }
        TypeSystem ts = aCas.getTypeSystem();
        Type emptyType = ts.getType("uima.cas.EmptyFloatList");
        if (aValues.size() == 0) {
            return (T)aCas.createFS(emptyType);
        }
        Type nonEmptyType = ts.getType("uima.cas.NonEmptyFloatList");
        Feature headFeature = nonEmptyType.getFeatureByBaseName("head");
        Feature tailFeature = nonEmptyType.getFeatureByBaseName("tail");
        FeatureStructure list = head = aCas.createFS(nonEmptyType);
        Iterator<Float> i = aValues.iterator();
        while (i.hasNext()) {
            head.setFloatValue(headFeature, i.next().floatValue());
            if (i.hasNext()) {
                FeatureStructure tail = aCas.createFS(nonEmptyType);
                head.setFeatureValue(tailFeature, tail);
                head = tail;
                continue;
            }
            head.setFeatureValue(tailFeature, aCas.createFS(emptyType));
        }
        return (T)list;
    }

    public static FloatList createFloatList(JCas aJCas, Collection<Float> aCollection) {
        return (FloatList)FSCollectionFactory.createFloatList(aJCas.getCas(), aCollection);
    }

    public static IntegerList createIntegerList(JCas aJCas, int ... aValues) {
        return (IntegerList)FSCollectionFactory.createIntegerList(aJCas.getCas(), aValues);
    }

    public static <T extends FeatureStructure> T createIntegerList(CAS aCas, int ... aValues) {
        FeatureStructure head;
        if (aValues == null) {
            return null;
        }
        TypeSystem ts = aCas.getTypeSystem();
        Type emptyType = ts.getType("uima.cas.EmptyIntegerList");
        if (aValues.length == 0) {
            return (T)aCas.createFS(emptyType);
        }
        Type nonEmptyType = ts.getType("uima.cas.NonEmptyIntegerList");
        Feature headFeature = nonEmptyType.getFeatureByBaseName("head");
        Feature tailFeature = nonEmptyType.getFeatureByBaseName("tail");
        FeatureStructure list = head = aCas.createFS(nonEmptyType);
        int i = 0;
        while (i < aValues.length) {
            head.setIntValue(headFeature, aValues[i]);
            if (++i < aValues.length) {
                FeatureStructure tail = aCas.createFS(nonEmptyType);
                head.setFeatureValue(tailFeature, tail);
                head = tail;
                continue;
            }
            head.setFeatureValue(tailFeature, aCas.createFS(emptyType));
        }
        return (T)list;
    }

    public static <T extends FeatureStructure> T createIntegerList(CAS aCas, Collection<Integer> aValues) {
        FeatureStructure head;
        if (aValues == null) {
            return null;
        }
        TypeSystem ts = aCas.getTypeSystem();
        Type emptyType = ts.getType("uima.cas.EmptyIntegerList");
        if (aValues.size() == 0) {
            return (T)aCas.createFS(emptyType);
        }
        Type nonEmptyType = ts.getType("uima.cas.NonEmptyIntegerList");
        Feature headFeature = nonEmptyType.getFeatureByBaseName("head");
        Feature tailFeature = nonEmptyType.getFeatureByBaseName("tail");
        FeatureStructure list = head = aCas.createFS(nonEmptyType);
        Iterator<Integer> i = aValues.iterator();
        while (i.hasNext()) {
            head.setIntValue(headFeature, i.next().intValue());
            if (i.hasNext()) {
                FeatureStructure tail = aCas.createFS(nonEmptyType);
                head.setFeatureValue(tailFeature, tail);
                head = tail;
                continue;
            }
            head.setFeatureValue(tailFeature, aCas.createFS(emptyType));
        }
        return (T)list;
    }

    public static IntegerList createIntegerList(JCas aJCas, Collection<Integer> aCollection) {
        return (IntegerList)FSCollectionFactory.createIntegerList(aJCas.getCas(), aCollection);
    }

    public static StringList createStringList(JCas aJCas, String ... aValues) {
        return (StringList)FSCollectionFactory.createStringList(aJCas.getCas(), aValues);
    }

    public static <T extends FeatureStructure> T createStringList(CAS aCas, String ... aValues) {
        return FSCollectionFactory.createStringList(aCas, Arrays.asList(aValues));
    }

    public static <T extends FeatureStructure> T createStringList(CAS aCas, Collection<String> aValues) {
        FeatureStructure head;
        if (aValues == null) {
            return null;
        }
        TypeSystem ts = aCas.getTypeSystem();
        Type emptyType = ts.getType("uima.cas.EmptyStringList");
        if (aValues.size() == 0) {
            return (T)aCas.createFS(emptyType);
        }
        Type nonEmptyType = ts.getType("uima.cas.NonEmptyStringList");
        Feature headFeature = nonEmptyType.getFeatureByBaseName("head");
        Feature tailFeature = nonEmptyType.getFeatureByBaseName("tail");
        FeatureStructure list = head = aCas.createFS(nonEmptyType);
        Iterator<String> i = aValues.iterator();
        while (i.hasNext()) {
            head.setStringValue(headFeature, i.next());
            if (i.hasNext()) {
                FeatureStructure tail = aCas.createFS(nonEmptyType);
                head.setFeatureValue(tailFeature, tail);
                head = tail;
                continue;
            }
            head.setFeatureValue(tailFeature, aCas.createFS(emptyType));
        }
        return (T)list;
    }

    public static StringList createStringList(JCas aJCas, Collection<String> aCollection) {
        return (StringList)FSCollectionFactory.createStringList(aJCas.getCas(), aCollection);
    }

    private static class AnnotationIndexAdapter<T extends AnnotationFS>
    extends AbstractCollection<T> {
        private final AnnotationIndex<T> index;

        public AnnotationIndexAdapter(AnnotationIndex<T> aIndex) {
            this.index = aIndex;
        }

        @Override
        public Iterator<T> iterator() {
            return this.index.withSnapshotIterators().iterator();
        }

        @Override
        public int size() {
            return this.index.size();
        }
    }

    private static class FSIteratorAdapter<T extends FeatureStructure>
    extends AbstractCollection<T> {
        private int sizeCache = -1;
        private final FSIterator<T> index;

        public FSIteratorAdapter(FSIterator<T> aIterator) {
            this.index = aIterator.copy();
            this.index.moveToFirst();
        }

        @Override
        public Iterator<T> iterator() {
            return this.index.copy();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            if (this.sizeCache == -1) {
                FSIteratorAdapter fSIteratorAdapter = this;
                synchronized (fSIteratorAdapter) {
                    if (this.sizeCache == -1) {
                        FSIterator clone = this.index.copy();
                        clone.moveToFirst();
                        this.sizeCache = 0;
                        while (clone.isValid()) {
                            ++this.sizeCache;
                            clone.moveToNext();
                        }
                    }
                }
            }
            return this.sizeCache;
        }
    }
}

