/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;

public class TrustPacket
extends ContainedPacket {
    byte[] levelAndTrustAmount;

    public TrustPacket(BCPGInputStream bCPGInputStream) throws IOException {
        this(bCPGInputStream, false);
    }

    public TrustPacket(BCPGInputStream bCPGInputStream, boolean bl) throws IOException {
        super(12, bl);
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = bCPGInputStream.read()) >= 0) {
            byteArrayOutputStream.write(n);
        }
        this.levelAndTrustAmount = byteArrayOutputStream.toByteArray();
    }

    public TrustPacket(int n) {
        super(12);
        this.levelAndTrustAmount = new byte[1];
        this.levelAndTrustAmount[0] = (byte)n;
    }

    public byte[] getLevelAndTrustAmount() {
        return this.levelAndTrustAmount;
    }

    @Override
    public void encode(BCPGOutputStream bCPGOutputStream) throws IOException {
        bCPGOutputStream.writePacket(this.hasNewPacketFormat(), 12, this.levelAndTrustAmount);
    }
}

