/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.glassfish.tooling.server.parser;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/**
 * Abstract Java configuration XML element reader.
 * <p/>
 * @author Peter Benedikovic, Tomas Kraus
 */
public abstract class ConfigReaderJava
extends AbstractReader implements XMLReader {

    // Class attributes                                                       //
    /** <code>version</code> XML element attribute name. */
    private static final String VERSION_ATTR = "version";

    // Instance attributes                                                    //
    /** Highest JavaEE specification version implemented. */
    private String version;

    // Constructors                                                           //
    /**
     * Creates an instance of Java EE configuration XML element reader.
     * <p/>
     * @param pathPrefix Tree parser path prefix to be prepended before
     *        current XML element.
     * @param node       XML element name.
     */
    ConfigReaderJava(final String pathPrefix, String node) {
        super(pathPrefix, node);
        version = null;
    }

    // Tree parser methods                                                    //
    /**
     * Process attributes from current XML element.
     * <p/>
     * @param qname      Not used.
     * @param attributes List of XML attributes.
     * @throws SAXException When any problem occurs.
     */
    @Override
    public void readAttributes(final String qname, final Attributes attributes)
            throws SAXException {
        version = attributes.getValue(VERSION_ATTR);
    }

    // Getters and setters                                                    //
    /**
     * Get highest JavaEE specification version implemented.
     * <p/>
     * @return Highest JavaEE specification version implemented.
     */
    String getVersion() {
        return version;
    }

    // Methods                                                                //
    /**
     * Reset this XML element reader.
     */
    void reset() {
        version = null;
    }

}
