/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.tenant;

import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.authorization.Tenant;
import org.apache.nifi.registry.authorization.UserGroup;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.TenantsClient;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.command.registry.tenant.TenantHelper;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class UpdateUserGroup
extends AbstractNiFiRegistryCommand<VoidResult> {
    public UpdateUserGroup() {
        super("update-user-group", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Updates existing user group.";
    }

    @Override
    protected void doInitialize(Context context) {
        this.addOption(CommandOption.UG_ID.createOption());
        this.addOption(CommandOption.UG_NAME.createOption());
        this.addOption(CommandOption.USER_NAME_LIST.createOption());
        this.addOption(CommandOption.USER_ID_LIST.createOption());
    }

    @Override
    public VoidResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        TenantsClient tenantsClient = client.getTenantsClient();
        String groupId = this.getRequiredArg(properties, CommandOption.UG_ID);
        UserGroup existingGroup = tenantsClient.getUserGroup(groupId);
        String groupName = this.getArg(properties, CommandOption.UG_NAME);
        if (StringUtils.isNotBlank((CharSequence)groupName)) {
            existingGroup.setIdentity(groupName);
        }
        Set<Tenant> users = TenantHelper.selectExistingTenants(this.getArg(properties, CommandOption.USER_NAME_LIST), this.getArg(properties, CommandOption.USER_ID_LIST), tenantsClient.getUsers());
        existingGroup.setUsers(users);
        tenantsClient.updateUserGroup(existingGroup);
        return VoidResult.getInstance();
    }
}

