/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.communication.request.batch;

import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.olingo.client.api.communication.response.ODataResponse;
import org.apache.olingo.client.core.communication.request.batch.AbstractODataBatchResponseItem;
import org.apache.olingo.client.core.communication.request.batch.ODataBatchUtilities;
import org.apache.olingo.client.core.communication.response.AsyncResponseImpl;
import org.apache.olingo.client.core.communication.response.batch.ODataBatchErrorResponse;

public class ODataSingleResponseItem
extends AbstractODataBatchResponseItem {
    public static final String SINGLE_CONTENT_ID = "__SINGLE__";

    public ODataSingleResponseItem() {
        super(false);
    }

    @Override
    public ODataResponse next() {
        if (this.closed) {
            throw new IllegalStateException("Invalid request - the item has been closed");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No item found");
        }
        Map.Entry<Integer, String> responseLine = ODataBatchUtilities.readResponseLine(this.batchLineIterator);
        LOG.debug("Retrieved item response {}", (Object)responseLine);
        Map<String, Collection<String>> headers = ODataBatchUtilities.readHeaders(this.batchLineIterator);
        LOG.debug("Retrieved item headers {}", (Object)headers);
        if (responseLine.getKey() == 202) {
            this.current = new AsyncResponseImpl(responseLine, headers, this.batchLineIterator, this.boundary);
            this.breaking = true;
        } else if (responseLine.getKey() >= 400) {
            this.current = new ODataBatchErrorResponse(responseLine, headers, this.batchLineIterator, this.boundary);
            this.breaking = true;
        } else {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No item found");
            }
            this.current = ((ODataResponse)this.expectedItemsIterator.next()).initFromBatch(responseLine, headers, this.batchLineIterator, this.boundary);
        }
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation not supported.");
    }

    @Override
    public void close() {
        super.close();
        if (this.current != null && !(this.current instanceof AsyncResponseImpl) && !(this.current instanceof ODataBatchErrorResponse)) {
            this.current.close();
        }
    }
}

