/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.commons.core.edm.annotation;

import org.apache.olingo.commons.api.edm.Edm;
import org.apache.olingo.commons.api.edm.EdmException;
import org.apache.olingo.commons.api.edm.annotation.EdmExpression;
import org.apache.olingo.commons.api.edm.annotation.EdmIf;
import org.apache.olingo.commons.api.edm.provider.annotation.CsdlIf;
import org.apache.olingo.commons.core.edm.annotation.AbstractEdmAnnotatableDynamicExpression;

public class EdmIfImpl
extends AbstractEdmAnnotatableDynamicExpression
implements EdmIf {
    private EdmExpression guard;
    private EdmExpression _then;
    private EdmExpression _else;
    private CsdlIf csdlExp;

    public EdmIfImpl(Edm edm, CsdlIf csdlExp) {
        super(edm, "If", csdlExp);
        this.csdlExp = csdlExp;
    }

    @Override
    public EdmExpression getGuard() {
        if (this.guard == null) {
            if (this.csdlExp.getGuard() == null) {
                throw new EdmException("Guard clause of an if expression must not be null");
            }
            this.guard = EdmIfImpl.getExpression(this.edm, this.csdlExp.getGuard());
        }
        return this.guard;
    }

    @Override
    public EdmExpression getThen() {
        if (this._then == null) {
            if (this.csdlExp.getThen() == null) {
                throw new EdmException("Then clause of an if expression must not be null");
            }
            this._then = EdmIfImpl.getExpression(this.edm, this.csdlExp.getThen());
        }
        return this._then;
    }

    @Override
    public EdmExpression getElse() {
        if (this._else == null && this.csdlExp.getElse() != null) {
            this._else = EdmIfImpl.getExpression(this.edm, this.csdlExp.getElse());
        }
        return this._else;
    }

    @Override
    public EdmExpression.EdmExpressionType getExpressionType() {
        return EdmExpression.EdmExpressionType.If;
    }
}

