/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.ext.proxy.commons;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.client.api.domain.ClientAnnotation;
import org.apache.olingo.client.api.domain.ClientComplexValue;
import org.apache.olingo.client.api.domain.ClientEntity;
import org.apache.olingo.client.api.domain.ClientValuable;
import org.apache.olingo.ext.proxy.AbstractService;
import org.apache.olingo.ext.proxy.api.AbstractTerm;
import org.apache.olingo.ext.proxy.api.Annotatable;
import org.apache.olingo.ext.proxy.api.annotations.Namespace;
import org.apache.olingo.ext.proxy.api.annotations.Term;
import org.apache.olingo.ext.proxy.commons.AbstractInvocationHandler;
import org.apache.olingo.ext.proxy.commons.AbstractStructuredInvocationHandler;
import org.apache.olingo.ext.proxy.commons.ComplexInvocationHandler;
import org.apache.olingo.ext.proxy.commons.EntityInvocationHandler;
import org.apache.olingo.ext.proxy.context.AttachedEntityStatus;
import org.apache.olingo.ext.proxy.utils.CoreUtils;

public class AnnotatableInvocationHandler
extends AbstractInvocationHandler
implements Annotatable {
    private static final long serialVersionUID = 3111228269617223332L;
    private final String propName;
    private final String navPropName;
    private final EntityInvocationHandler entityHandler;
    private final AbstractStructuredInvocationHandler targetHandler;
    private final Map<Class<? extends AbstractTerm>, Object> annotations = new HashMap<Class<? extends AbstractTerm>, Object>();

    public AnnotatableInvocationHandler(AbstractService<?> service, String propName, String navPropName, EntityInvocationHandler entityHandler, AbstractStructuredInvocationHandler targetHandler) {
        super(service);
        this.propName = propName;
        this.navPropName = navPropName;
        this.entityHandler = entityHandler;
        this.targetHandler = targetHandler;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.invokeSelfMethod(method, args);
    }

    public Map<Class<? extends AbstractTerm>, Object> getAnnotations() {
        return this.annotations;
    }

    private List<ClientAnnotation> internalAnnotations() {
        List<ClientAnnotation> result = Collections.emptyList();
        if (this.targetHandler.getInternal() instanceof ClientEntity) {
            result = this.propName == null ? ((ClientEntity)this.targetHandler.getInternal()).getNavigationLink(this.navPropName).getAnnotations() : ((ClientEntity)this.targetHandler.getInternal()).getProperty(this.propName).getAnnotations();
        } else if (this.targetHandler.getInternal() instanceof ClientComplexValue) {
            result = this.propName == null ? ((ClientComplexValue)this.targetHandler.getInternal()).getNavigationLink(this.navPropName).getAnnotations() : ((ClientComplexValue)this.targetHandler.getInternal()).get(this.propName).getAnnotations();
        }
        return result;
    }

    @Override
    public void addAnnotation(Class<? extends AbstractTerm> term, Object value) {
        this.annotations.put(term, value);
        if (value != null) {
            Collection<Object> coll = Collection.class.isAssignableFrom(value.getClass()) ? (Collection)Collection.class.cast(value) : Collections.singleton(value);
            for (Object e : coll) {
                InvocationHandler handler;
                if (!(e instanceof Proxy) || !((handler = Proxy.getInvocationHandler(e)) instanceof ComplexInvocationHandler) || ((ComplexInvocationHandler)handler).getEntityHandler() != null) continue;
                ((ComplexInvocationHandler)handler).setEntityHandler(this.entityHandler);
            }
        }
        this.entityHandler.attach(AttachedEntityStatus.CHANGED);
        if (this.navPropName == null) {
            this.targetHandler.putPropAnnotatableHandler(this.propName, this);
        } else {
            this.targetHandler.putNavPropAnnotatableHandler(this.navPropName, this);
        }
    }

    @Override
    public void removeAnnotation(Class<? extends AbstractTerm> term) {
        this.annotations.remove(term);
        this.entityHandler.attach(AttachedEntityStatus.CHANGED);
        if (this.navPropName == null) {
            this.targetHandler.putPropAnnotatableHandler(this.propName, this);
        } else {
            this.targetHandler.putNavPropAnnotatableHandler(this.navPropName, this);
        }
    }

    @Override
    public Object readAnnotation(Class<? extends AbstractTerm> term) {
        Object res = null;
        if (this.annotations.containsKey(term)) {
            res = this.annotations.get(term);
        } else {
            try {
                Term termAnn = term.getAnnotation(Term.class);
                Namespace namespaceAnn = term.getAnnotation(Namespace.class);
                ClientValuable annotation = null;
                for (ClientAnnotation _annotation : this.internalAnnotations()) {
                    if (!(namespaceAnn.value() + "." + termAnn.name()).equals(_annotation.getTerm())) continue;
                    annotation = _annotation;
                }
                Object object = res = annotation == null || annotation.hasNullValue() ? null : CoreUtils.getObjectFromODataValue(annotation.getValue(), null, this.targetHandler.service);
                if (res != null) {
                    this.annotations.put(term, res);
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Error getting annotation for term '" + term.getName() + "'", e);
            }
        }
        return res;
    }

    @Override
    public Collection<Class<? extends AbstractTerm>> readAnnotationTerms() {
        return CoreUtils.getAnnotationTerms(this.service, this.internalAnnotations());
    }
}

