/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.requests;

import org.apache.olingo.commons.api.data.ContextURL;
import org.apache.olingo.commons.api.edm.EdmReturnType;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.serializer.CustomContentTypeSupport;
import org.apache.olingo.server.api.serializer.RepresentationType;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.queryoption.FormatOption;
import org.apache.olingo.server.core.ContentNegotiator;
import org.apache.olingo.server.core.ContentNegotiatorException;
import org.apache.olingo.server.core.ServiceRequest;

public abstract class OperationRequest
extends ServiceRequest {
    private boolean countRequest;

    public OperationRequest(OData odata, ServiceMetadata serviceMetadata) {
        super(odata, serviceMetadata);
    }

    @Override
    public ContentType getResponseContentType() throws ContentNegotiatorException {
        if (!this.hasReturnType()) {
            return ContentType.APPLICATION_OCTET_STREAM;
        }
        if (this.isReturnTypePrimitive()) {
            return ContentNegotiator.doContentNegotiation((FormatOption)this.uriInfo.getFormatOption(), (ODataRequest)this.request, (CustomContentTypeSupport)this.getCustomContentTypeSupport(), (RepresentationType)(this.isCollection() ? RepresentationType.COLLECTION_PRIMITIVE : RepresentationType.PRIMITIVE));
        }
        if (this.isReturnTypeComplex()) {
            return ContentNegotiator.doContentNegotiation((FormatOption)this.uriInfo.getFormatOption(), (ODataRequest)this.request, (CustomContentTypeSupport)this.getCustomContentTypeSupport(), (RepresentationType)(this.isCollection() ? RepresentationType.COLLECTION_COMPLEX : RepresentationType.COMPLEX));
        }
        return ContentNegotiator.doContentNegotiation((FormatOption)this.uriInfo.getFormatOption(), (ODataRequest)this.request, (CustomContentTypeSupport)this.getCustomContentTypeSupport(), (RepresentationType)(this.isCollection() ? RepresentationType.COLLECTION_ENTITY : RepresentationType.ENTITY));
    }

    public abstract boolean isBound();

    public abstract boolean isCollection();

    public abstract EdmReturnType getReturnType();

    public abstract boolean hasReturnType();

    public ContextURL getContextURL(OData odata) throws SerializerException {
        if (!this.hasReturnType()) {
            return null;
        }
        if (this.isReturnTypePrimitive() || this.isReturnTypeComplex()) {
            ContextURL.Builder builder = ContextURL.with().type(this.getReturnType().getType());
            if (this.isCollection()) {
                builder.asCollection();
            }
            return builder.build();
        }
        ContextURL.Builder builder = ContextURL.with().type(this.getReturnType().getType());
        if (this.isCollection()) {
            builder.asCollection();
        }
        return builder.build();
    }

    public boolean isReturnTypePrimitive() {
        return this.getReturnType().getType().getKind() == EdmTypeKind.PRIMITIVE;
    }

    public boolean isReturnTypeComplex() {
        return this.getReturnType().getType().getKind() == EdmTypeKind.COMPLEX;
    }

    public boolean isCountRequest() {
        return this.countRequest;
    }

    public void setCountRequest(boolean countRequest) {
        this.countRequest = countRequest;
    }
}

