/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.header;

import javax.servlet.http.HttpServletRequest;
import org.apache.servicecomb.common.rest.codec.RestClientRequest;
import org.apache.servicecomb.common.rest.codec.RestObjectMapperFactory;
import org.apache.servicecomb.common.rest.codec.header.HeaderCodec;
import org.apache.servicecomb.common.rest.codec.param.HeaderProcessorCreator;

public class HeaderCodecSimple
implements HeaderCodec {
    public static final String NAME = "simple";

    @Override
    public String getCodecName() {
        return NAME;
    }

    @Override
    public void encode(RestClientRequest clientRequest, String name, Object value) throws Exception {
        if (null == value) {
            return;
        }
        clientRequest.putHeader(name, RestObjectMapperFactory.getConsumerWriterMapper().convertToString(value));
    }

    @Override
    public Object decode(HeaderProcessorCreator.HeaderProcessor processor, HttpServletRequest request) {
        Object value = request.getHeader(processor.getParameterPath());
        if (value == null) {
            value = processor.checkRequiredAndDefaultValue();
        }
        return processor.convertValue(value, processor.getTargetType());
    }
}

