/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.discovery;

import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.DiscoveryFilter;
import org.apache.servicecomb.registry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDiscoveryFilter
implements DiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDiscoveryFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiscoveryTreeNode discovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        String childName;
        DiscoveryTreeNode node;
        if (!parent.childrenInited()) {
            DiscoveryTreeNode discoveryTreeNode = parent;
            synchronized (discoveryTreeNode) {
                if (!parent.childrenInited()) {
                    this.init(context, parent);
                    parent.childrenInited(true);
                }
            }
        }
        if ((node = parent.child(childName = this.findChildName(context, parent))) == null) {
            LOGGER.warn("discovery filter {}/{} return null.", (Object)this.getClass().getName(), (Object)childName);
            return (DiscoveryTreeNode)new DiscoveryTreeNode().subName(parent, "empty").data(new HashMap());
        }
        if (node.data() == null || ((Map)node.data()).isEmpty()) {
            LOGGER.info("discovery filter {}/{} return empty data.", (Object)this.getClass().getName(), (Object)childName);
        }
        return node;
    }

    protected abstract void init(DiscoveryContext var1, DiscoveryTreeNode var2);

    protected abstract String findChildName(DiscoveryContext var1, DiscoveryTreeNode var2);
}

