/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.parser;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.parser.PropertiesParser;
import org.apache.servicecomb.config.parser.RawParser;
import org.apache.servicecomb.config.parser.YamlParser;

public interface Parser {
    public static final String CONTENT_TYPE_YAML = "yaml";
    public static final String CONTENT_TYPE_PROPERTIES = "properties";
    public static final String CONTENT_TYPE_RAW = "raw";
    public static final YamlParser yamlParser = new YamlParser();
    public static final PropertiesParser propertiesParser = new PropertiesParser();
    public static final RawParser rawParser = new RawParser();

    public Map<String, Object> parse(String var1, String var2, boolean var3);

    public static Parser findParser(String contentType) {
        switch (contentType) {
            case "yaml": {
                return yamlParser;
            }
            case "properties": {
                return propertiesParser;
            }
            case "raw": {
                return rawParser;
            }
        }
        throw new IllegalArgumentException("not supported contentType=" + contentType);
    }

    public static Map<String, Object> propertiesToMap(Properties properties, String prefix, boolean addPrefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = properties.getProperty(key);
            if (addPrefix && !StringUtils.isEmpty((CharSequence)prefix)) {
                key = prefix + "." + key;
            }
            if (value == null) {
                result.put(key, null);
                continue;
            }
            result.put(key, value.trim());
        }
        return result;
    }
}

