/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.provider;

import com.netflix.config.ConcurrentCompositeConfiguration;
import com.netflix.config.DynamicPropertyFactory;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessController {
    private static final Logger LOG = LoggerFactory.getLogger(AccessController.class);
    private static final String KEY_WHITE_LIST_PREFIX = "servicecomb.publicKey.accessControl.white";
    private static final String KEY_BLACK_LIST_PREFIX = "servicecomb.publicKey.accessControl.black";
    private static final String KEY_PROPERTY_NAME = "%s.%s.propertyName";
    private static final String KEY_CATEGORY = "%s.%s.category";
    private static final String KEY_RULE_POSTFIX = ".rule";
    private Map<String, ConfigurationItem> whiteList = new HashMap<String, ConfigurationItem>();
    private Map<String, ConfigurationItem> blackList = new HashMap<String, ConfigurationItem>();

    public AccessController() {
        this.loadConfigurations(KEY_BLACK_LIST_PREFIX);
        this.loadConfigurations(KEY_WHITE_LIST_PREFIX);
    }

    public boolean isAllowed(Microservice microservice) {
        return this.whiteAllowed(microservice) && !this.blackDenied(microservice);
    }

    private boolean whiteAllowed(Microservice microservice) {
        if (this.whiteList.isEmpty()) {
            return true;
        }
        return this.matchFound(microservice, this.whiteList);
    }

    private boolean blackDenied(Microservice microservice) {
        if (this.blackList.isEmpty()) {
            return false;
        }
        return this.matchFound(microservice, this.blackList);
    }

    private boolean matchFound(Microservice microservice, Map<String, ConfigurationItem> ruleList) {
        boolean matched = false;
        for (ConfigurationItem item : ruleList.values()) {
            if (!"property".equals(item.category) || !this.matchMicroserviceField(microservice, item) && !this.matchMicroserviceProperties(microservice, item)) continue;
            return true;
        }
        return matched;
    }

    private boolean matchMicroserviceProperties(Microservice microservice, ConfigurationItem item) {
        Map properties = microservice.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            if (!((String)entry.getKey()).equals(item.propertyName)) continue;
            return this.isPatternMatch((String)entry.getValue(), item.rule);
        }
        return false;
    }

    private boolean matchMicroserviceField(Microservice microservice, ConfigurationItem item) {
        Object fieldValue = null;
        try {
            fieldValue = new PropertyDescriptor(item.propertyName, Microservice.class).getReadMethod().invoke((Object)microservice, new Object[0]);
        }
        catch (Exception e) {
            if (DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.error.printSensitiveErrorMessage", false).get()) {
                LOG.warn("can't find propertyname: {} in microservice field, will search in microservice properties.", (Object)item.propertyName, (Object)e);
            } else {
                LOG.warn("can't find propertyname: {} in microservice field, will search in microservice properties.", (Object)item.propertyName);
            }
            return false;
        }
        if (fieldValue.getClass().getName().equals(String.class.getName())) {
            return this.isPatternMatch((String)fieldValue, item.rule);
        }
        return false;
    }

    private boolean isPatternMatch(String value, String pattern) {
        if (pattern.startsWith("*")) {
            return value.endsWith(pattern.substring(1));
        }
        if (pattern.endsWith("*")) {
            return value.startsWith(pattern.substring(0, pattern.length() - 1));
        }
        return value.equals(pattern);
    }

    private void loadConfigurations(String prefix) {
        ConcurrentCompositeConfiguration config = (ConcurrentCompositeConfiguration)DynamicPropertyFactory.getBackingConfigurationSource();
        this.loadConfigurations(config, prefix);
        config.addConfigurationListener(event -> {
            if (event.getPropertyName().startsWith(prefix)) {
                LOG.info("Access rule have been changed. Reload configurations. Event=" + event.getType());
                this.loadConfigurations(config, prefix);
            }
        });
    }

    private void loadConfigurations(ConcurrentCompositeConfiguration config, String prefix) {
        HashMap<String, ConfigurationItem> configurations = new HashMap<String, ConfigurationItem>();
        Iterator configsItems = config.getKeys(prefix);
        while (configsItems.hasNext()) {
            String pathKey = (String)configsItems.next();
            if (!pathKey.endsWith(KEY_RULE_POSTFIX)) continue;
            ConfigurationItem configurationItem = new ConfigurationItem();
            String rule = DynamicPropertyFactory.getInstance().getStringProperty(pathKey, null).get();
            if (StringUtils.isEmpty((CharSequence)rule)) continue;
            configurationItem.rule = rule;
            String pathKeyItem = pathKey.substring(prefix.length() + 1, pathKey.length() - KEY_RULE_POSTFIX.length());
            configurationItem.propertyName = DynamicPropertyFactory.getInstance().getStringProperty(String.format(KEY_PROPERTY_NAME, prefix, pathKeyItem), null).get();
            if (StringUtils.isEmpty((CharSequence)configurationItem.propertyName)) continue;
            configurationItem.category = DynamicPropertyFactory.getInstance().getStringProperty(String.format(KEY_CATEGORY, prefix, pathKeyItem), null).get();
            if (StringUtils.isEmpty((CharSequence)configurationItem.category)) continue;
            configurations.put(pathKeyItem, configurationItem);
        }
        if (KEY_WHITE_LIST_PREFIX.equals(prefix)) {
            this.whiteList = configurations;
            this.logConfigurations(configurations, true);
        } else {
            this.blackList = configurations;
            this.logConfigurations(configurations, false);
        }
    }

    private void logConfigurations(Map<String, ConfigurationItem> configurations, boolean isWhite) {
        configurations.forEach((key, item) -> LOG.info((isWhite ? "White list " : "Black list ") + "config item: key=" + key + ";category=" + item.category + ";propertyName=" + item.propertyName + ";rule=" + item.rule));
    }

    static class ConfigurationItem {
        static final String CATEGORY_PROPERTY = "property";
        String category;
        String propertyName;
        String rule;

        ConfigurationItem() {
        }
    }
}

