/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.Static;
import org.apache.sis.util.collection.DerivedMap;
import org.apache.sis.util.collection.DerivedSet;
import org.apache.sis.util.internal.shared.UnmodifiableArrayList;
import org.apache.sis.util.resources.Errors;

public final class Containers
extends Static {
    private Containers() {
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    @SafeVarargs
    public static <E> List<? extends E> unmodifiableList(E ... array) {
        return UnmodifiableArrayList.wrap(array);
    }

    public static <E> List<? extends E> unmodifiableList(E[] array, int lower, int upper) {
        Objects.checkFromToIndex(lower, upper, array.length);
        return UnmodifiableArrayList.wrap(array, lower, upper);
    }

    public static <S, E> Set<E> derivedSet(Set<S> storage, ObjectConverter<S, E> converter) {
        ArgumentChecks.ensureNonNull("converter", converter);
        if (storage == null) {
            return null;
        }
        return DerivedSet.create(storage, converter);
    }

    public static <SK, SV, K, V> Map<K, V> derivedMap(Map<SK, SV> storage, ObjectConverter<SK, K> keyConverter, ObjectConverter<SV, V> valueConverter) {
        ArgumentChecks.ensureNonNull("keyConverter", keyConverter);
        ArgumentChecks.ensureNonNull("valueConverter", valueConverter);
        if (storage == null) {
            return null;
        }
        return DerivedMap.create(storage, keyConverter, valueConverter);
    }

    public static <T> T property(Map<?, ?> properties, Object key, Class<T> type) throws IllegalArgumentException {
        if (properties == null) {
            return null;
        }
        Object value = properties.get(key);
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException(Errors.forProperties(properties).getString((short)74, key, type, value.getClass()));
        }
        return (T)value;
    }

    public static int hashMapCapacity(int count) {
        return (count * 4 + 2) / 3;
    }

    public static <E extends Comparable<E>> int compare(Iterator<E> it1, Iterator<? extends E> it2) {
        while (it1.hasNext()) {
            Comparable o2;
            if (!it2.hasNext()) {
                return 1;
            }
            Comparable o1 = (Comparable)it1.next();
            if (o1 == (o2 = (Comparable)it2.next())) continue;
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int c = o1.compareTo(o2);
            if (c == 0) continue;
            return c;
        }
        return it2.hasNext() ? -1 : 0;
    }
}

