/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.awt.image.RenderedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageBuilder;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridRoundingMode;
import org.apache.sis.coverage.grid.PixelInCell;
import org.apache.sis.storage.AbstractGridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.apache.sis.storage.event.StoreListeners;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.GenericName;

public class MemoryGridResource
extends AbstractGridCoverageResource {
    public final GridCoverage coverage;
    private final GridCoverageProcessor processor;
    private final GenericName identifer;
    private boolean deferredRendering;

    public MemoryGridResource(StoreListeners parent, GenericName identifier, GridCoverage coverage, GridCoverageProcessor processor) {
        super(parent, false);
        this.identifer = identifier;
        this.coverage = Objects.requireNonNull(coverage);
        this.processor = processor != null ? processor : new GridCoverageProcessor();
    }

    @Override
    public Optional<GenericName> getIdentifier() {
        return Optional.ofNullable(this.identifer);
    }

    @Override
    public GridGeometry getGridGeometry() {
        return this.coverage.getGridGeometry();
    }

    @Override
    public List<SampleDimension> getSampleDimensions() {
        return this.coverage.getSampleDimensions();
    }

    @Override
    public RasterLoadingStrategy getLoadingStrategy() {
        return this.deferredRendering ? RasterLoadingStrategy.AT_RENDER_TIME : RasterLoadingStrategy.AT_READ_TIME;
    }

    @Override
    public boolean setLoadingStrategy(RasterLoadingStrategy strategy) {
        this.deferredRendering = !strategy.equals((Object)RasterLoadingStrategy.AT_READ_TIME);
        return strategy == this.getLoadingStrategy();
    }

    @Override
    public GridCoverage read(GridGeometry domain, int ... ranges) {
        GridCoverage subset = this.coverage;
        if (ranges != null && ranges.length != 0) {
            subset = this.processor.selectSampleDimensions(subset, ranges);
        }
        if (domain == null) {
            return subset;
        }
        GridGeometry source = subset.getGridGeometry();
        GridExtent intersection = source.derive().rounding(GridRoundingMode.ENCLOSING).subgrid(domain).getIntersection();
        if (this.deferredRendering || intersection.getDegreesOfFreedom() > 2) {
            return this.processor.clip(subset, intersection);
        }
        if (intersection.contains(source.getExtent())) {
            return subset;
        }
        int[] gridDimensions = intersection.getSubspaceDimensions(2);
        int dimX = gridDimensions[0];
        int dimY = gridDimensions[1];
        RenderedImage data = subset.render(intersection);
        long ox = intersection.getLow(dimX);
        long oy = intersection.getLow(dimY);
        long[] changes = new long[Math.max(dimX, dimY) + 1];
        int i = changes.length;
        while (--i >= 0) {
            changes[i] = intersection.getSize(i);
        }
        changes[dimX] = data.getWidth();
        changes[dimY] = data.getHeight();
        intersection = intersection.resize(changes);
        Arrays.fill(changes, 0L);
        changes[dimX] = Math.addExact(ox - intersection.getLow(dimX), (long)data.getMinX());
        changes[dimY] = Math.addExact(oy - intersection.getLow(dimY), (long)data.getMinX());
        intersection = intersection.translate(changes);
        if (intersection.equals((Object)source.getExtent())) {
            return subset;
        }
        CoordinateReferenceSystem crs = source.isDefined(1) ? source.getCoordinateReferenceSystem() : null;
        domain = new GridGeometry(intersection, PixelInCell.CELL_CORNER, source.getGridToCRS(PixelInCell.CELL_CORNER), crs);
        return new GridCoverageBuilder().setValues(data).setDomain(domain).setRanges((Collection)subset.getSampleDimensions()).build();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            MemoryGridResource other = (MemoryGridResource)obj;
            return Objects.equals(this.identifer, other.identifer) && this.coverage.equals(other.coverage) && this.processor.equals((Object)other.processor) && this.listeners.equals(other.listeners);
        }
        return false;
    }

    public int hashCode() {
        return this.coverage.hashCode() + 17 * Objects.hashCode(this.identifer) + 31 * this.processor.hashCode() + 37 * this.listeners.hashCode();
    }

    public String toString() {
        return this.coverage.toString();
    }
}

