/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.Namespaces;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.TransformedEvent;
import org.apache.sis.xml.Transformer;
import org.apache.sis.xml.TransformingNamespaces;

final class TransformingWriter
extends Transformer
implements XMLEventWriter {
    private static final String FILENAME = "RenameOnExport.lst";
    private static final Map<String, Map<String, String>> NAMESPACES = TransformingWriter.load(true, "RenameOnExport.lst", Set.of(), 60);
    private static final Map<QName, Set<QName>> ELEMENTS_TO_REORDER;
    private final XMLEventWriter out;
    private final Map<String, Namespace> uniqueNamespaces;
    private boolean isDeferring;
    private final Queue<Object> deferred;
    private Set<QName> toSkip;
    private QName subtreeRootName;
    private int subtreeNesting;

    TransformingWriter(XMLEventWriter out, TransformVersion version) {
        super(version);
        this.out = out;
        this.uniqueNamespaces = new LinkedHashMap<String, Namespace>();
        this.deferred = new ArrayDeque<Object>();
    }

    @Override
    final Map<String, Map<String, String>> renamingMap(String namespace) {
        return NAMESPACES;
    }

    @Override
    final String relocate(String namespace) {
        return this.version.exportNS(namespace);
    }

    @Override
    final String prefixReplacement(String previous, String namespace) throws XMLStreamException {
        String prefix = this.out.getPrefix(namespace);
        if (prefix == null) {
            prefix = Namespaces.getPreferredPrefix(namespace, previous);
            this.out.setPrefix(prefix, namespace);
        }
        return prefix;
    }

    private Namespace exportIfNew(Namespace namespace) {
        this.notify(namespace);
        String uri = namespace.getNamespaceURI();
        if (uri != null && !uri.isEmpty()) {
            String trimed = TransformingWriter.removeTrailingSlash(uri);
            String exported = this.relocate(trimed);
            if (exported != trimed) {
                return this.uniqueNamespaces.computeIfAbsent(exported, k -> new TransformedEvent.NS(namespace, Namespaces.getPreferredPrefix(k, namespace.getPrefix()), (String)k));
            }
            Namespace c = this.uniqueNamespaces.put(uri, namespace);
            if (c != null) {
                return c;
            }
        }
        return namespace;
    }

    private List<Namespace> export(Iterator<Namespace> namespaces, boolean changed) {
        if (!namespaces.hasNext()) {
            return changed ? List.of() : null;
        }
        do {
            Namespace namespace;
            changed |= (namespace = namespaces.next()) != this.exportIfNew(namespace);
        } while (namespaces.hasNext());
        if (changed) {
            assert (!this.uniqueNamespaces.isEmpty());
            Namespace[] exported = (Namespace[])this.uniqueNamespaces.values().toArray(Namespace[]::new);
            this.uniqueNamespaces.clear();
            return Arrays.asList(exported);
        }
        this.uniqueNamespaces.clear();
        return null;
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 10: {
                event = this.convert((Attribute)event);
                break;
            }
            case 13: {
                int n = this.uniqueNamespaces.size();
                event = this.exportIfNew((Namespace)event);
                if (this.uniqueNamespaces.size() != n) break;
                return;
            }
            case 2: {
                EndElement e = event.asEndElement();
                QName originalName = e.getName();
                QName name = this.convert(originalName);
                List<Namespace> namespaces = this.export(e.getNamespaces(), name != originalName);
                if (namespaces != null) {
                    event = new TransformedEvent.End(e, name, namespaces);
                }
                if (this.toSkip != null) {
                    if (originalName.equals(this.subtreeRootName)) {
                        --this.subtreeNesting;
                    } else if (this.subtreeNesting == 0) {
                        this.writeDeferred(null);
                    }
                }
                this.close(originalName);
                break;
            }
            case 1: {
                this.uniqueNamespaces.clear();
                StartElement e = event.asStartElement();
                QName originalName = e.getName();
                this.open(originalName);
                QName name = this.convert(originalName);
                boolean changed = name != originalName;
                Iterator<Attribute> it = e.getAttributes();
                while (it.hasNext()) {
                    Attribute ae;
                    Attribute a = it.next();
                    changed |= a != (ae = this.convert(a));
                    this.renamedAttributes.add(ae);
                }
                List<Namespace> namespaces = this.export(e.getNamespaces(), changed);
                if (namespaces != null) {
                    event = new Event(e, name, namespaces, this.attributes(), this.version);
                } else {
                    this.renamedAttributes.clear();
                }
                if (this.toSkip == null) {
                    this.toSkip = ELEMENTS_TO_REORDER.get(originalName);
                    if (this.toSkip == null) break;
                    this.subtreeRootName = originalName;
                    this.subtreeNesting = 1;
                    this.isDeferring = true;
                    break;
                }
                if (this.subtreeNesting == 0) {
                    if (!this.toSkip.contains(originalName) && !this.writeDeferred(originalName)) break;
                    this.subtreeRootName = originalName;
                    this.subtreeNesting = 1;
                    Set<QName> interleaved = ELEMENTS_TO_REORDER.get(originalName);
                    if (interleaved == null) break;
                    this.isDeferring = true;
                    this.deferred.add(new NewDeferred(interleaved));
                    break;
                }
                if (!originalName.equals(this.subtreeRootName)) break;
                ++this.subtreeNesting;
                break;
            }
        }
        if (this.isDeferring) {
            this.deferred.add(event);
            this.isDeferring = this.subtreeNesting != 0;
        } else {
            this.out.add(event);
        }
    }

    private boolean writeDeferred(QName element) throws XMLStreamException {
        Object v;
        this.subtreeRootName = null;
        this.toSkip = null;
        while ((v = this.deferred.poll()) != null) {
            Set<QName> s;
            if (!(v instanceof NewDeferred)) {
                this.out.add((XMLEvent)v);
                continue;
            }
            if (element == null || !(s = ((NewDeferred)v).toSkip).contains(element)) continue;
            this.toSkip = s;
            return true;
        }
        return false;
    }

    @Override
    public void add(XMLEventReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            this.add(reader.nextEvent());
        }
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        throw new XMLStreamException(Errors.format((short)199, (Object)"getPrefix"));
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.out.setPrefix(prefix, this.relocate(uri));
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.out.setDefaultNamespace(this.relocate(uri));
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.out.setNamespaceContext(TransformingNamespaces.asXML(context, this.version));
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return TransformingNamespaces.asJAXB(this.out.getNamespaceContext(), this.version);
    }

    @Override
    public void flush() throws XMLStreamException {
        this.writeDeferred(null);
        this.out.flush();
    }

    @Override
    public void close() throws XMLStreamException {
        this.uniqueNamespaces.clear();
        super.close();
        this.out.close();
    }

    static {
        HashMap<QName, Set<QName>> m = new HashMap<QName, Set<QName>>(4);
        m.put(new QName("http://standards.iso.org/iso/19115/-3/srv/2.0", "couplingType", "srv"), Set.of(new QName("http://standards.iso.org/iso/19115/-3/srv/2.0", "coupledResource", "srv")));
        m.put(new QName("http://standards.iso.org/iso/19115/-3/srv/2.0", "connectPoint", "srv"), Set.of(new QName("http://standards.iso.org/iso/19115/-3/srv/2.0", "parameter", "srv")));
        QName first = new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "extent", "mri");
        HashSet<QName> toSkip = new HashSet<QName>(Arrays.asList(first, new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "additionalDocumentation", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "processingLevel", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "resourceMaintenance", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "graphicOverview", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "resourceFormat", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "descriptiveKeywords", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "resourceSpecificUsage", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "resourceConstraints", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "associatedResource", "mri"), new QName("http://www.isotc211.org/2005/gmd", "aggregationInfo", "gmd"), new QName("http://www.isotc211.org/2005/gmd", "language", "gmd"), new QName("http://www.isotc211.org/2005/gmd", "characterSet", "gmd"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "defaultLocale", "mri"), new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "otherLocale", "mri")));
        m.put(new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "topicCategory", "mri"), Set.copyOf(toSkip));
        toSkip.remove(first);
        toSkip.add(new QName("http://standards.iso.org/iso/19115/-3/mri/1.0", "environmentDescription", "mri"));
        m.put(first, toSkip);
        ELEMENTS_TO_REORDER = m;
    }

    private static final class Event
    extends TransformedEvent.Start {
        Event(StartElement event, QName name, List<Namespace> namespaces, List<Attribute> attributes, TransformVersion version) {
            super(event, name, namespaces, attributes, version);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.version.exportNS(((StartElement)this.event).getNamespaceURI(prefix));
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return TransformingNamespaces.asXML(((StartElement)this.event).getNamespaceContext(), this.version);
        }
    }

    private static final class NewDeferred {
        final Set<QName> toSkip;

        NewDeferred(Set<QName> toSkip) {
            this.toSkip = toSkip;
        }
    }
}

