/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.openid.impl;

import com.dyuproject.openid.OpenIdUser;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.security.auth.callback.CallbackHandler;
import org.apache.sling.auth.openid.impl.OpenIDAuthenticationHandler;
import org.apache.sling.jcr.jackrabbit.server.security.AuthenticationPlugin;
import org.apache.sling.jcr.jackrabbit.server.security.LoginModulePlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

class OpenIDLoginModulePlugin
implements LoginModulePlugin {
    private final OpenIDAuthenticationHandler authHandler;

    static ServiceRegistration register(OpenIDAuthenticationHandler authHandler, BundleContext bundleContext) {
        OpenIDLoginModulePlugin plugin = new OpenIDLoginModulePlugin(authHandler);
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("service.description", "LoginModulePlugin Support for OpenIDAuthenticationHandler");
        properties.put("service.vendor", (String)bundleContext.getBundle().getHeaders().get("Bundle-Vendor"));
        return bundleContext.registerService(LoginModulePlugin.class.getName(), (Object)plugin, properties);
    }

    private OpenIDLoginModulePlugin(OpenIDAuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    public void doInit(CallbackHandler callbackHandler, Session session, Map options) {
    }

    public boolean canHandle(Credentials credentials) {
        return this.authHandler.getOpenIdUser(credentials) != null;
    }

    public AuthenticationPlugin getAuthentication(Principal principal, Credentials creds) {
        return new AuthenticationPlugin(){

            public boolean authenticate(Credentials credentials) throws RepositoryException {
                OpenIdUser user = OpenIDLoginModulePlugin.this.authHandler.getOpenIdUser(credentials);
                if (user != null) {
                    return user.isAssociated();
                }
                throw new RepositoryException("Can't authenticate credentials of type: " + credentials.getClass());
            }
        };
    }

    public Principal getPrincipal(Credentials credentials) {
        return null;
    }

    public void addPrincipals(Set principals) {
    }

    public int impersonate(Principal principal, Credentials credentials) {
        return 0;
    }
}

