/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.internal.models;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.ComponentPolicy;
import org.apache.sling.cms.PageTemplate;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Optional;

@Model(adaptables={Resource.class}, adapters={PageTemplate.class})
public class PageTemplateImpl
implements PageTemplate {
    @Inject
    @Optional
    private String[] allowedPaths;
    @Inject
    private List<Resource> fields;
    @Inject
    @Optional
    private List<Resource> policies;
    private Resource resource;
    @Inject
    @Optional
    private String template;
    @Inject
    @Named(value="jcr:title")
    private String title;

    public PageTemplateImpl(Resource resource) {
        this.resource = resource;
    }

    public String[] getAllowedPaths() {
        if (this.allowedPaths == null) {
            return new String[0];
        }
        return this.allowedPaths;
    }

    public List<ComponentPolicy> getComponentPolicies() {
        if (this.policies != null) {
            return this.policies.stream().map(p -> (ComponentPolicy)p.adaptTo(ComponentPolicy.class)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public List<Resource> getFields() {
        return this.fields;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getTitle() {
        return this.title;
    }

    public String toString() {
        return "PageTemplateImpl [allowedPaths=" + Arrays.toString(this.allowedPaths) + ", fields=" + this.fields + ", policies=" + this.getComponentPolicies() + ", resource=" + this.resource + ", template=" + this.template + ", title=" + this.title + "]";
    }
}

